/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.util.List;
import java.util.Map;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.metrics.Metric;
import org.apache.amoro.metrics.MetricDefine;
import org.apache.amoro.metrics.MetricKey;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public abstract class AbstractTableMetrics {
    protected final ServerTableIdentifier identifier;
    protected final List<MetricKey> registeredMetricKeys = Lists.newArrayList();
    protected MetricRegistry globalRegistry;

    protected AbstractTableMetrics(ServerTableIdentifier identifier) {
        this.identifier = identifier;
    }

    protected void registerMetric(MetricRegistry registry, MetricDefine define, Metric metric) {
        MetricKey key = registry.register(define, (Map<String, String>)ImmutableMap.of((Object)"catalog", (Object)this.identifier.getCatalog(), (Object)"database", (Object)this.identifier.getDatabase(), (Object)"table", (Object)this.identifier.getTableName()), metric);
        this.registeredMetricKeys.add(key);
    }

    public void register(MetricRegistry registry) {
        if (this.globalRegistry == null) {
            this.registerMetrics(registry);
            this.globalRegistry = registry;
        }
    }

    public void unregister() {
        if (this.globalRegistry != null) {
            this.registeredMetricKeys.forEach(this.globalRegistry::unregister);
            this.registeredMetricKeys.clear();
            this.globalRegistry = null;
        }
    }

    protected abstract void registerMetrics(MetricRegistry var1);
}

