/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.List;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.CatalogMetaMapper;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.CatalogUtil;

public abstract class ServerCatalog
extends PersistentBase {
    private volatile CatalogMeta metadata;
    protected volatile TableMetaStore metaStore;

    protected ServerCatalog(CatalogMeta metadata) {
        this.metadata = metadata;
        this.metaStore = CatalogUtil.buildMetaStore((CatalogMeta)metadata);
    }

    public String name() {
        return this.metadata.getCatalogName();
    }

    public CatalogMeta getMetadata() {
        return this.metadata;
    }

    public void updateMetadata(CatalogMeta metadata) {
        this.doAs(CatalogMetaMapper.class, mapper -> mapper.updateCatalog(metadata));
        this.metadata = metadata;
        this.metaStore = CatalogUtil.buildMetaStore((CatalogMeta)metadata);
        this.catalogMetadataChanged();
    }

    public void reload() {
        CatalogMeta meta = this.getAs(CatalogMetaMapper.class, mapper -> mapper.getCatalog(this.metadata.getCatalogName()));
        if (meta == null) {
            throw new IllegalStateException("Catalog " + this.metadata.getCatalogName() + " is dropped.");
        }
        this.reload(meta);
    }

    public void reload(CatalogMeta meta) {
        if (this.metadata.equals(meta)) {
            return;
        }
        this.metadata = meta;
        this.metaStore = CatalogUtil.buildMetaStore((CatalogMeta)meta);
        this.catalogMetadataChanged();
    }

    public abstract boolean databaseExists(String var1);

    public abstract boolean tableExists(String var1, String var2);

    public abstract List<String> listDatabases();

    public abstract List<TableIDWithFormat> listTables();

    public abstract List<TableIDWithFormat> listTables(String var1);

    public abstract AmoroTable<?> loadTable(String var1, String var2);

    public void dispose() {
    }

    public boolean isInternal() {
        return false;
    }

    protected void catalogMetadataChanged() {
    }
}

