/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.procedures.AddFilesProcedure;
import org.apache.iceberg.spark.procedures.AncestorsOfProcedure;
import org.apache.iceberg.spark.procedures.CherrypickSnapshotProcedure;
import org.apache.iceberg.spark.procedures.CreateChangelogViewProcedure;
import org.apache.iceberg.spark.procedures.ExpireSnapshotsProcedure;
import org.apache.iceberg.spark.procedures.FastForwardBranchProcedure;
import org.apache.iceberg.spark.procedures.MigrateTableProcedure;
import org.apache.iceberg.spark.procedures.PublishChangesProcedure;
import org.apache.iceberg.spark.procedures.RegisterTableProcedure;
import org.apache.iceberg.spark.procedures.RemoveOrphanFilesProcedure;
import org.apache.iceberg.spark.procedures.RewriteDataFilesProcedure;
import org.apache.iceberg.spark.procedures.RewriteManifestsProcedure;
import org.apache.iceberg.spark.procedures.RewritePositionDeleteFilesProcedure;
import org.apache.iceberg.spark.procedures.RollbackToSnapshotProcedure;
import org.apache.iceberg.spark.procedures.RollbackToTimestampProcedure;
import org.apache.iceberg.spark.procedures.SetCurrentSnapshotProcedure;
import org.apache.iceberg.spark.procedures.SnapshotTableProcedure;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.Procedure;

public class SparkProcedures {
    private static final Map<String, Supplier<ProcedureBuilder>> BUILDERS = SparkProcedures.initProcedureBuilders();

    private SparkProcedures() {
    }

    public static ProcedureBuilder newBuilder(String name) {
        Supplier<ProcedureBuilder> builderSupplier = BUILDERS.get(name.toLowerCase(Locale.ROOT));
        return builderSupplier != null ? builderSupplier.get() : null;
    }

    private static Map<String, Supplier<ProcedureBuilder>> initProcedureBuilders() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"rollback_to_snapshot", RollbackToSnapshotProcedure::builder);
        mapBuilder.put((Object)"rollback_to_timestamp", RollbackToTimestampProcedure::builder);
        mapBuilder.put((Object)"set_current_snapshot", SetCurrentSnapshotProcedure::builder);
        mapBuilder.put((Object)"cherrypick_snapshot", CherrypickSnapshotProcedure::builder);
        mapBuilder.put((Object)"rewrite_data_files", RewriteDataFilesProcedure::builder);
        mapBuilder.put((Object)"rewrite_manifests", RewriteManifestsProcedure::builder);
        mapBuilder.put((Object)"remove_orphan_files", RemoveOrphanFilesProcedure::builder);
        mapBuilder.put((Object)"expire_snapshots", ExpireSnapshotsProcedure::builder);
        mapBuilder.put((Object)"migrate", MigrateTableProcedure::builder);
        mapBuilder.put((Object)"snapshot", SnapshotTableProcedure::builder);
        mapBuilder.put((Object)"add_files", AddFilesProcedure::builder);
        mapBuilder.put((Object)"ancestors_of", AncestorsOfProcedure::builder);
        mapBuilder.put((Object)"register_table", RegisterTableProcedure::builder);
        mapBuilder.put((Object)"publish_changes", PublishChangesProcedure::builder);
        mapBuilder.put((Object)"create_changelog_view", CreateChangelogViewProcedure::builder);
        mapBuilder.put((Object)"rewrite_position_delete_files", RewritePositionDeleteFilesProcedure::builder);
        mapBuilder.put((Object)"fast_forward", FastForwardBranchProcedure::builder);
        return mapBuilder.build();
    }

    public static interface ProcedureBuilder {
        public ProcedureBuilder withTableCatalog(TableCatalog var1);

        public Procedure build();
    }
}

