/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.arrow.vector.VarCharVector;
import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessor;
import org.apache.iceberg.arrow.vectorized.GenericArrowVectorAccessorFactory;
import org.apache.iceberg.arrow.vectorized.VectorHolder;

final class ArrowVectorAccessors {
    private static final GenericArrowVectorAccessorFactory<?, String, ?, ?> FACTORY = new GenericArrowVectorAccessorFactory(() -> new JavaDecimalFactory(), () -> new JavaStringFactory(), ArrowVectorAccessors.throwingSupplier("Struct type is not supported"), ArrowVectorAccessors.throwingSupplier("List type is not supported"));

    private static <T> Supplier<T> throwingSupplier(String message) {
        return () -> {
            throw new UnsupportedOperationException(message);
        };
    }

    private ArrowVectorAccessors() {
        throw new UnsupportedOperationException(ArrowVectorAccessors.class.getName() + " cannot be instantiated.");
    }

    static ArrowVectorAccessor<?, String, ?, ?> getVectorAccessor(VectorHolder holder) {
        return FACTORY.getVectorAccessor(holder);
    }

    private static final class JavaDecimalFactory
    implements GenericArrowVectorAccessorFactory.DecimalFactory<BigDecimal> {
        private JavaDecimalFactory() {
        }

        @Override
        public Class<BigDecimal> getGenericClass() {
            return BigDecimal.class;
        }

        @Override
        public BigDecimal ofLong(long value, int precision, int scale) {
            return BigDecimal.valueOf(value, scale);
        }

        @Override
        public BigDecimal ofBigDecimal(BigDecimal value, int precision, int scale) {
            return BigDecimal.valueOf(value.unscaledValue().longValue(), scale);
        }
    }

    private static final class JavaStringFactory
    implements GenericArrowVectorAccessorFactory.StringFactory<String> {
        private JavaStringFactory() {
        }

        @Override
        public Class<String> getGenericClass() {
            return String.class;
        }

        @Override
        public String ofRow(VarCharVector vector, int rowId) {
            return this.ofBytes(vector.get(rowId));
        }

        @Override
        public String ofBytes(byte[] bytes) {
            return new String(bytes, StandardCharsets.UTF_8);
        }

        @Override
        public String ofByteBuffer(ByteBuffer byteBuffer) {
            if (byteBuffer.hasArray()) {
                return new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), StandardCharsets.UTF_8);
            }
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }
}

