/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.optimizing.OptimizingType;
import org.apache.amoro.optimizing.RewriteStageTask;
import org.apache.amoro.optimizing.plan.AbstractOptimizingEvaluator;
import org.apache.amoro.optimizing.plan.AbstractPartitionPlan;
import org.apache.amoro.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.KeyedTableSnapshot;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.TableSnapshot;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptimizingPlanner
extends AbstractOptimizingEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOptimizingPlanner.class);
    private final Expression partitionFilter;
    protected long processId;
    private final double availableCore;
    protected final long planTime;
    private OptimizingType optimizingType;
    private List<RewriteStageTask> tasks;
    private List<AbstractPartitionPlan> actualPartitionPlans;
    private final long maxInputSizePerThread;

    public AbstractOptimizingPlanner(ServerTableIdentifier identifier, OptimizingConfig config, MixedTable table, TableSnapshot snapshot, Expression partitionFilter, long processId, double availableCore, long maxInputSizePerThread, long lastMinorOptimizingTime, long lastFullOptimizingTime) {
        super(identifier, config, table, snapshot, Integer.MAX_VALUE, lastMinorOptimizingTime, lastFullOptimizingTime);
        this.partitionFilter = partitionFilter;
        this.availableCore = availableCore;
        this.planTime = System.currentTimeMillis();
        this.processId = processId;
        this.maxInputSizePerThread = maxInputSizePerThread;
    }

    public Map<String, Long> getFromSequence() {
        return this.actualPartitionPlans.stream().filter(p -> p.getFromSequence() != null).collect(Collectors.toMap(partitionPlan -> {
            Pair<Integer, StructLike> partition = partitionPlan.getPartition();
            PartitionSpec spec = MixedTableUtil.getMixedTablePartitionSpecById(this.mixedTable, (Integer)partition.first());
            return spec.partitionToPath((StructLike)partition.second());
        }, AbstractPartitionPlan::getFromSequence));
    }

    public Map<String, Long> getToSequence() {
        return this.actualPartitionPlans.stream().filter(p -> p.getToSequence() != null).collect(Collectors.toMap(partitionPlan -> {
            Pair<Integer, StructLike> partition = partitionPlan.getPartition();
            PartitionSpec spec = MixedTableUtil.getMixedTablePartitionSpecById(this.mixedTable, (Integer)partition.first());
            return spec.partitionToPath((StructLike)partition.second());
        }, AbstractPartitionPlan::getToSequence));
    }

    @Override
    protected Expression getPartitionFilter() {
        if (Expressions.alwaysTrue().equals(this.partitionFilter) && !Expressions.alwaysTrue().equals(super.getPartitionFilter())) {
            return super.getPartitionFilter();
        }
        return this.partitionFilter;
    }

    public long getTargetSnapshotId() {
        return this.currentSnapshot.snapshotId();
    }

    public long getTargetChangeSnapshotId() {
        if (this.currentSnapshot instanceof KeyedTableSnapshot) {
            return ((KeyedTableSnapshot)this.currentSnapshot).changeSnapshotId();
        }
        return -1L;
    }

    @Override
    public boolean isNecessary() {
        if (!super.isNecessary()) {
            return false;
        }
        return !this.planTasks().isEmpty();
    }

    public List<RewriteStageTask> planTasks() {
        if (this.tasks != null) {
            return this.tasks;
        }
        long startTime = System.nanoTime();
        if (!this.isInitialized) {
            this.initEvaluator();
        }
        if (!super.isNecessary()) {
            LOG.debug("Table {} skip planning", (Object)this.identifier);
            return this.cacheAndReturnTasks(Collections.emptyList());
        }
        LinkedList evaluators = new LinkedList(this.needOptimizingPlanMap.values());
        evaluators.sort(Comparator.comparing(PartitionEvaluator::getWeight, Comparator.reverseOrder()));
        double maxInputSize = (double)this.maxInputSizePerThread * this.availableCore;
        this.actualPartitionPlans = Lists.newArrayList();
        long actualInputSize = 0L;
        ArrayList plannedTasks = Lists.newArrayList();
        while (plannedTasks.isEmpty() && !evaluators.isEmpty()) {
            PartitionEvaluator evaluator = (PartitionEvaluator)evaluators.poll();
            while (evaluator != null) {
                this.actualPartitionPlans.add((AbstractPartitionPlan)evaluator);
                if ((double)(actualInputSize += evaluator.getCost()) > maxInputSize) break;
                evaluator = (PartitionEvaluator)evaluators.poll();
            }
            double avgThreadCost = (double)actualInputSize / this.availableCore;
            for (AbstractPartitionPlan partitionPlan : this.actualPartitionPlans) {
                plannedTasks.addAll(partitionPlan.splitTasks((int)((double)actualInputSize / avgThreadCost)));
            }
        }
        if (!plannedTasks.isEmpty()) {
            this.optimizingType = this.actualPartitionPlans.stream().anyMatch(plan -> plan.getOptimizingType() == OptimizingType.FULL) ? OptimizingType.FULL : (this.actualPartitionPlans.stream().anyMatch(plan -> plan.getOptimizingType() == OptimizingType.MAJOR) ? OptimizingType.MAJOR : OptimizingType.MINOR);
        }
        long endTime = System.nanoTime();
        LOG.info("{} finish plan, type = {}, get {} tasks, cost {} ns, {} ms maxInputSize {} actualInputSize {}", new Object[]{this.identifier, this.getOptimizingType(), plannedTasks.size(), endTime - startTime, (endTime - startTime) / 1000000L, maxInputSize, actualInputSize});
        return this.cacheAndReturnTasks(plannedTasks);
    }

    private List<RewriteStageTask> cacheAndReturnTasks(List<RewriteStageTask> tasks) {
        this.tasks = tasks;
        return this.tasks;
    }

    public long getPlanTime() {
        return this.planTime;
    }

    public OptimizingType getOptimizingType() {
        return this.optimizingType;
    }

    public long getProcessId() {
        return this.processId;
    }
}

