/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.GateBuffersSpec;
import org.apache.flink.util.Preconditions;

public class InputGateSpecUtils {
    public static final int DEFAULT_MAX_REQUIRED_BUFFERS_PER_GATE_FOR_BATCH = 1000;
    public static final int DEFAULT_MAX_REQUIRED_BUFFERS_PER_GATE_FOR_STREAM = Integer.MAX_VALUE;

    public static GateBuffersSpec createGateBuffersSpec(Optional<Integer> configuredMaxRequiredBuffersPerGate, int configuredNetworkBuffersPerChannel, int configuredFloatingNetworkBuffersPerGate, ResultPartitionType partitionType, int numInputChannels, boolean enableTieredStorage) {
        int maxRequiredBuffersThresholdPerGate = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate(partitionType, configuredMaxRequiredBuffersPerGate, enableTieredStorage);
        int targetRequiredBuffersPerGate = InputGateSpecUtils.getRequiredBuffersTargetPerGate(numInputChannels, configuredNetworkBuffersPerChannel);
        int targetTotalBuffersPerGate = InputGateSpecUtils.getTotalBuffersTargetPerGate(numInputChannels, configuredNetworkBuffersPerChannel, configuredFloatingNetworkBuffersPerGate);
        int requiredBuffersPerGate = Math.min(maxRequiredBuffersThresholdPerGate, targetRequiredBuffersPerGate);
        int effectiveExclusiveBuffersPerChannel = InputGateSpecUtils.getExclusiveBuffersPerChannel(configuredNetworkBuffersPerChannel, numInputChannels, requiredBuffersPerGate);
        int effectiveExclusiveBuffersPerGate = InputGateSpecUtils.getEffectiveExclusiveBuffersPerGate(numInputChannels, effectiveExclusiveBuffersPerChannel);
        int requiredFloatingBuffers = requiredBuffersPerGate - effectiveExclusiveBuffersPerGate;
        int totalFloatingBuffers = targetTotalBuffersPerGate - effectiveExclusiveBuffersPerGate;
        Preconditions.checkState((requiredFloatingBuffers > 0 ? 1 : 0) != 0, (Object)"Must be positive.");
        Preconditions.checkState((requiredFloatingBuffers <= totalFloatingBuffers ? 1 : 0) != 0, (Object)"Wrong number of floating buffers.");
        return new GateBuffersSpec(effectiveExclusiveBuffersPerChannel, requiredFloatingBuffers, totalFloatingBuffers, targetTotalBuffersPerGate);
    }

    @VisibleForTesting
    static int getEffectiveMaxRequiredBuffersPerGate(ResultPartitionType partitionType, Optional<Integer> configuredMaxRequiredBuffersPerGate, boolean enableTieredStorage) {
        return configuredMaxRequiredBuffersPerGate.orElseGet(() -> partitionType.isPipelinedOrPipelinedBoundedResultPartition() || partitionType.isHybridResultPartition() && !enableTieredStorage ? Integer.MAX_VALUE : 1000);
    }

    private static int getExclusiveBuffersPerChannel(int configuredNetworkBuffersPerChannel, int numInputChannels, int requiredBuffersPerGate) {
        Preconditions.checkArgument((numInputChannels > 0 ? 1 : 0) != 0, (Object)"Must be positive.");
        Preconditions.checkArgument((requiredBuffersPerGate >= 1 ? 1 : 0) != 0, (Object)"Require at least 1 buffer per gate.");
        return Math.min(configuredNetworkBuffersPerChannel, (requiredBuffersPerGate - 1) / numInputChannels);
    }

    private static int getRequiredBuffersTargetPerGate(int numInputChannels, int configuredNetworkBuffersPerChannel) {
        return numInputChannels * configuredNetworkBuffersPerChannel + 1;
    }

    private static int getTotalBuffersTargetPerGate(int numInputChannels, int configuredNetworkBuffersPerChannel, int configuredFloatingBuffersPerGate) {
        return numInputChannels * configuredNetworkBuffersPerChannel + configuredFloatingBuffersPerGate;
    }

    private static int getEffectiveExclusiveBuffersPerGate(int numInputChannels, int effectiveExclusiveBuffersPerChannel) {
        return effectiveExclusiveBuffersPerChannel * numInputChannels;
    }
}

