/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.status.AppStatusListener;
import org.apache.spark.status.AppStatusSource;
import org.apache.spark.status.AppStatusStore$;
import org.apache.spark.status.AppStatusUtils$;
import org.apache.spark.status.AppSummary;
import org.apache.spark.status.ApplicationEnvironmentInfoWrapper;
import org.apache.spark.status.ApplicationInfoWrapper;
import org.apache.spark.status.CachedQuantile;
import org.apache.spark.status.ExecutorStageSummaryWrapper;
import org.apache.spark.status.ExecutorSummaryWrapper;
import org.apache.spark.status.JobDataWrapper;
import org.apache.spark.status.PoolData;
import org.apache.spark.status.ProcessSummaryWrapper;
import org.apache.spark.status.RDDOperationGraphWrapper;
import org.apache.spark.status.RDDStorageInfoWrapper;
import org.apache.spark.status.ResourceProfileWrapper;
import org.apache.spark.status.SpeculationStageSummaryWrapper;
import org.apache.spark.status.StageDataWrapper;
import org.apache.spark.status.StreamBlockData;
import org.apache.spark.status.TaskDataWrapper;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationEnvironmentInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorMetricsDistributions;
import org.apache.spark.status.api.v1.ExecutorPeakMetricsDistributions;
import org.apache.spark.status.api.v1.ExecutorStageSummary;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.InputMetricDistributions;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.OutputMetricDistributions;
import org.apache.spark.status.api.v1.ProcessSummary;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.status.api.v1.ResourceProfileInfo;
import org.apache.spark.status.api.v1.ShuffleReadMetricDistributions;
import org.apache.spark.status.api.v1.ShuffleWriteMetricDistributions;
import org.apache.spark.status.api.v1.SpeculationStageSummary;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.TaskStatus;
import org.apache.spark.storage.FallbackStorage$;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011ua!B%K\u00011\u0013\u0006\u0002C-\u0001\u0005\u000b\u0007I\u0011A.\t\u0011\u0011\u0004!\u0011!Q\u0001\nqC\u0001\"\u001a\u0001\u0003\u0006\u0004%\tA\u001a\u0005\t]\u0002\u0011\t\u0011)A\u0005O\")q\u000e\u0001C\u0001a\")A\u000f\u0001C\u0001k\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002\\\u0002!\t!!8\t\u0013\t5\u0001!%A\u0005\u0002\t=\u0001\"\u0003B\u0013\u0001E\u0005I\u0011\u0001B\b\u0011%\u00119\u0003AI\u0001\n\u0003\u0011I\u0003C\u0005\u0003.\u0001\t\n\u0011\"\u0001\u00030!9!1\u0007\u0001\u0005\u0002\tU\u0002\"\u0003B\"\u0001E\u0005I\u0011\u0001B\b\u0011%\u0011)\u0005AI\u0001\n\u0003\u0011y\u0003C\u0005\u0003H\u0001\t\n\u0011\"\u0001\u0003\u0010!I!\u0011\n\u0001\u0012\u0002\u0013\u0005!\u0011\u0006\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0005'B\u0011Ba\u001a\u0001#\u0003%\tAa\u0004\t\u0013\t%\u0004!%A\u0005\u0002\t=\u0002\"\u0003B6\u0001E\u0005I\u0011\u0001B\b\u0011%\u0011i\u0007AI\u0001\n\u0003\u0011I\u0003C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\t]\u0004\u0001\"\u0001\u0003z!9!Q\u0011\u0001\u0005\u0002\t\u001d\u0005b\u0002BL\u0001\u0011%!\u0011\u0014\u0005\b\u0005?\u0003A\u0011\u0002BQ\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OCqA!*\u0001\t\u0003\u0011I\fC\u0004\u0003&\u0002!\tAa5\t\u0013\t\u001d\b!%A\u0005\u0002\t=\u0002bBA\\\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005s\u0004A\u0011\u0001B~\u0011\u001d\u0019I\u0001\u0001C\u0001\u0007\u0017A\u0011b!\u0007\u0001#\u0003%\tAa\u0004\t\u000f\rm\u0001\u0001\"\u0001\u0004\u001e!911\t\u0001\u0005\u0002\r\u0015\u0003\"CB+\u0001E\u0005I\u0011\u0001B\b\u0011%\u00199\u0006AI\u0001\n\u0003\u0011y\u0003C\u0005\u0004Z\u0001\t\n\u0011\"\u0001\u0003\u0010!I11\f\u0001\u0012\u0002\u0013\u0005!\u0011\u0006\u0005\b\u0007;\u0002A\u0011AB0\u0011\u001d\u0019y\u0007\u0001C\u0001\u0007cBqa!!\u0001\t\u0003\u0019\u0019\tC\u0004\u0004\n\u0002!\taa#\t\u000f\rU\u0005\u0001\"\u0001\u0004\u0018\"911\u0016\u0001\u0005\u0002\r5\u0006bBBZ\u0001\u0011\u00051Q\u0017\u0005\b\u0007\u0003\u0004A\u0011ABb\u0011\u001d\u0019Y\r\u0001C\u0001\u0007\u001bDqa!6\u0001\t\u0003\u00199n\u0002\u0005\u0004j*C\t\u0001TBv\r\u001dI%\n#\u0001M\u0007[Daa\u001c\"\u0005\u0002\r=\b\"CBy\u0005\n\u0007I\u0011ABz\u0011!\u0019)P\u0011Q\u0001\n\u0005%\u0004bBB|\u0005\u0012\u00051\u0011 \u0005\n\t#\u0011\u0015\u0013!C\u0001\t'A\u0011\u0002b\u0006C#\u0003%\t\u0001\"\u0007\u0003\u001d\u0005\u0003\bo\u0015;biV\u001c8\u000b^8sK*\u00111\nT\u0001\u0007gR\fG/^:\u000b\u00055s\u0015!B:qCJ\\'BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001e\u001c\"\u0001A*\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019Ho\u001c:f\u0007\u0001)\u0012\u0001\u0018\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\fqa\u001b<ti>\u0014XM\u0003\u0002b\u0019\u0006!Q\u000f^5m\u0013\t\u0019gLA\u0004L-N#xN]3\u0002\rM$xN]3!\u0003!a\u0017n\u001d;f]\u0016\u0014X#A4\u0011\u0007QC'.\u0003\u0002j+\n1q\n\u001d;j_:\u0004\"a\u001b7\u000e\u0003)K!!\u001c&\u0003#\u0005\u0003\bo\u0015;biV\u001cH*[:uK:,'/A\u0005mSN$XM\\3sA\u00051A(\u001b8jiz\"2!\u001d:t!\tY\u0007\u0001C\u0003Z\u000b\u0001\u0007A\fC\u0004f\u000bA\u0005\t\u0019A4\u0002\u001f\u0005\u0004\b\u000f\\5dCRLwN\\%oM>$\u0012A\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\f!A^\u0019\u000b\u0005mT\u0015aA1qS&\u0011Q\u0010\u001f\u0002\u0010\u0003B\u0004H.[2bi&|g.\u00138g_\u0006yQM\u001c<je>tW.\u001a8u\u0013:4w\u000e\u0006\u0002\u0002\u0002A\u0019q/a\u0001\n\u0007\u0005\u0015\u0001P\u0001\u000eBaBd\u0017nY1uS>tWI\u001c<je>tW.\u001a8u\u0013:4w.A\nsKN|WO]2f!J|g-\u001b7f\u0013:4w\u000e\u0006\u0002\u0002\fA1\u0011QBA\u000f\u0003GqA!a\u0004\u0002\u001a9!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016i\u000ba\u0001\u0010:p_Rt\u0014\"\u0001,\n\u0007\u0005mQ+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0011\u0011\u0005\u0002\u0004'\u0016\f(bAA\u000e+B\u0019q/!\n\n\u0007\u0005\u001d\u0002PA\nSKN|WO]2f!J|g-\u001b7f\u0013:4w.\u0001\u0005k_\n\u001cH*[:u)\u0011\ti#!\u000e\u0011\r\u00055\u0011QDA\u0018!\r9\u0018\u0011G\u0005\u0004\u0003gA(a\u0002&pE\u0012\u000bG/\u0019\u0005\b\u0003oI\u0001\u0019AA\u001d\u0003!\u0019H/\u0019;vg\u0016\u001c\bCBA\u001e\u0003\u0007\n9%\u0004\u0002\u0002>)\u0019\u0011-a\u0010\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006LA!!\u0012\u0002>\t!A*[:u!\u0011\tI%a\u0013\u000e\u00031K1!!\u0014M\u0005IQuNY#yK\u000e,H/[8o'R\fG/^:\u0002\u0007)|'\r\u0006\u0003\u00020\u0005M\u0003bBA+\u0015\u0001\u0007\u0011qK\u0001\u0006U>\u0014\u0017\n\u001a\t\u0004)\u0006e\u0013bAA.+\n\u0019\u0011J\u001c;\u0002))|'mV5uQ\u0006\u001b8o\\2jCR,GmU9m)\u0011\t\t'a\u001c\u0011\u000fQ\u000b\u0019'a\f\u0002h%\u0019\u0011QM+\u0003\rQ+\b\u000f\\33!\u0011!\u0006.!\u001b\u0011\u0007Q\u000bY'C\u0002\u0002nU\u0013A\u0001T8oO\"9\u0011QK\u0006A\u0002\u0005]\u0013\u0001D3yK\u000e,Ho\u001c:MSN$H\u0003BA;\u0003{\u0002b!!\u0004\u0002\u001e\u0005]\u0004cA<\u0002z%\u0019\u00111\u0010=\u0003\u001f\u0015CXmY;u_J\u001cV/\\7befDq!a \r\u0001\u0004\t\t)\u0001\u0006bGRLg/Z(oYf\u00042\u0001VAB\u0013\r\t))\u0016\u0002\b\u0005>|G.Z1o\u0003-\u0011X\r\u001d7bG\u0016,\u00050Z2\u0015\t\u0005]\u00141\u0012\u0005\b\u0003\u001bk\u0001\u0019AA<\u0003\u0019y'/[4j]\u0006\u0019\"/\u001a9mC\u000e,GI]5wKJ<5\rV5nKRA\u0011qOAJ\u0003/\u000bY\nC\u0004\u0002\u0016:\u0001\r!a\u001e\u0002\rM|WO]2f\u0011\u001d\tIJ\u0004a\u0001\u0003O\n1\u0002^8uC2<5\rV5nK\"9\u0011Q\u0014\bA\u0002\u0005\u001d\u0014\u0001\u0004;pi\u0006d\u0017\t\u001d9US6,\u0017!D3yiJ\f7\r^$d)&lW\r\u0006\u0003\u0002h\u0005\r\u0006bBAK\u001f\u0001\u0007\u0011qO\u0001\u000fKb$(/Y2u\u0003B\u0004H+[7f+\t\t9'\u0001\rnSN\u001cW\r\u001c7b]\u0016|Wo\u001d)s_\u000e,7o\u001d'jgR$B!!,\u00026B1\u0011QBA\u000f\u0003_\u00032a^AY\u0013\r\t\u0019\f\u001f\u0002\u000f!J|7-Z:t'VlW.\u0019:z\u0011\u001d\ty(\u0005a\u0001\u0003\u0003\u000bq\"\u001a=fGV$xN]*v[6\f'/\u001f\u000b\u0005\u0003o\nY\fC\u0004\u0002>J\u0001\r!a0\u0002\u0015\u0015DXmY;u_JLE\r\u0005\u0003\u0002B\u0006%g\u0002BAb\u0003\u000b\u00042!!\u0005V\u0013\r\t9-V\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0017Q\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001dW+\u0001\u0007bGRLg/Z*uC\u001e,7\u000f\u0006\u0002\u0002TB1\u0011QBA\u000f\u0003+\u00042a^Al\u0013\r\tI\u000e\u001f\u0002\n'R\fw-\u001a#bi\u0006\f\u0011b\u001d;bO\u0016d\u0015n\u001d;\u0015\u0019\u0005M\u0017q\\Au\u0003[\f\tP!\u0001\t\u000f\u0005]B\u00031\u0001\u0002bB1\u00111HA\"\u0003G\u00042a^As\u0013\r\t9\u000f\u001f\u0002\f'R\fw-Z*uCR,8\u000fC\u0005\u0002lR\u0001\n\u00111\u0001\u0002\u0002\u00069A-\u001a;bS2\u001c\b\"CAx)A\u0005\t\u0019AAA\u000359\u0018\u000e\u001e5Tk6l\u0017M]5fg\"I\u00111\u001f\u000b\u0011\u0002\u0003\u0007\u0011Q_\u0001\u0012k:\u001cxN\u001d;fIF+\u0018M\u001c;jY\u0016\u001c\b#\u0002+\u0002x\u0006m\u0018bAA}+\n)\u0011I\u001d:bsB\u0019A+!@\n\u0007\u0005}XK\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0005\u0007!\u0002\u0013!a\u0001\u0005\u000b\t!\u0002^1tWN#\u0018\r^;t!\u0019\tY$a\u0011\u0003\bA\u0019qO!\u0003\n\u0007\t-\u0001P\u0001\u0006UCN\\7\u000b^1ukN\f1c\u001d;bO\u0016d\u0015n\u001d;%I\u00164\u0017-\u001e7uII*\"A!\u0005+\t\u0005\u0005%1C\u0016\u0003\u0005+\u0001BAa\u0006\u0003\"5\u0011!\u0011\u0004\u0006\u0005\u00057\u0011i\"A\u0005v]\u000eDWmY6fI*\u0019!qD+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003$\te!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00192\u000f^1hK2K7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u00192\u000f^1hK2K7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0006\u0016\u0005\u0003k\u0014\u0019\"A\nti\u0006<W\rT5ti\u0012\"WMZ1vYR$S'\u0006\u0002\u00032)\"!Q\u0001B\n\u0003%\u0019H/Y4f\t\u0006$\u0018\r\u0006\u0007\u0002T\n]\"1\bB\u001f\u0005\u007f\u0011\t\u0005C\u0004\u0003:e\u0001\r!a\u0016\u0002\u000fM$\u0018mZ3JI\"I\u00111^\r\u0011\u0002\u0003\u0007\u0011\u0011\u0011\u0005\n\u0005\u0007I\u0002\u0013!a\u0001\u0005\u000bA\u0011\"a<\u001a!\u0003\u0005\r!!!\t\u0013\u0005M\u0018\u0004%AA\u0002\u0005U\u0018aE:uC\u001e,G)\u0019;bI\u0011,g-Y;mi\u0012\u0012\u0014aE:uC\u001e,G)\u0019;bI\u0011,g-Y;mi\u0012\u001a\u0014aE:uC\u001e,G)\u0019;bI\u0011,g-Y;mi\u0012\"\u0014aE:uC\u001e,G)\u0019;bI\u0011,g-Y;mi\u0012*\u0014\u0001\u00057bgR\u001cF/Y4f\u0003R$X-\u001c9u)\u0011\t)Na\u0014\t\u000f\teb\u00041\u0001\u0002X\u0005a1\u000f^1hK\u0006#H/Z7qiRq!Q\u000bB-\u00057\u0012yF!\u0019\u0003d\t\u0015\u0004c\u0002+\u0002d\u0005U'q\u000b\t\u0007\u0003\u001b\ti\"a\u0016\t\u000f\ter\u00041\u0001\u0002X!9!QL\u0010A\u0002\u0005]\u0013AD:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u0005\n\u0003W|\u0002\u0013!a\u0001\u0003\u0003C\u0011Ba\u0001 !\u0003\u0005\rA!\u0002\t\u0013\u0005=x\u0004%AA\u0002\u0005\u0005\u0005\"CAz?A\u0005\t\u0019AA{\u0003Y\u0019H/Y4f\u0003R$X-\u001c9uI\u0011,g-Y;mi\u0012\u001a\u0014AF:uC\u001e,\u0017\t\u001e;f[B$H\u0005Z3gCVdG\u000f\n\u001b\u0002-M$\u0018mZ3BiR,W\u000e\u001d;%I\u00164\u0017-\u001e7uIU\nac\u001d;bO\u0016\fE\u000f^3naR$C-\u001a4bk2$HEN\u0001\ni\u0006\u001c8nQ8v]R$b!!\u001b\u0003t\tU\u0004b\u0002B\u001dI\u0001\u0007\u0011q\u000b\u0005\b\u0005;\"\u0003\u0019AA,\u0003=awnY1mSRL8+^7nCJLHC\u0002B>\u0005\u0003\u0013\u0019\t\u0005\u0005\u0002B\nu\u0014qXA5\u0013\u0011\u0011y(!4\u0003\u00075\u000b\u0007\u000fC\u0004\u0003:\u0015\u0002\r!a\u0016\t\u000f\tuS\u00051\u0001\u0002X\u0005YA/Y:l'VlW.\u0019:z)!\u0011II!%\u0003\u0014\nU\u0005\u0003\u0002+i\u0005\u0017\u00032a\u001eBG\u0013\r\u0011y\t\u001f\u0002\u0018)\u0006\u001c8.T3ue&\u001cG)[:ue&\u0014W\u000f^5p]NDqA!\u000f'\u0001\u0004\t9\u0006C\u0004\u0003^\u0019\u0002\r!a\u0016\t\u000f\u0005Mh\u00051\u0001\u0002v\u0006\u00192\u000f[8vY\u0012\u001c\u0015m\u00195f#V\fg\u000e^5mKR!\u0011\u0011\u0011BN\u0011\u001d\u0011ij\na\u0001\u0003w\f\u0011!]\u0001\u0011cV\fg\u000e^5mKR{7\u000b\u001e:j]\u001e$B!a0\u0003$\"9!Q\u0014\u0015A\u0002\u0005m\u0018\u0001\u0003;bg.d\u0015n\u001d;\u0015\u0011\t%&\u0011\u0017BZ\u0005k\u0003b!!\u0004\u0002\u001e\t-\u0006cA<\u0003.&\u0019!q\u0016=\u0003\u0011Q\u000b7o\u001b#bi\u0006DqA!\u000f*\u0001\u0004\t9\u0006C\u0004\u0003^%\u0002\r!a\u0016\t\u000f\t]\u0016\u00061\u0001\u0002X\u0005AQ.\u0019=UCN\\7\u000f\u0006\b\u0003*\nm&Q\u0018B`\u0005\u0007\u00149M!5\t\u000f\te\"\u00061\u0001\u0002X!9!Q\f\u0016A\u0002\u0005]\u0003b\u0002BaU\u0001\u0007\u0011qK\u0001\u0007_\u001a47/\u001a;\t\u000f\t\u0015'\u00061\u0001\u0002X\u00051A.\u001a8hi\"DqA!3+\u0001\u0004\u0011Y-\u0001\u0004t_J$()\u001f\t\u0004o\n5\u0017b\u0001Bhq\nYA+Y:l'>\u0014H/\u001b8h\u0011\u001d\t9D\u000ba\u0001\u0005\u000b!\u0002C!+\u0003V\n]'\u0011\u001cBn\u0005;\u0014\tO!:\t\u000f\te2\u00061\u0001\u0002X!9!QL\u0016A\u0002\u0005]\u0003b\u0002BaW\u0001\u0007\u0011q\u000b\u0005\b\u0005\u000b\\\u0003\u0019AA,\u0011\u001d\u0011Im\u000ba\u0001\u0005?\u0004B\u0001\u00165\u0002@\"9!1]\u0016A\u0002\u0005\u0005\u0015!C1tG\u0016tG-\u001b8h\u0011%\t9d\u000bI\u0001\u0002\u0004\u0011)!\u0001\nuCN\\G*[:uI\u0011,g-Y;mi\u0012:DC\u0002Bv\u0005g\u0014)\u0010\u0005\u0005\u0002B\nu\u0014q\u0018Bw!\r9(q^\u0005\u0004\u0005cD(\u0001F#yK\u000e,Ho\u001c:Ti\u0006<WmU;n[\u0006\u0014\u0018\u0010C\u0004\u0003:5\u0002\r!a\u0016\t\u000f\t]X\u00061\u0001\u0002X\u0005I\u0011\r\u001e;f[B$\u0018\nZ\u0001\u0013gB,7-\u001e7bi&|gnU;n[\u0006\u0014\u0018\u0010\u0006\u0004\u0003~\u000e\u00151q\u0001\t\u0005)\"\u0014y\u0010E\u0002x\u0007\u0003I1aa\u0001y\u0005]\u0019\u0006/Z2vY\u0006$\u0018n\u001c8Ti\u0006<WmU;n[\u0006\u0014\u0018\u0010C\u0004\u0003:9\u0002\r!a\u0016\t\u000f\t]h\u00061\u0001\u0002X\u00059!\u000f\u001a3MSN$H\u0003BB\u0007\u0007+\u0001b!!\u0004\u0002\u001e\r=\u0001cA<\u0004\u0012%\u001911\u0003=\u0003\u001dI#Ei\u0015;pe\u0006<W-\u00138g_\"I1qC\u0018\u0011\u0002\u0003\u0007\u0011\u0011Q\u0001\u000bG\u0006\u001c\u0007.\u001a3P]2L\u0018!\u0005:eI2K7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%c\u0005A\u0011m](qi&|g.\u0006\u0003\u0004 \r\u001dB\u0003BB\u0011\u0007s\u0001B\u0001\u00165\u0004$A!1QEB\u0014\u0019\u0001!qa!\u000b2\u0005\u0004\u0019YCA\u0001U#\u0011\u0019ica\r\u0011\u0007Q\u001by#C\u0002\u00042U\u0013qAT8uQ&tw\rE\u0002U\u0007kI1aa\u000eV\u0005\r\te.\u001f\u0005\t\u0007w\tD\u00111\u0001\u0004>\u0005\u0011aM\u001c\t\u0006)\u000e}21E\u0005\u0004\u0007\u0003*&\u0001\u0003\u001fcs:\fW.\u001a \u0002\u00199,wo\u0015;bO\u0016$\u0015\r^1\u0015\u0019\u0005U7qIB&\u0007\u001f\u001a\tfa\u0015\t\u000f\r%#\u00071\u0001\u0002V\u0006)1\u000f^1hK\"I1Q\n\u001a\u0011\u0002\u0003\u0007\u0011\u0011Q\u0001\u000bo&$\b\u000eR3uC&d\u0007\"\u0003B\u0002eA\u0005\t\u0019\u0001B\u0003\u0011%\tyO\rI\u0001\u0002\u0004\t\t\tC\u0005\u0002tJ\u0002\n\u00111\u0001\u0002v\u00061b.Z<Ti\u0006<W\rR1uC\u0012\"WMZ1vYR$#'\u0001\foK^\u001cF/Y4f\t\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134\u0003YqWm^*uC\u001e,G)\u0019;bI\u0011,g-Y;mi\u0012\"\u0014A\u00068foN#\u0018mZ3ECR\fG\u0005Z3gCVdG\u000fJ\u001b\u0002)M$\u0018mZ3Fq\u0016\u001cW\u000f^8s'VlW.\u0019:z)!\u0019\tg!\u001b\u0004l\r5\u0004\u0003\u0002+i\u0007G\u00022a^B3\u0013\r\u00199\u0007\u001f\u0002\u001d\u000bb,7-\u001e;pe6+GO]5dg\u0012K7\u000f\u001e:jEV$\u0018n\u001c8t\u0011\u001d\u0011Id\u000ea\u0001\u0003/BqA!\u00188\u0001\u0004\t9\u0006C\u0004\u0002t^\u0002\r!!>\u0002#\u001d,G/U;b]RLG.Z:WC2,X\r\u0006\u0004\u0004t\re4Q\u0010\t\u0007\u0003\u001b\u0019)(a?\n\t\r]\u0014\u0011\u0005\u0002\u000b\u0013:$W\r_3e'\u0016\f\bbBB>q\u0001\u000711O\u0001\u0007m\u0006dW/Z:\t\u000f\r}\u0004\b1\u0001\u0002v\u0006I\u0011/^1oi&dWm]\u0001\u0004e\u0012$G\u0003BB\b\u0007\u000bCqaa\":\u0001\u0004\t9&A\u0003sI\u0012LE-\u0001\ttiJ,\u0017-\u001c\"m_\u000e\\7\u000fT5tiR\u00111Q\u0012\t\u0007\u0003\u001b\tiba$\u0011\u0007-\u001c\t*C\u0002\u0004\u0014*\u0013qb\u0015;sK\u0006l'\t\\8dW\u0012\u000bG/Y\u0001\u0017_B,'/\u0019;j_:<%/\u00199i\r>\u00148\u000b^1hKR!1\u0011TBU!\u0011\u0019Yj!*\u000e\u0005\ru%\u0002BBP\u0007C\u000bQa]2pa\u0016T1aa)M\u0003\t)\u0018.\u0003\u0003\u0004(\u000eu%!\u0005*E\t>\u0003XM]1uS>twI]1qQ\"9!\u0011H\u001eA\u0002\u0005]\u0013\u0001F8qKJ\fG/[8o\u000fJ\f\u0007\u000f\u001b$pe*{'\r\u0006\u0003\u00040\u000eE\u0006CBA\u0007\u0003;\u0019I\nC\u0004\u0002Vq\u0002\r!a\u0016\u0002\tA|w\u000e\u001c\u000b\u0005\u0007o\u001bi\fE\u0002l\u0007sK1aa/K\u0005!\u0001vn\u001c7ECR\f\u0007bBB`{\u0001\u0007\u0011qX\u0001\u0005]\u0006lW-\u0001\u0006baB\u001cV/\\7bef$\"a!2\u0011\u0007-\u001c9-C\u0002\u0004J*\u0013!\"\u00119q'VlW.\u0019:z\u0003\u0015\u0019Gn\\:f)\t\u0019y\rE\u0002U\u0007#L1aa5V\u0005\u0011)f.\u001b;\u0002+\r|gn\u001d;sk\u000e$H+Y:l\t\u0006$\u0018\rT5tiR!!\u0011VBm\u0011\u001d\u0019Y\u000e\u0011a\u0001\u0007;\f1\u0003^1tW\u0012\u000bG/Y,sCB\u0004XM]%uKJ\u0004b!!\u0004\u0004`\u000e\r\u0018\u0002BBq\u0003C\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0004W\u000e\u0015\u0018bABt\u0015\nyA+Y:l\t\u0006$\u0018m\u0016:baB,'/\u0001\bBaB\u001cF/\u0019;vgN#xN]3\u0011\u0005-\u00145C\u0001\"T)\t\u0019Y/A\bD+J\u0013VI\u0014+`-\u0016\u00136+S(O+\t\tI'\u0001\tD+J\u0013VI\u0014+`-\u0016\u00136+S(OA\u0005y1M]3bi\u0016d\u0015N^3Ti>\u0014X\rF\u0003r\u0007w$)\u0001C\u0004\u0004~\u001a\u0003\raa@\u0002\t\r|gN\u001a\t\u0005\u0003\u0013\"\t!C\u0002\u0005\u00041\u0013\u0011b\u00159be.\u001cuN\u001c4\t\u0013\u0011\u001da\t%AA\u0002\u0011%\u0011aD1qaN#\u0018\r^;t'>,(oY3\u0011\tQCG1\u0002\t\u0004W\u00125\u0011b\u0001C\b\u0015\ny\u0011\t\u001d9Ti\u0006$Xo]*pkJ\u001cW-A\rde\u0016\fG/\u001a'jm\u0016\u001cFo\u001c:fI\u0011,g-Y;mi\u0012\u0012TC\u0001C\u000bU\u0011!IAa\u0005\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t!YBK\u0002h\u0005'\u0001")
public class AppStatusStore {
    private final KVStore store;
    private final Option<AppStatusListener> listener;

    public static Option<AppStatusListener> $lessinit$greater$default$2() {
        return AppStatusStore$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<AppStatusSource> createLiveStore$default$2() {
        return AppStatusStore$.MODULE$.createLiveStore$default$2();
    }

    public static AppStatusStore createLiveStore(SparkConf sparkConf, Option<AppStatusSource> option) {
        return AppStatusStore$.MODULE$.createLiveStore(sparkConf, option);
    }

    public static long CURRENT_VERSION() {
        return AppStatusStore$.MODULE$.CURRENT_VERSION();
    }

    public KVStore store() {
        return this.store;
    }

    public Option<AppStatusListener> listener() {
        return this.listener;
    }

    public ApplicationInfo applicationInfo() {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = (ApplicationInfo)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(ApplicationInfoWrapper.class).max(1L).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> ((ApplicationInfoWrapper)it.next()).info());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Failed to get the application information. If you are starting up Spark, please wait a while until it's ready.");
        }
        return applicationInfo;
    }

    public ApplicationEnvironmentInfo environmentInfo() {
        Class<ApplicationEnvironmentInfoWrapper> klass = ApplicationEnvironmentInfoWrapper.class;
        return ((ApplicationEnvironmentInfoWrapper)this.store().read(klass, (Object)klass.getName())).info();
    }

    public Seq<ResourceProfileInfo> resourceProfileInfo() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(ResourceProfileWrapper.class)).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.rpInfo(), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public Seq<JobData> jobsList(List<JobExecutionStatus> statuses) {
        Iterable it = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(JobDataWrapper.class).reverse()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.info(), Iterable$.MODULE$.canBuildFrom());
        return statuses != null && !statuses.isEmpty() ? ((TraversableOnce)it.filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)statuses.contains((Object)job.status())))).toSeq() : it.toSeq();
    }

    public JobData job(int jobId) {
        return ((JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId))).info();
    }

    public Tuple2<JobData, Option<Object>> jobWithAssociatedSql(int jobId) {
        JobDataWrapper data = (JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId));
        return new Tuple2((Object)data.info(), data.sqlExecutionId());
    }

    public Seq<ExecutorSummary> executorList(boolean activeOnly) {
        KVStoreView base = this.store().view(ExecutorSummaryWrapper.class);
        KVStoreView filtered = activeOnly ? base.index("active").reverse().first((Object)BoxesRunTime.boxToBoolean((boolean)true)).last((Object)BoxesRunTime.boxToBoolean((boolean)true)) : base;
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)filtered).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.info(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$executorList$2(x$4)))).map((Function1 & Serializable & scala.Serializable)origin -> this.replaceExec((ExecutorSummary)origin), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private ExecutorSummary replaceExec(ExecutorSummary origin) {
        String string = origin.id();
        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.replaceDriverGcTime(origin, this.extractGcTime(origin), this.extractAppTime()) : origin;
    }

    private ExecutorSummary replaceDriverGcTime(ExecutorSummary source, Option<Object> totalGcTime, Option<Object> totalAppTime) {
        return new ExecutorSummary(source.id(), source.hostPort(), source.isActive(), source.rddBlocks(), source.memoryUsed(), source.diskUsed(), source.totalCores(), source.maxTasks(), source.activeTasks(), source.failedTasks(), source.completedTasks(), source.totalTasks(), BoxesRunTime.unboxToLong((Object)totalAppTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> source.totalDuration())), BoxesRunTime.unboxToLong((Object)totalGcTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> source.totalGCTime())), source.totalInputBytes(), source.totalShuffleRead(), source.totalShuffleWrite(), source.isBlacklisted(), source.maxMemory(), source.addTime(), source.removeTime(), source.removeReason(), source.executorLogs(), source.memoryMetrics(), source.blacklistedInStages(), source.peakMemoryMetrics(), source.attributes(), source.resources(), source.resourceProfileId(), source.isExcluded(), source.excludedInStages());
    }

    private Option<Object> extractGcTime(ExecutorSummary source) {
        return source.peakMemoryMetrics().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getMetricValue("TotalGCTime")));
    }

    private Option<Object> extractAppTime() {
        long startTime = 0L;
        long endTime = 0L;
        try {
            ApplicationInfo appInfo = this.applicationInfo();
            startTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).startTime().getTime();
            endTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).endTime().getTime();
        }
        catch (NoSuchElementException noSuchElementException) {}
        return endTime == 0L ? None$.MODULE$ : (endTime < 0L ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))) : Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(endTime - startTime))));
    }

    public Seq<ProcessSummary> miscellaneousProcessList(boolean activeOnly) {
        KVStoreView base = this.store().view(ProcessSummaryWrapper.class);
        KVStoreView filtered = activeOnly ? base.index("active").reverse().first((Object)BoxesRunTime.boxToBoolean((boolean)true)).last((Object)BoxesRunTime.boxToBoolean((boolean)true)) : base;
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)filtered).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.info(), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public ExecutorSummary executorSummary(String executorId) {
        return ((ExecutorSummaryWrapper)this.store().read(ExecutorSummaryWrapper.class, (Object)executorId)).info();
    }

    public Seq<StageData> activeStages() {
        return (Seq)this.listener().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.activeStages()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<StageData> stageList(List<StageStatus> statuses, boolean details, boolean withSummaries, double[] unsortedQuantiles, List<TaskStatus> taskStatus) {
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        Iterable it = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(StageDataWrapper.class).reverse()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.info(), Iterable$.MODULE$.canBuildFrom());
        Seq ret = statuses != null && !statuses.isEmpty() ? ((TraversableOnce)it.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)statuses.contains((Object)s.status())))).toSeq() : it.toSeq();
        return (Seq)ret.map((Function1 & Serializable & scala.Serializable)s -> this.newStageData((StageData)s, details, taskStatus, withSummaries, quantiles), Seq$.MODULE$.canBuildFrom());
    }

    public boolean stageList$default$2() {
        return false;
    }

    public boolean stageList$default$3() {
        return false;
    }

    public double[] stageList$default$4() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public List<TaskStatus> stageList$default$5() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public Seq<StageData> stageData(int stageId, boolean details, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(StageDataWrapper.class).index("stageId").first((Object)BoxesRunTime.boxToInteger((int)stageId)).last((Object)BoxesRunTime.boxToInteger((int)stageId))).asScala()).map((Function1 & Serializable & scala.Serializable)s -> this.newStageData(s.info(), details, taskStatus, withSummaries, unsortedQuantiles), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public boolean stageData$default$2() {
        return false;
    }

    public List<TaskStatus> stageData$default$3() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean stageData$default$4() {
        return false;
    }

    public double[] stageData$default$5() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public StageData lastStageAttempt(int stageId) {
        StageData stageData;
        block4: {
            try (KVStoreIterator it = this.store().view(StageDataWrapper.class).index("stageId").reverse().first((Object)BoxesRunTime.boxToInteger((int)stageId)).last((Object)BoxesRunTime.boxToInteger((int)stageId)).closeableIterator();){
                if (it.hasNext()) {
                    stageData = ((StageDataWrapper)it.next()).info();
                    break block4;
                }
                throw new NoSuchElementException(new StringBuilder(17).append("No stage with id ").append(stageId).toString());
            }
        }
        return stageData;
    }

    public Tuple2<StageData, Seq<Object>> stageAttempt(int stageId, int stageAttemptId, boolean details, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        StageDataWrapper stageDataWrapper = (StageDataWrapper)this.store().read(StageDataWrapper.class, (Object)stageKey);
        StageData stage = this.newStageData(stageDataWrapper.info(), details, taskStatus, withSummaries, unsortedQuantiles);
        return new Tuple2((Object)stage, (Object)stageDataWrapper.jobIds().toSeq());
    }

    public boolean stageAttempt$default$3() {
        return false;
    }

    public List<TaskStatus> stageAttempt$default$4() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean stageAttempt$default$5() {
        return false;
    }

    public double[] stageAttempt$default$6() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public long taskCount(int stageId, int stageAttemptId) {
        return this.store().count(TaskDataWrapper.class, "stage", (Object)new int[]{stageId, stageAttemptId});
    }

    public Map<String, Object> localitySummary(int stageId, int stageAttemptId) {
        return ((StageDataWrapper)this.store().read(StageDataWrapper.class, (Object)new int[]{stageId, stageAttemptId})).locality();
    }

    public Option<TaskMetricDistributions> taskSummary(int stageId, int stageAttemptId, double[] unsortedQuantiles) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        long count = BoxesRunTime.unboxToLong(Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(TaskDataWrapper.class).parent((Object)stageKey).index("ert").first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$2(it))));
        if (count <= 0L) {
            return None$.MODULE$;
        }
        CachedQuantile[] cachedQuantiles = (CachedQuantile[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)q -> this.shouldCacheQuantile(q)))).flatMap((Function1 & Serializable & scala.Serializable)q -> AppStatusStore.$anonfun$taskSummary$4(this, stageId, stageAttemptId, count, BoxesRunTime.unboxToDouble((Object)q)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CachedQuantile.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cachedQuantiles)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).size()) {
            TaskMetricDistributions distributions = new TaskMetricDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10.duration()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11.executorDeserializeTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12.executorDeserializeCpuTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13.executorRunTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14.executorCpuTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToDouble((double)x$15.resultSize()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)x$16.jvmGcTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble((double)x$17.resultSerializationTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToDouble((double)x$18.gettingResultTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToDouble((double)x$19.schedulerDelay()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToDouble((double)x$20.peakExecutionMemory()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToDouble((double)x$21.memoryBytesSpilled()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22.diskBytesSpilled()), cachedQuantiles), new InputMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToDouble((double)x$23.bytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToDouble((double)x$24.recordsRead()), cachedQuantiles)), new OutputMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToDouble((double)x$25.bytesWritten()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToDouble((double)x$26.recordsWritten()), cachedQuantiles)), new ShuffleReadMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToDouble((double)x$27.shuffleReadBytes()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToDouble((double)x$28.shuffleRecordsRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToDouble((double)x$29.shuffleRemoteBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToDouble((double)x$30.shuffleLocalBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToDouble((double)x$31.shuffleFetchWaitTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToDouble((double)x$32.shuffleRemoteBytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToDouble((double)x$33.shuffleRemoteBytesReadToDisk()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToDouble((double)x$34.shuffleTotalBlocksFetched()), cachedQuantiles)), new ShuffleWriteMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToDouble((double)x$35.shuffleWriteBytes()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToDouble((double)x$36.shuffleWriteRecords()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToDouble((double)x$37.shuffleWriteTime()), cachedQuantiles)));
            return new Some((Object)distributions);
        }
        long[] indices = (long[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)q -> package$.MODULE$.min((long)(q * (double)count), count - 1L), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        TaskMetricDistributions computedQuantiles = new TaskMetricDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<Object>)this.scanTasks$1("dur", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.duration()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("des", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorDeserializeTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dct", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorDeserializeCpuTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ert", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorRunTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ect", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorCpuTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("rs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.resultSize()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("gc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.jvmGcTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("rst", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.resultSerializationTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("grt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.gettingResultTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dly", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.schedulerDelay()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("pem", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.peakExecutionMemory()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("mbs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.memoryBytesSpilled()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dbs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.diskBytesSpilled()), stageKey, indices), new InputMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("is", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.inputBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ir", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.inputRecordsRead()), stageKey, indices)), new OutputMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("os", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.outputBytesWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("or", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.outputRecordsWritten()), stageKey, indices)), new ShuffleReadMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("stby", (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$56(m)), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRecordsRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srbl", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("slbl", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleLocalBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleFetchWaitTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srby", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srbd", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBytesReadToDisk()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("stbl", (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$63(m)), stageKey, indices)), new ShuffleWriteMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("sws", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleBytesWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("swr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRecordsWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("swt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleWriteTime()), stageKey, indices)));
        ((IterableLike)((TraversableLike)computedQuantiles.quantiles().zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$taskSummary$67(this, quantiles, x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AppStatusStore.$anonfun$taskSummary$68(this, stageId, stageAttemptId, count, computedQuantiles, x0$2);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)computedQuantiles);
    }

    private boolean shouldCacheQuantile(double q) {
        return package$.MODULE$.round(q * (double)100) % 5L == 0L;
    }

    private String quantileToString(double q) {
        return Long.toString(package$.MODULE$.round(q * (double)100));
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int maxTasks) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        Iterable taskDataWrapperIter = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(TaskDataWrapper.class).index("stage").first((Object)stageKey).last((Object)stageKey).reverse().max((long)maxTasks)).asScala();
        return (Seq)this.constructTaskDataList((Iterable<TaskDataWrapper>)taskDataWrapperIter).reverse();
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int offset, int length, TaskSorting sortBy, List<TaskStatus> statuses) {
        Tuple2 tuple2;
        TaskSorting taskSorting = sortBy;
        if (((Object)((Object)TaskSorting.ID)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (((Object)((Object)TaskSorting.INCREASING_RUNTIME)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)new Some((Object)"ert"), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (((Object)((Object)TaskSorting.DECREASING_RUNTIME)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)new Some((Object)"ert"), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)taskSorting);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option indexName = (Option)tuple22._1();
        boolean ascending = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)indexName, (Object)BoxesRunTime.boxToBoolean((boolean)ascending));
        Tuple2 tuple24 = tuple23;
        Option indexName2 = (Option)tuple24._1();
        boolean ascending2 = tuple24._2$mcZ$sp();
        return this.taskList(stageId, stageAttemptId, offset, length, (Option<String>)indexName2, ascending2, statuses);
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int offset, int length, Option<String> sortBy, boolean ascending, List<TaskStatus> statuses) {
        Iterable iterable;
        KVStoreView ordered;
        KVStoreView kVStoreView;
        int[] stageKey = new int[]{stageId, stageAttemptId};
        KVStoreView base = this.store().view(TaskDataWrapper.class);
        Option<String> option = sortBy;
        if (option instanceof Some) {
            Some some = (Some)option;
            String index = (String)some.value();
            kVStoreView = base.index(index).parent((Object)stageKey);
        } else {
            kVStoreView = base.index("stage").first((Object)stageKey).last((Object)stageKey);
        }
        KVStoreView indexed = kVStoreView;
        KVStoreView kVStoreView2 = ordered = ascending ? indexed : indexed.reverse();
        if (statuses != null && !statuses.isEmpty()) {
            Set statusesStr = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(statuses).asScala()).map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.toString(), Buffer$.MODULE$.canBuildFrom())).toSet();
            iterable = (Iterable)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)ordered).asScala()).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)statusesStr.contains((Object)s.status())))).slice(offset, offset + length);
        } else {
            iterable = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)ordered.skip((long)offset).max((long)length)).asScala();
        }
        Iterable taskDataWrapperIter = iterable;
        return this.constructTaskDataList((Iterable<TaskDataWrapper>)taskDataWrapperIter);
    }

    public List<TaskStatus> taskList$default$7() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public Map<String, ExecutorStageSummary> executorSummary(int stageId, int attemptId) {
        int[] stageKey = new int[]{stageId, attemptId};
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(ExecutorStageSummaryWrapper.class).index("stage").first((Object)stageKey).last((Object)stageKey)).asScala()).map((Function1 & Serializable & scala.Serializable)exec -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)exec.executorId()), (Object)exec.info()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<SpeculationStageSummary> speculationSummary(int stageId, int attemptId) {
        int[] stageKey = new int[]{stageId, attemptId};
        return this.asOption((Function0 & Serializable & scala.Serializable)() -> ((SpeculationStageSummaryWrapper)this.store().read(SpeculationStageSummaryWrapper.class, (Object)stageKey)).info());
    }

    public Seq<RDDStorageInfo> rddList(boolean cachedOnly) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(RDDStorageInfoWrapper.class)).asScala()).map((Function1 & Serializable & scala.Serializable)x$40 -> x$40.info(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)rdd -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$rddList$2(cachedOnly, rdd)))).toSeq();
    }

    public <T> Option<T> asOption(Function0<T> fn) {
        Some some;
        try {
            some = new Some(fn.apply());
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public StageData newStageData(StageData stage, boolean withDetail, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        StageData stageData;
        if (!withDetail && !withSummaries) {
            stageData = stage;
        } else {
            None$ none$;
            double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
            if (withDetail) {
                Map tasks = ((TraversableOnce)this.taskList(stage.stageId(), stage.attemptId(), 0, Integer.MAX_VALUE, (Option<String>)None$.MODULE$, false, taskStatus).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)BoxesRunTime.boxToLong((long)t.taskId()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                none$ = new Some((Object)tasks);
            } else {
                none$ = None$.MODULE$;
            }
            None$ tasks = none$;
            None$ executorSummaries = withDetail ? new Some(this.executorSummary(stage.stageId(), stage.attemptId())) : None$.MODULE$;
            Option<TaskMetricDistributions> taskMetricsDistribution = withSummaries ? this.taskSummary(stage.stageId(), stage.attemptId(), quantiles) : None$.MODULE$;
            Option<ExecutorMetricsDistributions> executorMetricsDistributions = withSummaries ? this.stageExecutorSummary(stage.stageId(), stage.attemptId(), quantiles) : None$.MODULE$;
            Option<SpeculationStageSummary> speculationStageSummary = withDetail ? this.speculationSummary(stage.stageId(), stage.attemptId()) : None$.MODULE$;
            stageData = new StageData(stage.status(), stage.stageId(), stage.attemptId(), stage.numTasks(), stage.numActiveTasks(), stage.numCompleteTasks(), stage.numFailedTasks(), stage.numKilledTasks(), stage.numCompletedIndices(), stage.submissionTime(), stage.firstTaskLaunchedTime(), stage.completionTime(), stage.failureReason(), stage.executorDeserializeTime(), stage.executorDeserializeCpuTime(), stage.executorRunTime(), stage.executorCpuTime(), stage.resultSize(), stage.jvmGcTime(), stage.resultSerializationTime(), stage.memoryBytesSpilled(), stage.diskBytesSpilled(), stage.peakExecutionMemory(), stage.inputBytes(), stage.inputRecords(), stage.outputBytes(), stage.outputRecords(), stage.shuffleRemoteBlocksFetched(), stage.shuffleLocalBlocksFetched(), stage.shuffleFetchWaitTime(), stage.shuffleRemoteBytesRead(), stage.shuffleRemoteBytesReadToDisk(), stage.shuffleLocalBytesRead(), stage.shuffleReadBytes(), stage.shuffleReadRecords(), stage.shuffleWriteBytes(), stage.shuffleWriteTime(), stage.shuffleWriteRecords(), stage.name(), stage.description(), stage.details(), stage.schedulingPool(), stage.rddIds(), stage.accumulatorUpdates(), (Option<Map<Object, TaskData>>)tasks, (Option<Map<String, ExecutorStageSummary>>)executorSummaries, speculationStageSummary, stage.killedTasksSummary(), stage.resourceProfileId(), stage.peakExecutorMetrics(), taskMetricsDistribution, executorMetricsDistributions);
        }
        return stageData;
    }

    public boolean newStageData$default$2() {
        return false;
    }

    public List<TaskStatus> newStageData$default$3() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean newStageData$default$4() {
        return false;
    }

    public double[] newStageData$default$5() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public Option<ExecutorMetricsDistributions> stageExecutorSummary(int stageId, int stageAttemptId, double[] unsortedQuantiles) {
        None$ none$;
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        Map<String, ExecutorStageSummary> summary = this.executorSummary(stageId, stageAttemptId);
        if (summary.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            scala.collection.immutable.IndexedSeq values = summary.values().toIndexedSeq();
            none$ = new Some((Object)new ExecutorMetricsDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToDouble((double)x$41.taskTime()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToDouble((double)x$42.failedTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToDouble((double)x$43.succeededTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToDouble((double)x$44.killedTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToDouble((double)x$45.inputBytes()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToDouble((double)x$46.inputRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToDouble((double)x$47.outputBytes()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$48 -> BoxesRunTime.boxToDouble((double)x$48.outputRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$49 -> BoxesRunTime.boxToDouble((double)x$49.shuffleRead()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$50 -> BoxesRunTime.boxToDouble((double)x$50.shuffleReadRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$51 -> BoxesRunTime.boxToDouble((double)x$51.shuffleWrite()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$52 -> BoxesRunTime.boxToDouble((double)x$52.shuffleWriteRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToDouble((double)x$53.memoryBytesSpilled()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$54 -> BoxesRunTime.boxToDouble((double)x$54.diskBytesSpilled()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), new ExecutorPeakMetricsDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<ExecutorMetrics>)((IndexedSeq)values.flatMap((Function1 & Serializable & scala.Serializable)x$55 -> Option$.MODULE$.option2Iterable(x$55.peakMemoryMetrics()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())))));
        }
        return none$;
    }

    public IndexedSeq<Object> getQuantilesValue(IndexedSeq<Object> values, double[] quantiles) {
        int count = values.size();
        long[] indices = (long[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)q -> package$.MODULE$.min((long)(q * (double)count), (long)(count - 1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(indices)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)values.apply((int)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toIndexedSeq();
    }

    public RDDStorageInfo rdd(int rddId) {
        return ((RDDStorageInfoWrapper)this.store().read(RDDStorageInfoWrapper.class, (Object)BoxesRunTime.boxToInteger((int)rddId))).info();
    }

    public boolean rddList$default$1() {
        return true;
    }

    public Seq<StreamBlockData> streamBlocksList() {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.store().view(StreamBlockData.class)).asScala()).toSeq();
    }

    public RDDOperationGraph operationGraphForStage(int stageId) {
        return ((RDDOperationGraphWrapper)this.store().read(RDDOperationGraphWrapper.class, (Object)BoxesRunTime.boxToInteger((int)stageId))).toRDDOperationGraph();
    }

    public Seq<RDDOperationGraph> operationGraphForJob(int jobId) {
        JobDataWrapper job = (JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId));
        Seq stages = (Seq)job.info().stageIds().sorted((Ordering)Ordering.Int$.MODULE$);
        return (Seq)stages.map((Function1 & Serializable & scala.Serializable)id -> AppStatusStore.$anonfun$operationGraphForJob$1(this, job, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
    }

    public PoolData pool(String name) {
        return (PoolData)this.store().read(PoolData.class, (Object)name);
    }

    public AppSummary appSummary() {
        AppSummary appSummary;
        try {
            appSummary = (AppSummary)this.store().read(AppSummary.class, (Object)AppSummary.class.getName());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Failed to get the application summary. If you are starting up Spark, please wait a while until it's ready.");
        }
        return appSummary;
    }

    public void close() {
        this.store().close();
    }

    public Seq<TaskData> constructTaskDataList(Iterable<TaskDataWrapper> taskDataWrapperIter) {
        HashMap executorIdToLogs = new HashMap();
        return ((TraversableOnce)taskDataWrapperIter.map((Function1 & Serializable & scala.Serializable)taskDataWrapper -> {
            TaskData taskDataOld = taskDataWrapper.toApi();
            Map executorLogs = (Map)executorIdToLogs.getOrElseUpdate((Object)taskDataOld.executorId(), (Function0 & Serializable & scala.Serializable)() -> {
                Map map;
                try {
                    map = this.executorSummary(taskDataOld.executorId()).executorLogs();
                }
                catch (NoSuchElementException e) {
                    map = Predef$.MODULE$.Map().empty();
                }
                return map;
            });
            return new TaskData(taskDataOld.taskId(), taskDataOld.index(), taskDataOld.attempt(), taskDataOld.partitionId(), taskDataOld.launchTime(), taskDataOld.resultFetchStart(), taskDataOld.duration(), taskDataOld.executorId(), taskDataOld.host(), taskDataOld.status(), taskDataOld.taskLocality(), taskDataOld.speculative(), taskDataOld.accumulatorUpdates(), taskDataOld.errorMessage(), taskDataOld.taskMetrics(), (Map<String, String>)executorLogs, AppStatusUtils$.MODULE$.schedulerDelay(taskDataOld), AppStatusUtils$.MODULE$.gettingResultTime(taskDataOld));
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$executorList$2(ExecutorSummary x$4) {
        String string = x$4.id();
        String string2 = FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID().executorId();
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$taskSummary$2(KVStoreIterator it) {
        void var1_1;
        long _count = 0L;
        while (it.hasNext()) {
            ++_count;
            it.skip(1L);
        }
        return (long)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$taskSummary$6(long count$1, CachedQuantile x$9) {
        return x$9.taskCount() == count$1;
    }

    public static final /* synthetic */ Iterable $anonfun$taskSummary$4(AppStatusStore $this, int stageId$1, int stageAttemptId$1, long count$1, double q) {
        Object[] qkey = new Object[]{BoxesRunTime.boxToInteger((int)stageId$1), BoxesRunTime.boxToInteger((int)stageAttemptId$1), $this.quantileToString(q)};
        return Option$.MODULE$.option2Iterable($this.asOption((Function0 & Serializable & scala.Serializable)() -> (CachedQuantile)$this.store().read(CachedQuantile.class, (Object)qkey)).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$taskSummary$6(count$1, x$9))));
    }

    private static final IndexedSeq toValues$1(Function1 fn, CachedQuantile[] cachedQuantiles$1) {
        return (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cachedQuantiles$1)).map(fn, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private final IndexedSeq scanTasks$1(String index, Function1 fn, int[] stageKey$1, long[] indices$1) {
        return (IndexedSeq)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(TaskDataWrapper.class).parent((Object)stageKey$1).index(index).first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> {
            DoubleRef last = DoubleRef.create((double)Double.NaN);
            LongRef currentIdx = LongRef.create((long)-1L);
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(indices$1)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)idx -> {
                double d;
                if (idx == currentIdx$1.elem) {
                    d = last$1.elem;
                } else {
                    long diff = idx - currentIdx$1.elem;
                    currentIdx$1.elem = idx;
                    d = it.skip(diff - 1L) ? (last$1.elem = (double)BoxesRunTime.unboxToLong((Object)fn.apply(it.next()))) : Double.NaN;
                }
                return d;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toIndexedSeq();
        });
    }

    public static final /* synthetic */ long $anonfun$taskSummary$56(TaskDataWrapper m) {
        return m.shuffleLocalBytesRead() + m.shuffleRemoteBytesRead();
    }

    public static final /* synthetic */ long $anonfun$taskSummary$63(TaskDataWrapper m) {
        return m.shuffleLocalBlocksFetched() + m.shuffleRemoteBlocksFetched();
    }

    public static final /* synthetic */ boolean $anonfun$taskSummary$67(AppStatusStore $this, double[] quantiles$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double q = tuple2._1$mcD$sp();
        boolean bl = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles$2)).contains((Object)BoxesRunTime.boxToDouble((double)q)) && $this.shouldCacheQuantile(q);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$taskSummary$68(AppStatusStore $this, int stageId$1, int stageAttemptId$1, long count$1, TaskMetricDistributions computedQuantiles$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double q = tuple2._1$mcD$sp();
        int idx = tuple2._2$mcI$sp();
        CachedQuantile cached = new CachedQuantile(stageId$1, stageAttemptId$1, $this.quantileToString(q), count$1, BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.duration().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorDeserializeTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorDeserializeCpuTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorRunTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorCpuTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.resultSize().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.jvmGcTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.resultSerializationTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.gettingResultTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.schedulerDelay().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.peakExecutionMemory().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.memoryBytesSpilled().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.diskBytesSpilled().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.inputMetrics().bytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.inputMetrics().recordsRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.outputMetrics().bytesWritten().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.outputMetrics().recordsWritten().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().readBytes().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().readRecords().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().localBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().fetchWaitTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBytesReadToDisk().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().totalBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeBytes().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeRecords().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeTime().apply(idx)));
        $this.store().write((Object)cached);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$rddList$2(boolean cachedOnly$1, RDDStorageInfo rdd) {
        return !cachedOnly$1 || rdd.numCachedPartitions() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ RDDOperationGraph $anonfun$operationGraphForJob$1(AppStatusStore $this, JobDataWrapper job$1, int id) {
        void var3_3;
        block0: {
            RDDOperationGraph g = ((RDDOperationGraphWrapper)$this.store().read(RDDOperationGraphWrapper.class, (Object)BoxesRunTime.boxToInteger((int)id))).toRDDOperationGraph();
            if (!job$1.skippedStages().contains((Object)BoxesRunTime.boxToInteger((int)id)) || g.rootCluster().name().contains("skipped")) break block0;
            g.rootCluster().setName(new StringBuilder(10).append(g.rootCluster().name()).append(" (skipped)").toString());
        }
        return var3_3;
    }

    public AppStatusStore(KVStore store, Option<AppStatusListener> listener) {
        this.store = store;
        this.listener = listener;
    }
}

