/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.ignite3.internal.network.ChannelType;
import org.apache.ignite3.internal.network.CriticalStripedThreadPoolExecutorFactory;
import org.apache.ignite3.internal.network.StripedExecutorByChannelTypeId;
import org.apache.ignite3.internal.thread.StripedExecutor;

class ArrayStripedExecutorByChannelTypeId
implements StripedExecutorByChannelTypeId {
    private final StripedExecutor[] array;

    ArrayStripedExecutorByChannelTypeId(CriticalStripedThreadPoolExecutorFactory factory, ChannelType ... channelTypes) {
        this.array = (StripedExecutor[])Arrays.stream(channelTypes).map(factory::create).toArray(StripedExecutor[]::new);
    }

    @Override
    public StripedExecutor get(short channelTypeId) {
        assert (channelTypeId >= 0 && channelTypeId < this.array.length) : "Channel type is not registered: " + channelTypeId;
        return this.array[channelTypeId];
    }

    @Override
    public Stream<StripedExecutor> stream() {
        return Arrays.stream(this.array);
    }
}

