/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.future.OrderingFuture;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ChannelTypeRegistry;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.network.NettyBootstrapFactory;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.RecipientLeftException;
import org.apache.ignite.internal.network.configuration.NetworkView;
import org.apache.ignite.internal.network.handshake.ChannelAlreadyExistsException;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.ChannelCreationListener;
import org.apache.ignite.internal.network.netty.ConnectorKey;
import org.apache.ignite.internal.network.netty.DefaultRecoveryDescriptorProvider;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.netty.NettyClient;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyServer;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.recovery.DescriptorAcquiry;
import org.apache.ignite.internal.network.recovery.RecoveryClientHandshakeManager;
import org.apache.ignite.internal.network.recovery.RecoveryClientHandshakeManagerFactory;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.network.recovery.RecoveryServerHandshakeManager;
import org.apache.ignite.internal.network.recovery.StaleIdDetector;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConnectionManager
implements ChannelCreationListener {
    private static final NetworkMessagesFactory FACTORY = new NetworkMessagesFactory();
    private static final IgniteLogger LOG = Loggers.forClass(ConnectionManager.class);
    public static final byte DIRECT_PROTOCOL_VERSION = 1;
    private static final int MAX_RETRIES_TO_OPEN_CHANNEL = 10;
    private final Bootstrap clientBootstrap;
    private final NettyServer server;
    private final Map<ConnectorKey<String>, NettySender> channels = new ConcurrentHashMap<ConnectorKey<String>, NettySender>();
    private final Map<ConnectorKey<InetSocketAddress>, NettyClient> clients = new ConcurrentHashMap<ConnectorKey<InetSocketAddress>, NettyClient>();
    private final SerializationService serializationService;
    private final List<Consumer<InNetworkObject>> listeners = new CopyOnWriteArrayList<Consumer<InNetworkObject>>();
    private final String consistentId;
    private final CompletableFuture<ClusterNode> localNodeFuture = new CompletableFuture();
    private final NettyBootstrapFactory bootstrapFactory;
    private final StaleIdDetector staleIdDetector;
    private final ClusterIdSupplier clusterIdSupplier;
    @Nullable
    private final RecoveryClientHandshakeManagerFactory clientHandshakeManagerFactory;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final RecoveryDescriptorProvider descriptorProvider = new DefaultRecoveryDescriptorProvider();
    private final NetworkView networkConfiguration;
    private final ExecutorService connectionMaintenanceExecutor;
    private final FailureManager failureManager;
    private final ChannelTypeRegistry channelTypeRegistry;

    public ConnectionManager(NetworkView networkConfiguration, SerializationService serializationService, String consistentId, NettyBootstrapFactory bootstrapFactory, StaleIdDetector staleIdDetector, ClusterIdSupplier clusterIdSupplier, FailureManager failureManager, ChannelTypeRegistry channelTypeRegistry) {
        this(networkConfiguration, serializationService, consistentId, bootstrapFactory, staleIdDetector, clusterIdSupplier, null, failureManager, channelTypeRegistry);
    }

    public ConnectionManager(NetworkView networkConfiguration, SerializationService serializationService, String consistentId, NettyBootstrapFactory bootstrapFactory, StaleIdDetector staleIdDetector, ClusterIdSupplier clusterIdSupplier, @Nullable RecoveryClientHandshakeManagerFactory clientHandshakeManagerFactory, FailureManager failureManager, ChannelTypeRegistry channelTypeRegistry) {
        this.serializationService = serializationService;
        this.consistentId = consistentId;
        this.bootstrapFactory = bootstrapFactory;
        this.staleIdDetector = staleIdDetector;
        this.clusterIdSupplier = clusterIdSupplier;
        this.clientHandshakeManagerFactory = clientHandshakeManagerFactory;
        this.networkConfiguration = networkConfiguration;
        this.failureManager = failureManager;
        this.channelTypeRegistry = channelTypeRegistry;
        this.server = new NettyServer(networkConfiguration, this::createServerHandshakeManager, this::onMessage, serializationService, bootstrapFactory);
        this.clientBootstrap = bootstrapFactory.createClientBootstrap();
        ThreadPoolExecutor maintenanceExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)NamedThreadFactory.create((String)consistentId, (String)"connection-maintenance", (IgniteLogger)LOG));
        maintenanceExecutor.allowCoreThreadTimeOut(true);
        this.connectionMaintenanceExecutor = maintenanceExecutor;
    }

    public void start() throws IgniteInternalException {
        try {
            boolean wasStarted = this.started.getAndSet(true);
            if (wasStarted) {
                throw new IgniteInternalException("Attempted to start an already started connection manager");
            }
            if (this.stopped.get()) {
                throw new IgniteInternalException("Attempted to start an already stopped connection manager");
            }
            this.server.start().get();
            LOG.info("Server started [address={}]", new Object[]{this.server.address()});
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new IgniteInternalException("Failed to start the connection manager: " + cause.getMessage(), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException("Interrupted while starting the connection manager", (Throwable)e);
        }
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.server.address();
    }

    public OrderingFuture<NettySender> channel(@Nullable String consistentId, ChannelType type, InetSocketAddress address) {
        return this.getChannelWithRetry(consistentId, type, address, 0);
    }

    private OrderingFuture<NettySender> getChannelWithRetry(@Nullable String consistentId, ChannelType type, InetSocketAddress address, int attempt) {
        if (attempt > 10) {
            return OrderingFuture.failedFuture((Throwable)new IllegalStateException("Too many attempts to open channel to " + consistentId));
        }
        return this.doGetChannel(consistentId, type, address).handle((res, ex) -> {
            if (ex instanceof ChannelAlreadyExistsException) {
                return this.getChannelWithRetry(((ChannelAlreadyExistsException)ex).consistentId(), type, address, attempt + 1);
            }
            if (ex != null && ex.getCause() instanceof ChannelAlreadyExistsException) {
                return this.getChannelWithRetry(((ChannelAlreadyExistsException)ex.getCause()).consistentId(), type, address, attempt + 1);
            }
            if (ex != null) {
                return OrderingFuture.failedFuture((Throwable)ex);
            }
            assert (res != null);
            if (res.isOpen()) {
                return OrderingFuture.completedFuture((Object)res);
            }
            return this.getChannelWithRetry(res.consistentId(), type, address, attempt + 1);
        }).thenCompose(Function.identity());
    }

    private OrderingFuture<NettySender> doGetChannel(@Nullable String consistentId, ChannelType type, InetSocketAddress address) {
        NettySender channel;
        if (consistentId != null && (channel = this.channels.compute(new ConnectorKey<String>(consistentId, type), (key, sender) -> sender == null || !sender.isOpen() ? null : sender)) != null) {
            return OrderingFuture.completedFuture((Object)channel);
        }
        @Nullable NettyClient client = this.clients.compute(new ConnectorKey<InetSocketAddress>(address, type), (key, existingClient) -> ConnectionManager.isClientConnected(existingClient) ? existingClient : this.connect((InetSocketAddress)key.id(), key.type()));
        if (client == null) {
            return OrderingFuture.failedFuture((Throwable)new NodeStoppingException("No outgoing connections are allowed as the node is stopping"));
        }
        return client.sender();
    }

    private static boolean isClientConnected(@Nullable NettyClient client) {
        return client != null && !client.failedToConnect() && !client.isDisconnected();
    }

    private void onMessage(InNetworkObject message) {
        this.listeners.forEach(consumer -> consumer.accept(message));
    }

    @Override
    public void handshakeFinished(NettySender channel) {
        ConnectorKey<String> key = new ConnectorKey<String>(channel.consistentId(), this.channelTypeRegistry.get(channel.channelId()));
        NettySender oldChannel = this.channels.put(key, channel);
        assert (oldChannel == null || !oldChannel.isOpen()) : "Incorrect channel creation flow";
        if (this.staleIdDetector.isIdStale(channel.launchId())) {
            this.closeSenderAndDisposeDescriptor(channel, (Exception)new RecipientLeftException());
            this.channels.remove(key, channel);
        } else if (this.stopping.get()) {
            this.closeSenderAndDisposeDescriptor(channel, (Exception)new NodeStoppingException());
            this.channels.remove(key, channel);
        }
    }

    private void closeSenderAndDisposeDescriptor(NettySender sender, Exception exceptionToFailSendFutures) {
        this.connectionMaintenanceExecutor.submit(() -> sender.closeAsync().whenCompleteAsync((res, ex) -> {
            RecoveryDescriptor recoveryDescriptor = this.descriptorProvider.getRecoveryDescriptor(sender.consistentId(), sender.launchId(), sender.channelId());
            this.blockAndDisposeDescriptor(recoveryDescriptor, exceptionToFailSendFutures);
        }, (Executor)this.connectionMaintenanceExecutor));
    }

    @Nullable
    private NettyClient connect(InetSocketAddress address, ChannelType channelType) {
        if (this.stopping.get()) {
            return null;
        }
        NettyClient client = new NettyClient(address, this.serializationService, this.createClientHandshakeManager(channelType.id()), this::onMessage, this.networkConfiguration.ssl());
        client.start(this.clientBootstrap).whenComplete((sender, throwable) -> {
            if (throwable != null) {
                this.clients.remove(new ConnectorKey<InetSocketAddress>(address, channelType));
            }
        });
        return client;
    }

    public void addListener(Consumer<InNetworkObject> listener) {
        this.listeners.add(listener);
    }

    public void stop() {
        boolean wasStopped = this.stopped.getAndSet(true);
        if (wasStopped) {
            return;
        }
        assert (this.stopping.get());
        ArrayList<CompletableFuture<Void>> stopFutures = new ArrayList<CompletableFuture<Void>>(this.clients.values().stream().map(NettyClient::stop).collect(Collectors.toList()));
        stopFutures.add(this.server.stop());
        stopFutures.addAll(this.channels.values().stream().map(NettySender::closeAsync).collect(Collectors.toList()));
        stopFutures.add(this.disposeDescriptors());
        CompletableFuture<Void> finalStopFuture = CompletableFuture.allOf((CompletableFuture[])stopFutures.toArray(CompletableFuture[]::new));
        try {
            finalStopFuture.get();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop connection manager [reason={}]", new Object[]{e.getMessage()});
        }
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.connectionMaintenanceExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    private CompletableFuture<Void> disposeDescriptors() {
        NodeStoppingException exceptionToFailSendFutures = new NodeStoppingException();
        Collection<RecoveryDescriptor> descriptors = this.descriptorProvider.getAllRecoveryDescriptors();
        ArrayList<CompletableFuture<Void>> disposeFutures = new ArrayList<CompletableFuture<Void>>(descriptors.size());
        for (RecoveryDescriptor descriptor : descriptors) {
            disposeFutures.add(this.blockAndDisposeDescriptor(descriptor, (Exception)exceptionToFailSendFutures));
        }
        return CompletableFuture.allOf((CompletableFuture[])disposeFutures.toArray(CompletableFuture[]::new));
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    private HandshakeManager createClientHandshakeManager(short connectionId) {
        ClusterNode localNode = Objects.requireNonNull((ClusterNode)this.localNodeFuture.getNow(null), "localNode not set");
        if (this.clientHandshakeManagerFactory == null) {
            return new RecoveryClientHandshakeManager(localNode, connectionId, this.descriptorProvider, this.bootstrapFactory, this.staleIdDetector, this.clusterIdSupplier, this, this.stopping::get, this.failureManager);
        }
        return this.clientHandshakeManagerFactory.create(localNode, connectionId, this.descriptorProvider);
    }

    private HandshakeManager createServerHandshakeManager() {
        this.waitForLocalNodeToBeSet();
        return new RecoveryServerHandshakeManager(this.localNodeFuture.join(), FACTORY, this.descriptorProvider, this.bootstrapFactory, this.staleIdDetector, this.clusterIdSupplier, this, this.stopping::get, this.failureManager);
    }

    private void waitForLocalNodeToBeSet() {
        try {
            this.localNodeFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for local node to be set", e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException("Could not finish awaiting for local node", e);
        }
    }

    @TestOnly
    public NettyServer server() {
        return this.server;
    }

    @TestOnly
    public SerializationService serializationService() {
        return this.serializationService;
    }

    public String consistentId() {
        return this.consistentId;
    }

    @TestOnly
    public Collection<NettyClient> clients() {
        return Collections.unmodifiableCollection(this.clients.values());
    }

    @TestOnly
    public Map<ConnectorKey<String>, NettySender> channels() {
        return Map.copyOf(this.channels);
    }

    public void initiateStopping() {
        this.stopping.set(true);
    }

    public void handleNodeLeft(UUID id) {
        assert (this.staleIdDetector.isIdStale(id)) : String.valueOf(id) + " is not stale yet";
        this.connectionMaintenanceExecutor.execute(() -> this.closeChannelsWith(id).whenCompleteAsync((res, ex) -> this.disposeRecoveryDescriptorsOfLeftNode(id), (Executor)this.connectionMaintenanceExecutor));
    }

    private CompletableFuture<Void> closeChannelsWith(UUID id) {
        List entriesToRemove = this.channels.entrySet().stream().filter(entry -> ((NettySender)entry.getValue()).launchId().equals(id)).collect(Collectors.toList());
        ArrayList<CompletableFuture<Void>> closeFutures = new ArrayList<CompletableFuture<Void>>();
        for (Map.Entry entry2 : entriesToRemove) {
            closeFutures.add(((NettySender)entry2.getValue()).closeAsync());
            this.channels.remove(entry2.getKey());
        }
        return CompletableFuture.allOf((CompletableFuture[])closeFutures.toArray(CompletableFuture[]::new));
    }

    private void disposeRecoveryDescriptorsOfLeftNode(UUID id) {
        RecipientLeftException exceptionToFailSendFutures = new RecipientLeftException();
        for (RecoveryDescriptor descriptor : this.descriptorProvider.getRecoveryDescriptorsByLaunchId(id)) {
            this.blockAndDisposeDescriptor(descriptor, (Exception)exceptionToFailSendFutures);
        }
    }

    private CompletableFuture<Void> blockAndDisposeDescriptor(RecoveryDescriptor descriptor, Exception exceptionToFailSendFutures) {
        while (!descriptor.tryBlockForever(exceptionToFailSendFutures)) {
            if (descriptor.isBlockedForever()) {
                return CompletableFutures.nullCompletedFuture();
            }
            DescriptorAcquiry acquiry = descriptor.holder();
            if (acquiry == null) continue;
            Channel channel = acquiry.channel();
            assert (channel != null);
            return ((CompletableFuture)NettyUtils.toCompletableFuture(channel.close()).handleAsync((res, e) -> this.blockAndDisposeDescriptor(descriptor, exceptionToFailSendFutures), (Executor)this.connectionMaintenanceExecutor)).thenCompose(Function.identity());
        }
        descriptor.dispose(exceptionToFailSendFutures);
        return CompletableFutures.nullCompletedFuture();
    }

    public void setLocalNode(ClusterNode localNode) {
        this.localNodeFuture.complete(localNode);
    }
}

