/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.leases;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.EntryEvent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.placementdriver.LeasePlacementDriver;
import org.apache.ignite.internal.placementdriver.PlacementDriverManager;
import org.apache.ignite.internal.placementdriver.PrimaryReplicaAwaitException;
import org.apache.ignite.internal.placementdriver.PrimaryReplicaAwaitTimeoutException;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.placementdriver.leases.Lease;
import org.apache.ignite.internal.placementdriver.leases.LeaseBatch;
import org.apache.ignite.internal.placementdriver.leases.Leases;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingIndependentComparableValuesTracker;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class LeaseTracker
extends AbstractEventProducer<PrimaryReplicaEvent, PrimaryReplicaEventParameters>
implements LeasePlacementDriver {
    private static final IgniteLogger LOG = Loggers.forClass(LeaseTracker.class);
    private final MetaStorageManager msManager;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private volatile Leases leases = new Leases(Collections.emptyMap(), ArrayUtils.BYTE_EMPTY_ARRAY);
    private final Map<ReplicationGroupId, PendingIndependentComparableValuesTracker<HybridTimestamp, ReplicaMeta>> primaryReplicaWaiters = new ConcurrentHashMap<ReplicationGroupId, PendingIndependentComparableValuesTracker<HybridTimestamp, ReplicaMeta>>();
    private final Map<ReplicationGroupId, CompletableFuture<Void>> expirationFutureByGroup = new ConcurrentHashMap<ReplicationGroupId, CompletableFuture<Void>>();
    private final UpdateListener updateListener = new UpdateListener();
    private final ClusterNodeResolver clusterNodeResolver;
    private final ClockService clockService;

    public LeaseTracker(MetaStorageManager msManager, ClusterNodeResolver clusterNodeResolver, ClockService clockService) {
        this.msManager = msManager;
        this.clusterNodeResolver = clusterNodeResolver;
        this.clockService = clockService;
    }

    public void startTrack(long recoveryRevision) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            this.msManager.registerExactWatch(PlacementDriverManager.PLACEMENTDRIVER_LEASES_KEY, (WatchListener)this.updateListener);
            this.loadLeasesBusyAsync(recoveryRevision);
        });
    }

    public void stopTrack() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.primaryReplicaWaiters.forEach((groupId, pendingTracker) -> pendingTracker.close());
        this.primaryReplicaWaiters.clear();
        this.msManager.unregisterWatch((WatchListener)this.updateListener);
    }

    public CompletableFuture<Void> previousPrimaryExpired(ReplicationGroupId grpId) {
        return this.expirationFutureByGroup.getOrDefault(grpId, CompletableFutures.nullCompletedFuture());
    }

    public Lease getLease(ReplicationGroupId grpId) {
        Leases leases = this.leases;
        assert (leases != null) : "Leases not initialized, probably the local placement driver actor hasn't started lease tracking.";
        Lease lease = leases.leaseByGroupId().get(grpId);
        return lease == null ? Lease.emptyLease(grpId) : lease;
    }

    public Leases leasesCurrent() {
        return this.leases;
    }

    private void awaitPrimaryReplica(ReplicationGroupId groupId, HybridTimestamp timestamp, CompletableFuture<ReplicaMeta> resultFuture) {
        IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.getOrCreatePrimaryReplicaWaiter(groupId).waitFor((Comparable)timestamp).thenAccept(replicaMeta -> {
            ClusterNode leaseholderNode = this.clusterNodeResolver.getById(replicaMeta.getLeaseholderId());
            if (leaseholderNode == null && !resultFuture.isDone()) {
                this.awaitPrimaryReplica(groupId, replicaMeta.getExpirationTime().tick(), resultFuture);
            } else {
                resultFuture.complete((ReplicaMeta)replicaMeta);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ReplicaMeta> awaitPrimaryReplica(ReplicationGroupId groupId, HybridTimestamp timestamp, long timeout, TimeUnit unit) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            ReplicaMeta currentMeta = this.getCurrentPrimaryReplica(groupId, timestamp);
            if (currentMeta != null && this.clusterNodeResolver.getById(currentMeta.getLeaseholderId()) != null) {
                CompletableFuture<ReplicaMeta> completableFuture = CompletableFuture.completedFuture(currentMeta);
                return completableFuture;
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
        CompletableFuture<ReplicaMeta> future = new CompletableFuture<ReplicaMeta>();
        this.awaitPrimaryReplica(groupId, timestamp, future);
        return future.orTimeout(timeout, unit).exceptionally(e -> {
            if (e instanceof TimeoutException) {
                throw new PrimaryReplicaAwaitTimeoutException(groupId, timestamp, (ReplicaMeta)this.leases.leaseByGroupId().get(groupId), e);
            }
            throw new PrimaryReplicaAwaitException(groupId, timestamp, e);
        });
    }

    public CompletableFuture<ReplicaMeta> getPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            Lease lease = this.getLease(replicationGroupId);
            if (lease.isAccepted() && this.clockService.after(lease.getExpirationTime(), timestamp)) {
                return CompletableFuture.completedFuture(lease);
            }
            return this.msManager.clusterTime().waitFor(timestamp.addPhysicalTime(this.clockService.maxClockSkewMillis())).thenApply(ignored -> (ReplicaMeta)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                Lease lease0 = this.getLease(replicationGroupId);
                if (lease0.isAccepted() && this.clockService.after(lease0.getExpirationTime(), timestamp)) {
                    return lease0;
                }
                return null;
            }));
        });
    }

    @Nullable
    public ReplicaMeta getCurrentPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
        Lease lease = this.getLease(replicationGroupId);
        if (lease.isAccepted() && this.clockService.after(lease.getExpirationTime(), timestamp)) {
            return lease;
        }
        return null;
    }

    private void tryRemoveTracker(ReplicationGroupId groupId) {
        this.primaryReplicaWaiters.compute(groupId, (groupId0, tracker0) -> {
            if (tracker0 != null && tracker0.isEmpty()) {
                return null;
            }
            return tracker0;
        });
    }

    private PendingIndependentComparableValuesTracker<HybridTimestamp, ReplicaMeta> getOrCreatePrimaryReplicaWaiter(ReplicationGroupId groupId) {
        return this.primaryReplicaWaiters.computeIfAbsent(groupId, key -> new PendingIndependentComparableValuesTracker((Comparable)HybridTimestamp.MIN_VALUE));
    }

    private void loadLeasesBusyAsync(long recoveryRevision) {
        Entry entry = this.msManager.getLocally(PlacementDriverManager.PLACEMENTDRIVER_LEASES_KEY, recoveryRevision);
        if (entry.empty() || entry.tombstone()) {
            this.leases = new Leases(Map.of(), ArrayUtils.BYTE_EMPTY_ARRAY);
        } else {
            byte[] leasesBytes = entry.value();
            LeaseBatch leaseBatch = LeaseBatch.fromBytes(ByteBuffer.wrap(leasesBytes).order(ByteOrder.LITTLE_ENDIAN));
            HashMap<ReplicationGroupId, Lease> leasesMap = new HashMap<ReplicationGroupId, Lease>();
            leaseBatch.leases().forEach(lease -> {
                ReplicationGroupId grpId = lease.replicationGroupId();
                leasesMap.put(grpId, (Lease)lease);
                if (lease.isAccepted()) {
                    this.getOrCreatePrimaryReplicaWaiter(grpId).update((Comparable)lease.getExpirationTime(), lease);
                }
            });
            this.leases = new Leases(leasesMap, leasesBytes);
        }
        LOG.info("Leases cache recovered [leases={}]", new Object[]{this.leases});
    }

    private boolean needToFireEventReplicaExpired(ReplicationGroupId grpId, @Nullable Lease lease) {
        assert (lease == null || lease.replicationGroupId().equals((Object)grpId)) : IgniteStringFormatter.format((String)"Group id mismatch [groupId={}, lease={}]", (Object[])new Object[]{grpId, lease});
        Lease currentLease = this.leases.leaseByGroupId().get(grpId);
        if (currentLease != null && currentLease.isAccepted()) {
            boolean sameLease;
            boolean bl = sameLease = lease != null && currentLease.getStartTime().equals((Object)lease.getStartTime());
            if (!sameLease) {
                return true;
            }
        }
        return false;
    }

    private void fireEventPrimaryReplicaExpired(long causalityToken, Lease expiredLease) {
        ReplicationGroupId grpId = expiredLease.replicationGroupId();
        CompletableFuture<Void> prev = this.expirationFutureByGroup.put(grpId, this.fireEvent((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, (EventParameters)new PrimaryReplicaEventParameters(causalityToken, grpId, expiredLease.getLeaseholderId(), expiredLease.getLeaseholder(), expiredLease.getStartTime())));
        assert (prev == null || prev.isDone()) : "Previous lease expiration process has not completed yet [grpId=" + String.valueOf(grpId) + "]";
    }

    private CompletableFuture<Void> fireEventPrimaryReplicaElected(long causalityToken, Lease lease) {
        UUID leaseholderId = lease.getLeaseholderId();
        assert (leaseholderId != null) : lease;
        return this.fireEvent((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, (EventParameters)new PrimaryReplicaEventParameters(causalityToken, lease.replicationGroupId(), leaseholderId, lease.getLeaseholder(), lease.getStartTime()));
    }

    private static boolean needFireEventReplicaBecomePrimary(@Nullable Lease previousLease, Lease newLease) {
        assert (newLease.isAccepted()) : newLease;
        return previousLease == null || !previousLease.isAccepted() || !previousLease.getStartTime().equals((Object)newLease.getStartTime());
    }

    private class UpdateListener
    implements WatchListener {
        private UpdateListener() {
        }

        public CompletableFuture<Void> onUpdate(WatchEvent event) {
            return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)LeaseTracker.this.busyLock, () -> {
                ArrayList<CompletableFuture<Void>> fireEventFutures = new ArrayList<CompletableFuture<Void>>();
                ArrayList<Lease> expiredLeases = new ArrayList<Lease>();
                for (EntryEvent entry : event.entryEvents()) {
                    Entry msEntry = entry.newEntry();
                    byte[] leasesBytes = msEntry.value();
                    HashMap<ReplicationGroupId, Lease> leasesMap = new HashMap<ReplicationGroupId, Lease>();
                    LeaseBatch leaseBatch = LeaseBatch.fromBytes(ByteBuffer.wrap(leasesBytes).order(ByteOrder.LITTLE_ENDIAN));
                    Map<ReplicationGroupId, Lease> previousLeasesMap = LeaseTracker.this.leases.leaseByGroupId();
                    for (Lease lease : leaseBatch.leases()) {
                        ReplicationGroupId grpId = lease.replicationGroupId();
                        leasesMap.put(grpId, lease);
                        if (lease.isAccepted()) {
                            LeaseTracker.this.primaryReplicaWaiters.computeIfAbsent(grpId, groupId -> new PendingIndependentComparableValuesTracker((Comparable)HybridTimestamp.MIN_VALUE)).update((Comparable)lease.getExpirationTime(), (Object)lease);
                            if (LeaseTracker.needFireEventReplicaBecomePrimary(previousLeasesMap.get(grpId), lease)) {
                                fireEventFutures.add(LeaseTracker.this.fireEventPrimaryReplicaElected(event.revision(), lease));
                            }
                        }
                        if (!LeaseTracker.this.needToFireEventReplicaExpired(grpId, lease)) continue;
                        expiredLeases.add(LeaseTracker.this.leases.leaseByGroupId().get(grpId));
                    }
                    for (ReplicationGroupId grpId : LeaseTracker.this.leases.leaseByGroupId().keySet()) {
                        if (leasesMap.containsKey(grpId)) continue;
                        LeaseTracker.this.tryRemoveTracker(grpId);
                        if (!LeaseTracker.this.needToFireEventReplicaExpired(grpId, null)) continue;
                        expiredLeases.add(LeaseTracker.this.leases.leaseByGroupId().get(grpId));
                    }
                    LeaseTracker.this.leases = new Leases(leasesMap, leasesBytes);
                    for (Lease expiredLease : expiredLeases) {
                        LeaseTracker.this.fireEventPrimaryReplicaExpired(event.revision(), expiredLease);
                    }
                }
                return CompletableFuture.allOf((CompletableFuture[])fireEventFutures.toArray(CompletableFuture[]::new));
            });
        }
    }
}

