/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlAsofJoin
extends SqlJoin {
    SqlNode matchCondition;
    static final SqlAsofJoinOperator ASOF_OPERATOR = new SqlAsofJoinOperator("ASOF-JOIN", 16);

    public SqlAsofJoin(SqlParserPos pos, SqlNode left, SqlLiteral natural, SqlLiteral joinType, SqlNode right, SqlLiteral conditionType, @Nullable SqlNode condition, SqlNode matchCondition) {
        super(pos, left, natural, joinType, right, conditionType, condition);
        this.matchCondition = matchCondition;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.left, this.natural, this.joinType, this.right, this.conditionType, this.condition, this.matchCondition);
    }

    @Override
    public SqlOperator getOperator() {
        return ASOF_OPERATOR;
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.left = operand;
                break;
            }
            case 1: {
                this.natural = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.joinType = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.right = operand;
                break;
            }
            case 4: {
                this.conditionType = (SqlLiteral)operand;
                break;
            }
            case 5: {
                this.condition = operand;
                break;
            }
            case 6: {
                this.matchCondition = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final SqlNode getMatchCondition() {
        return this.matchCondition;
    }

    @Override
    public SqlString toSqlString(UnaryOperator<SqlWriterConfig> transform) {
        SqlSelect selectWrapper = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, SqlNodeList.SINGLETON_STAR, this, null, null, null, SqlNodeList.EMPTY, null, null, null, null, SqlNodeList.EMPTY);
        return selectWrapper.toSqlString(transform);
    }

    public static class SqlAsofJoinOperator
    extends SqlOperator {
        private SqlAsofJoinOperator(String name, int prec) {
            super(name, SqlKind.JOIN, prec, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            return new SqlAsofJoin(pos, operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2], operands[3], (SqlLiteral)operands[4], operands[5], operands[6]);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlAsofJoin join = (SqlAsofJoin)call;
            join.left.unparse(writer, leftPrec, this.getLeftPrec());
            if (join.getJoinType() == JoinType.LEFT_ASOF) {
                writer.sep("LEFT ASOF JOIN");
            } else {
                writer.sep("ASOF JOIN");
            }
            join.right.unparse(writer, this.getRightPrec(), rightPrec);
            SqlNode matchCondition = join.matchCondition;
            writer.keyword("MATCH_CONDITION");
            matchCondition.unparse(writer, 0, 0);
            SqlNode joinCondition = join.condition;
            if (joinCondition != null) {
                switch (join.getConditionType()) {
                    case ON: {
                        writer.keyword("ON");
                        joinCondition.unparse(writer, leftPrec, rightPrec);
                        break;
                    }
                    default: {
                        throw Util.unexpected(join.getConditionType());
                    }
                }
            }
        }
    }
}

