/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.queue;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite.internal.compute.queue.BoundedPriorityBlockingQueue;
import org.apache.ignite.internal.compute.queue.ComputeThreadPoolExecutor;
import org.apache.ignite.internal.compute.queue.QueueExecution;
import org.apache.ignite.internal.compute.queue.QueueExecutionImpl;
import org.apache.ignite.internal.compute.state.ComputeStateMachine;

public class PriorityQueueExecutor {
    private static final long THREAD_KEEP_ALIVE_SECONDS = 60L;
    private final ComputeConfiguration configuration;
    private final ComputeThreadPoolExecutor executor;
    private final ComputeStateMachine stateMachine;

    public PriorityQueueExecutor(ComputeConfiguration configuration, ThreadFactory threadFactory, ComputeStateMachine stateMachine) {
        this.configuration = configuration;
        this.stateMachine = stateMachine;
        BoundedPriorityBlockingQueue<Runnable> workQueue = new BoundedPriorityBlockingQueue<Runnable>(() -> (Integer)configuration.queueMaxSize().value());
        this.executor = new ComputeThreadPoolExecutor((Integer)configuration.threadPoolSize().value(), (Integer)configuration.threadPoolSize().value(), 60L, TimeUnit.SECONDS, workQueue, threadFactory);
    }

    public <R> QueueExecution<R> submit(Callable<CompletableFuture<R>> job, int priority, int maxRetries) {
        Objects.requireNonNull(job);
        UUID jobId = this.stateMachine.initJob();
        QueueExecutionImpl<R> execution = new QueueExecutionImpl<R>(jobId, job, priority, this.executor, this.stateMachine);
        execution.run(maxRetries);
        return execution;
    }

    public <R> QueueExecution<R> submit(Callable<CompletableFuture<R>> job) {
        return this.submit(job, 0, 0);
    }

    public void shutdown() {
        this.executor.shutdown((Long)this.configuration.threadPoolStopTimeoutMillis().value());
    }
}

