/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.List;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.Program;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.Transition;
import org.apache.ignite.internal.sql.engine.message.UnknownNodeException;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;

class QueryExecutionProgram
extends Program<AsyncSqlCursor<InternalSqlRow>> {
    private static final String PROGRAM_NAME = "QUERY_EXECUTION";
    private static final List<Transition> TRANSITIONS = List.of(new Transition(ExecutionPhase.REGISTERED, query -> ExecutionPhase.PARSING), new Transition(ExecutionPhase.PARSING, query -> query.parsedResult != null ? ExecutionPhase.OPTIMIZING : ExecutionPhase.SCRIPT_INITIALIZATION), new Transition(ExecutionPhase.OPTIMIZING, query -> ExecutionPhase.CURSOR_INITIALIZATION), new Transition(ExecutionPhase.CURSOR_INITIALIZATION, query -> ExecutionPhase.EXECUTING), new Transition(ExecutionPhase.SCRIPT_INITIALIZATION, query -> ExecutionPhase.EXECUTING));
    static final Program<AsyncSqlCursor<InternalSqlRow>> INSTANCE = new QueryExecutionProgram();

    private QueryExecutionProgram() {
        super(PROGRAM_NAME, TRANSITIONS, phase -> phase == ExecutionPhase.EXECUTING, query -> query.cursor, QueryExecutionProgram::errorHandler);
    }

    static boolean errorHandler(Query query, Throwable th) {
        if (QueryExecutionProgram.canRecover(query, th)) {
            query.error.set(null);
            if (QueryExecutionProgram.nodeLeft(th)) {
                SqlOperationContext context = query.operationContext;
                assert (context != null);
                assert (th instanceof UnknownNodeException) : th;
                UnknownNodeException exception = (UnknownNodeException)th;
                context.excludeNode(exception.nodeName());
                return true;
            }
            if (QueryExecutionProgram.lockConflict(th) || QueryExecutionProgram.replicaMiss(th)) {
                return true;
            }
        }
        query.onError(th);
        return false;
    }

    private static boolean canRecover(Query query, Throwable th) {
        if (query.currentPhase() != ExecutionPhase.CURSOR_INITIALIZATION) {
            return false;
        }
        if (query.txContext.explicitTx() != null) {
            return false;
        }
        return QueryExecutionProgram.nodeLeft(th) || QueryExecutionProgram.lockConflict(th) || QueryExecutionProgram.replicaMiss(th);
    }

    private static boolean nodeLeft(Throwable th) {
        return th instanceof UnknownNodeException;
    }

    private static boolean lockConflict(Throwable th) {
        return ExceptionUtils.extractCodeFrom((Throwable)th) == ErrorGroups.Transactions.ACQUIRE_LOCK_ERR;
    }

    private static boolean replicaMiss(Throwable th) {
        return ExceptionUtils.extractCodeFrom((Throwable)th) == ErrorGroups.Replicator.REPLICA_MISS_ERR;
    }
}

