/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.raft.Peer;
import org.jetbrains.annotations.Nullable;

class RetryContext {
    private Peer targetPeer;
    private final Supplier<String> originDescription;
    private final Function<Peer, ? extends NetworkMessage> requestFactory;
    private NetworkMessage request;
    private final long stopTime;
    private int retryCount = 0;
    private final Set<Peer> unavailablePeers = new HashSet<Peer>();
    @Nullable
    private UUID errorTraceId;

    RetryContext(Peer targetPeer, Supplier<String> originDescription, Function<Peer, ? extends NetworkMessage> requestFactory, long stopTime) {
        this.targetPeer = targetPeer;
        this.originDescription = originDescription;
        this.requestFactory = requestFactory;
        this.request = requestFactory.apply(targetPeer);
        this.stopTime = stopTime;
    }

    Peer targetPeer() {
        return this.targetPeer;
    }

    NetworkMessage request() {
        return this.request;
    }

    @Nullable
    String originCommandDescription() {
        return this.originDescription.get();
    }

    long stopTime() {
        return this.stopTime;
    }

    int retryCount() {
        return this.retryCount;
    }

    Set<Peer> unavailablePeers() {
        return this.unavailablePeers;
    }

    UUID errorTraceId() {
        if (this.errorTraceId == null) {
            this.errorTraceId = UUID.randomUUID();
        }
        return this.errorTraceId;
    }

    void resetUnavailablePeers() {
        this.unavailablePeers.clear();
    }

    RetryContext nextAttempt(Peer newTargetPeer) {
        this.request = this.requestFactory.apply(newTargetPeer);
        this.targetPeer = newTargetPeer;
        ++this.retryCount;
        return this;
    }

    RetryContext nextAttemptForUnavailablePeer(Peer newTargetPeer) {
        this.unavailablePeers.add(this.targetPeer);
        return this.nextAttempt(newTargetPeer);
    }
}

