/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.prepare.ParameterType;
import org.apache.ignite.internal.sql.engine.prepare.QueryMetadata;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesHelper;
import org.apache.ignite.internal.tx.InternalTransaction;

public class ClientSqlQueryMetadataRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, QueryProcessor processor, ClientResourceRegistry resources) {
        InternalTransaction tx = ClientTableCommon.readTx(in, out, resources);
        String schema = in.unpackString();
        String query = in.unpackString();
        SqlProperties properties = SqlPropertiesHelper.newBuilder().set(QueryProperty.DEFAULT_SCHEMA, (Object)schema).build();
        return processor.prepareSingleAsync(properties, tx, query, new Object[0]).thenAccept(meta -> ClientSqlQueryMetadataRequest.writeMeta(out, meta));
    }

    private static void writeMeta(ClientMessagePacker out, QueryMetadata meta) {
        List types = meta.parameterTypes();
        out.packInt(types.size());
        for (ParameterType param : types) {
            out.packBoolean(param.nullable());
            out.packInt(param.columnType().id());
            out.packInt(param.scale());
            out.packInt(param.precision());
        }
        ClientSqlCommon.packColumns(out, meta.columns());
    }
}

