/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbStorage;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class TxStateRocksDbTableStorage
implements TxStateTableStorage {
    static final int TABLE_PREFIX_SIZE_BYTES = 4;
    private final AtomicReferenceArray<TxStateRocksDbStorage> storages;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    final int id;
    final TxStateRocksDbSharedStorage sharedStorage;

    public TxStateRocksDbTableStorage(int id, int partitions, TxStateRocksDbSharedStorage sharedStorage) {
        this.id = id;
        this.storages = new AtomicReferenceArray(partitions);
        this.sharedStorage = sharedStorage;
    }

    private void checkPartitionId(int partitionId) {
        if (partitionId < 0 || partitionId >= this.storages.length()) {
            throw new IllegalArgumentException(S.toString((String)"Unable to access partition with id outside of configured range", (String)"tableId", (Object)this.id, (boolean)false, (String)"partitionId", (Object)partitionId, (boolean)false, (String)"partitions", (Object)this.storages.length(), (boolean)false));
        }
    }

    @Override
    public TxStateStorage getOrCreateTxStateStorage(int partitionId) {
        this.checkPartitionId(partitionId);
        TxStateRocksDbStorage storage = this.storages.get(partitionId);
        if (storage == null) {
            storage = new TxStateRocksDbStorage(partitionId, this);
            storage.start();
        }
        this.storages.set(partitionId, storage);
        return storage;
    }

    @Override
    @Nullable
    public TxStateStorage getTxStateStorage(int partitionId) {
        return this.storages.get(partitionId);
    }

    @Override
    public void destroyTxStateStorage(int partitionId) {
        this.checkPartitionId(partitionId);
        TxStateStorage storage = this.storages.getAndSet(partitionId, null);
        if (storage != null) {
            storage.destroy();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        try {
            ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
            for (int i = 0; i < this.storages.length(); ++i) {
                TxStateStorage storage = this.storages.get(i);
                if (storage == null) continue;
                resources.add(storage::close);
            }
            Collections.reverse(resources);
            IgniteUtils.closeAll(resources);
        }
        catch (Exception e) {
            throw new IgniteInternalException("Failed to stop transaction state storage of the table: " + this.id, (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        byte[] start = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(this.id).array();
        byte[] end = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(this.id + 1).array();
        try {
            this.close();
            this.sharedStorage.db().deleteRange(start, end);
        }
        catch (Exception e) {
            throw new IgniteInternalException("Failed to destroy the transaction state storage of the table: " + this.id, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

