/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.flow.question;

import java.util.List;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAnswer;
import org.apache.ignite.internal.cli.core.flow.question.QuestionWriterReader;
import org.apache.ignite.internal.cli.core.flow.question.QuestionWriterReaderFactory;

public class QuestionAsker {
    private final QuestionWriterReaderFactory writerReaderFactory;
    private boolean completeFilePaths;
    private boolean maskInput;

    public QuestionAsker(QuestionWriterReaderFactory writerReaderFactory) {
        this.writerReaderFactory = writerReaderFactory;
    }

    public <I, O> O askQuestion(String question, I input, List<QuestionAnswer<I, O>> answers) {
        String userAnswer = this.askQuestion(question);
        for (QuestionAnswer<I, O> answer : answers) {
            if (!answer.isAnswer(userAnswer)) continue;
            return answer.transform(userAnswer, input);
        }
        return this.askQuestion(question, input, answers);
    }

    public String askQuestion(String question) {
        QuestionWriterReader readWriter = this.writerReaderFactory.createWriterReader(this.completeFilePaths);
        return readWriter.readAnswer(question, this.maskInput);
    }

    public QuestionAsker completeFilePaths(boolean completeFilePaths) {
        this.completeFilePaths = completeFilePaths;
        return this;
    }

    public QuestionAsker maskInput(boolean maskInput) {
        this.maskInput = maskInput;
        return this;
    }
}

