/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.impl.io.MonitoringResponseOutOfOrderStrategy;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class TestMonitoringResponseOutOfOrderStrategy {
    private static final ClassicHttpRequest REQUEST = new BasicClassicHttpRequest("POST", "/path");

    TestMonitoringResponseOutOfOrderStrategy() {
    }

    @Test
    void testFirstByteIsNotCheckedSsl() throws IOException {
        boolean earlyResponse = MonitoringResponseOutOfOrderStrategy.INSTANCE.isEarlyResponseDetected(REQUEST, TestMonitoringResponseOutOfOrderStrategy.connection(true, true), TestMonitoringResponseOutOfOrderStrategy.socketInputStream(0), 0L, 1L);
        Assertions.assertFalse((boolean)earlyResponse);
    }

    @Test
    void testFirstByteIsNotCheckedPlain() throws IOException {
        boolean earlyResponse = MonitoringResponseOutOfOrderStrategy.INSTANCE.isEarlyResponseDetected(REQUEST, TestMonitoringResponseOutOfOrderStrategy.connection(true, false), TestMonitoringResponseOutOfOrderStrategy.socketInputStream(1), 0L, 1L);
        Assertions.assertFalse((boolean)earlyResponse);
    }

    @Test
    void testWritesWithinChunkAreNotChecked() throws IOException {
        boolean earlyResponse = MonitoringResponseOutOfOrderStrategy.INSTANCE.isEarlyResponseDetected(REQUEST, TestMonitoringResponseOutOfOrderStrategy.connection(true, true), TestMonitoringResponseOutOfOrderStrategy.socketInputStream(0), 1L, 8190L);
        Assertions.assertFalse((boolean)earlyResponse, (String)"There is data available, but checks shouldn't occur until just prior to the 8192nd byte");
    }

    @Test
    void testWritesAcrossChunksAreChecked() throws IOException {
        boolean earlyResponse = MonitoringResponseOutOfOrderStrategy.INSTANCE.isEarlyResponseDetected(REQUEST, TestMonitoringResponseOutOfOrderStrategy.connection(true, true), TestMonitoringResponseOutOfOrderStrategy.socketInputStream(0), 8191L, 1L);
        Assertions.assertTrue((boolean)earlyResponse);
    }

    @Test
    void testMaximumChunks() throws IOException {
        MonitoringResponseOutOfOrderStrategy strategy = new MonitoringResponseOutOfOrderStrategy(1L, 2L);
        Assertions.assertTrue((boolean)strategy.isEarlyResponseDetected(REQUEST, TestMonitoringResponseOutOfOrderStrategy.connection(true, true), TestMonitoringResponseOutOfOrderStrategy.socketInputStream(0), 0L, 1L));
        Assertions.assertTrue((boolean)strategy.isEarlyResponseDetected(REQUEST, TestMonitoringResponseOutOfOrderStrategy.connection(true, true), TestMonitoringResponseOutOfOrderStrategy.socketInputStream(0), 1L, 2L));
        Assertions.assertFalse((boolean)strategy.isEarlyResponseDetected(REQUEST, TestMonitoringResponseOutOfOrderStrategy.connection(true, true), TestMonitoringResponseOutOfOrderStrategy.socketInputStream(0), 2L, 3L));
    }

    private static InputStream socketInputStream(int available) throws IOException {
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)stream.available()).thenReturn((Object)available);
        return stream;
    }

    private static HttpClientConnection connection(boolean dataAvailable, boolean ssl) throws IOException {
        HttpClientConnection connection = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        Mockito.when((Object)connection.isDataAvailable((Timeout)ArgumentMatchers.any(Timeout.class))).thenReturn((Object)dataAvailable);
        if (ssl) {
            Mockito.when((Object)connection.getSSLSession()).thenReturn(Mockito.mock(SSLSession.class));
        }
        return connection;
    }
}

