/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hop.pipeline.transforms.mail;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.loadsave.LoadSaveTester;
import org.apache.hop.pipeline.transforms.loadsave.initializer.IInitializer;
import org.apache.hop.pipeline.transforms.loadsave.validator.ArrayLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.StringLoadSaveValidator;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class MailMetaTest implements IInitializer<ITransformMeta> {
  LoadSaveTester loadSaveTester;
  Class<MailMeta> testMetaClass = MailMeta.class;
  @ClassRule public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

  @Before
  public void setUpLoadSave() throws Exception {
    HopEnvironment.init();
    PluginRegistry.init();
    List<String> attributes =
        Arrays.asList(
            "server",
            "destination",
            "destinationCc",
            "destinationBCc",
            "replyAddress",
            "replyName",
            "subject",
            "includeDate",
            "includeSubFolders",
            "zipFilenameDynamic",
            "isFilenameDynamic",
            "dynamicFieldname",
            "dynamicWildcard",
            "dynamicZipFilenameField",
            "sourceFileFoldername",
            "sourceWildcard",
            "contactPerson",
            "contactPhone",
            "comment",
            "includingFiles",
            "zipFiles",
            "zipFilename",
            "zipLimitSize",
            "usingAuthentication",
            "authenticationUser",
            "authenticationPassword",
            "onlySendComment",
            "useHTML",
            "usingSecureAuthentication",
            "usePriority",
            "port",
            "priority",
            "importance",
            "sensitivity",
            "secureConnectionType",
            "encoding",
            "replyToAddresses",
            "attachContentFromField",
            "attachContentField",
            "attachContentFileNameField",
            "embeddedImages",
            "contentIds");

    Map<String, String> getterMap =
        new HashMap<String, String>() {
          {
            put("isFilenameDynamic", "isDynamicFilename");
          }
        };
    Map<String, String> setterMap =
        new HashMap<String, String>() {
          {
            put("isFilenameDynamic", "setisDynamicFilename");
          }
        };
    IFieldLoadSaveValidator<String[]> stringArrayLoadSaveValidator =
        new ArrayLoadSaveValidator<>(new StringLoadSaveValidator(), 5);

    Map<String, IFieldLoadSaveValidator<?>> attrValidatorMap = new HashMap<>();
    attrValidatorMap.put("embeddedImages", stringArrayLoadSaveValidator);
    attrValidatorMap.put("contentIds", stringArrayLoadSaveValidator);

    Map<String, IFieldLoadSaveValidator<?>> typeValidatorMap = new HashMap<>();

    loadSaveTester =
        new LoadSaveTester(
            testMetaClass,
            attributes,
            getterMap,
            setterMap,
            attrValidatorMap,
            typeValidatorMap,
            this);
  }

  // Call the allocate method on the LoadSaveTester meta class
  @Override
  public void modify(ITransformMeta someMeta) {
    if (someMeta instanceof MailMeta) {
      ((MailMeta) someMeta).allocate(5);
    }
  }

  @Test
  public void testSerialization() throws HopException {
    loadSaveTester.testSerialization();
  }
}
