/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.fasterxml.jackson.core.Version;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transformservice.launcher.TransformServiceLauncher;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.DefaultExpansionServiceClientFactory;
import org.apache.beam.sdk.util.construction.ExpansionServiceClientFactory;
import org.apache.beam.sdk.util.construction.External;
import org.apache.beam.sdk.util.construction.ExternalTranslationOptions;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolStringList;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ManagedChannelBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformUpgrader
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TransformUpgrader.class);
    private static final @UnknownKeyFor @NonNull @Initialized String UPGRADE_NAMESPACE = "transform:upgrade:";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String UPGRADE_KEY = "upgraded_to_version";
    private @UnknownKeyFor @NonNull @Initialized ExpansionServiceClientFactory clientFactory;

    private TransformUpgrader() {
        this.clientFactory = DefaultExpansionServiceClientFactory.create(endPoint -> ManagedChannelBuilder.forTarget((String)endPoint.getUrl()).usePlaintext().build());
    }

    private TransformUpgrader(@UnknownKeyFor @NonNull @Initialized ExpansionServiceClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public static @UnknownKeyFor @NonNull @Initialized TransformUpgrader of() {
        return new TransformUpgrader();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized TransformUpgrader of(@UnknownKeyFor @NonNull @Initialized ExpansionServiceClientFactory clientFactory) {
        return new TransformUpgrader(clientFactory);
    }

    public  @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline upgradeTransformsViaTransformService( @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> urnsToOverride, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        String serviceAddress;
        List transformsToOverride = pipeline.getComponents().getTransformsMap().entrySet().stream().filter(entry -> {
            String urn = ((RunnerApi.PTransform)entry.getValue()).getSpec().getUrn();
            if (urn != null && urnsToOverride.contains(urn)) {
                return true;
            }
            if (urn.equals(BeamUrns.getUrn(ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM))) {
                try {
                    ExternalTransforms.SchemaTransformPayload schemaTransformPayload = ExternalTransforms.SchemaTransformPayload.parseFrom(((RunnerApi.PTransform)entry.getValue()).getSpec().getPayload());
                    String schemaTransformId = schemaTransformPayload.getIdentifier();
                    if (urnsToOverride.contains(schemaTransformId)) {
                        return true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (!urnsToOverride.isEmpty() && transformsToOverride.isEmpty()) {
            throw new IllegalArgumentException("A list of URNs for overriding transforms was provided but the pipeline did not contain any matching transforms. Either make sure to include at least one matching transform in the pipeline or avoid setting the 'transformsToOverride' PipelineOption. Provided list of URNs: " + urnsToOverride);
        }
        TransformServiceLauncher service = null;
        ExternalTranslationOptions externalTranslationOptions = options.as(ExternalTranslationOptions.class);
        if (externalTranslationOptions.getTransformServiceAddress() != null) {
            serviceAddress = externalTranslationOptions.getTransformServiceAddress();
        } else if (externalTranslationOptions.getTransformServiceBeamVersion() != null) {
            String projectName = UUID.randomUUID().toString();
            int port = TransformUpgrader.findAvailablePort();
            service = TransformServiceLauncher.forProject((String)projectName, (int)port, null);
            service.setBeamVersion(externalTranslationOptions.getTransformServiceBeamVersion());
            service.start();
            service.waitTillUp(-1);
            serviceAddress = "localhost:" + Integer.toString(port);
        } else {
            throw new IllegalArgumentException("Either option TransformServiceAddress or option TransformServiceBeamVersion should be provided to override a transform using the transform service");
        }
        Endpoints.ApiServiceDescriptor expansionServiceEndpoint = Endpoints.ApiServiceDescriptor.newBuilder().setUrl(serviceAddress).build();
        for (String transformId : transformsToOverride) {
            pipeline = this.updateTransformViaTransformService(pipeline, transformId, expansionServiceEndpoint, options);
        }
        if (service != null) {
            service.shutdown();
        }
        return pipeline;
    }

    private  @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline updateTransformViaTransformService( @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline runnerAPIpipeline, @UnknownKeyFor @NonNull @Initialized String transformId,  @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor transformServiceEndpoint, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.PTransform transformToUpgrade = runnerAPIpipeline.getComponents().getTransformsMap().get(transformId);
        if (transformToUpgrade == null) {
            throw new IllegalArgumentException("Could not find a transform with the ID " + transformId);
        }
        byte[] payloadBytes = null;
        if (!transformToUpgrade.getSpec().getUrn().equals(BeamUrns.getUrn(ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM))) {
            ByteString configRowBytes = transformToUpgrade.getAnnotationsOrThrow(BeamUrns.getConstant(ExternalTransforms.Annotations.Enum.CONFIG_ROW_KEY));
            ByteString configRowSchemaBytes = transformToUpgrade.getAnnotationsOrThrow(BeamUrns.getConstant(ExternalTransforms.Annotations.Enum.CONFIG_ROW_SCHEMA_KEY));
            SchemaApi.Schema schema = SchemaApi.Schema.parseFrom(configRowSchemaBytes.toByteArray());
            payloadBytes = ExternalTransforms.ExternalConfigurationPayload.newBuilder().setSchema(schema).setPayload(configRowBytes).build().toByteArray();
        } else {
            payloadBytes = transformToUpgrade.getSpec().getPayload().toByteArray();
        }
        RunnerApi.PTransform.Builder ptransformBuilder = RunnerApi.PTransform.newBuilder().setUniqueName(transformToUpgrade.getUniqueName() + "_external").setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(transformToUpgrade.getSpec().getUrn()).setPayload(ByteString.copyFrom((byte[])payloadBytes)).build());
        for (Map.Entry entry2 : transformToUpgrade.getInputsMap().entrySet()) {
            ptransformBuilder.putInputs((String)entry2.getKey(), (String)entry2.getValue());
        }
        for (Map.Entry entry3 : transformToUpgrade.getOutputsMap().entrySet()) {
            ptransformBuilder.putOutputs((String)entry3.getKey(), (String)entry3.getValue());
        }
        ExpansionApi.ExpansionRequest.Builder requestBuilder = ExpansionApi.ExpansionRequest.newBuilder();
        PipelineOptions pipelineOptions = PipelineOptionsTranslation.fromProto(PipelineOptionsTranslation.toProto(options));
        String updateCompatibilityVersion = pipelineOptions.as(StreamingOptions.class).getUpdateCompatibilityVersion();
        if (updateCompatibilityVersion == null || updateCompatibilityVersion.isEmpty()) {
            pipelineOptions.as(StreamingOptions.class).setUpdateCompatibilityVersion(ReleaseInfo.getReleaseInfo().getSdkVersion());
        }
        ExpansionApi.ExpansionRequest request = requestBuilder.setComponents(runnerAPIpipeline.getComponents()).setTransform(ptransformBuilder.build()).setNamespace(UPGRADE_NAMESPACE).setPipelineOptions(PipelineOptionsTranslation.toProto(pipelineOptions)).addAllRequirements((Iterable)runnerAPIpipeline.getRequirementsList()).build();
        ExpansionApi.ExpansionResponse response = this.clientFactory.getExpansionServiceClient(transformServiceEndpoint).expand(request);
        if (!Strings.isNullOrEmpty((String)response.getError())) {
            throw new RuntimeException(String.format("expansion service error: %s", response.getError()));
        }
        Map<String, RunnerApi.Environment> newEnvironmentsWithDependencies = response.getComponents().getEnvironmentsMap().entrySet().stream().filter(kv -> !runnerAPIpipeline.getComponents().getEnvironmentsMap().containsKey(kv.getKey()) && ((RunnerApi.Environment)kv.getValue()).getDependenciesCount() != 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        RunnerApi.Components expandedComponents = response.getComponents().toBuilder().putAllEnvironments(External.ExpandableTransform.resolveArtifacts(newEnvironmentsWithDependencies, transformServiceEndpoint)).build();
        RunnerApi.PTransform expandedTransform = response.getTransform();
        RunnerApi.PTransform.Builder expandedTransformBuilder = expandedTransform.toBuilder();
        String transformServiceVersion = options.as(ExternalTranslationOptions.class).getTransformServiceBeamVersion();
        if (transformServiceVersion == null || transformServiceVersion.isEmpty()) {
            transformServiceVersion = "unknown";
        }
        expandedTransformBuilder.putAnnotations(UPGRADE_KEY, ByteString.copyFromUtf8((String)transformServiceVersion));
        expandedTransform = expandedTransformBuilder.build();
        ProtocolStringList expandedRequirements = response.getRequirementsList();
        RunnerApi.Components.Builder newComponentsBuilder = expandedComponents.toBuilder();
        Collection<String> oldOutputs = transformToUpgrade.getOutputsMap().values();
        HashMap<String, String> inputReplacements = new HashMap<String, String>();
        if (transformToUpgrade.getOutputsMap().size() == 1) {
            inputReplacements.put(oldOutputs.iterator().next(), expandedTransform.getOutputsMap().values().iterator().next());
        } else {
            for (Map.Entry<String, String> entry3 : transformToUpgrade.getOutputsMap().entrySet()) {
                if (!expandedTransform.getOutputsMap().keySet().contains(entry3.getKey())) {
                    throw new IllegalArgumentException("Original transform had an output with tag " + entry3.getKey() + " but upgraded transform did not.");
                }
                String newOutput = expandedTransform.getOutputsMap().get(entry3.getKey());
                if (newOutput == null) {
                    throw new IllegalArgumentException("Could not find an output with tag " + entry3.getKey() + " for the transform " + expandedTransform);
                }
                inputReplacements.put(entry3.getValue(), newOutput);
            }
        }
        ArrayList<String> transformsToRemove = new ArrayList<String>();
        TransformUpgrader.recursivelyFindSubTransforms(transformId, runnerAPIpipeline.getComponents(), transformsToRemove);
        Map<String, RunnerApi.PTransform> updatedExpandedTransformMap = expandedComponents.getTransformsMap().entrySet().stream().filter(entry -> !transformsToRemove.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            Map<String, String> inputsMap = ((RunnerApi.PTransform)entry.getValue()).getInputsMap();
            RunnerApi.PTransform.Builder transformBuilder = ((RunnerApi.PTransform)entry.getValue()).toBuilder();
            if (!Collections.disjoint(inputsMap.values(), inputReplacements.keySet())) {
                HashMap<String, String> updatedInputsMap = new HashMap<String, String>();
                for (Map.Entry<String, String> inputEntry : inputsMap.entrySet()) {
                    String updaterValue = inputReplacements.containsKey(inputEntry.getValue()) ? (String)inputReplacements.get(inputEntry.getValue()) : inputEntry.getValue();
                    updatedInputsMap.put(inputEntry.getKey(), updaterValue);
                }
                transformBuilder.clearInputs();
                transformBuilder.putAllInputs(updatedInputsMap);
            }
            return transformBuilder.build();
        }));
        newComponentsBuilder.clearTransforms();
        newComponentsBuilder.putAllTransforms(updatedExpandedTransformMap);
        newComponentsBuilder.putTransforms(transformId, expandedTransform);
        RunnerApi.Pipeline.Builder newRunnerAPIPipelineBuilder = runnerAPIpipeline.toBuilder();
        newRunnerAPIPipelineBuilder.clearComponents();
        newRunnerAPIPipelineBuilder.setComponents(newComponentsBuilder.build());
        newRunnerAPIPipelineBuilder.addAllRequirements((Iterable<String>)expandedRequirements);
        return newRunnerAPIPipelineBuilder.build();
    }

    private static void recursivelyFindSubTransforms(@UnknownKeyFor @NonNull @Initialized String transformId,  @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> results) {
        results.add(transformId);
        RunnerApi.PTransform transform = components.getTransformsMap().get(transformId);
        if (transform == null) {
            throw new IllegalArgumentException("Could not find a transform with id " + transformId);
        }
        ProtocolStringList subTransforms = transform.getSubtransformsList();
        if (subTransforms != null) {
            for (String subTransformId : subTransforms) {
                TransformUpgrader.recursivelyFindSubTransforms(subTransformId, components, results);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized int findAvailablePort() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ServerSocket s = new ServerSocket(0);
        try {
            int n = s.getLocalPort();
            return n;
        }
        finally {
            s.close();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.clientFactory.close();
    }

    public static @Nullable @UnknownKeyFor @Initialized String findUpgradeURN(@UnknownKeyFor @NonNull @Initialized PTransform transform) {
        for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
            for (Map.Entry<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> entry : registrar.getTransformPayloadTranslators().entrySet()) {
                if (!entry.getKey().equals(transform.getClass())) continue;
                return entry.getValue().getUrn();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Object object) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(object);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static @UnknownKeyFor @NonNull @Initialized Object fromByteArray(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) throws @UnknownKeyFor @NonNull @Initialized InvalidClassException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                object = in.readObject();
            }
            return object;
        }
        catch (InvalidClassException e) {
            LOG.info("An object cannot be re-generated from the provided byte array. Caller may use the default value for the parameter when upgrading. Underlying error: " + e);
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Version getVersionFromStr(@UnknownKeyFor @NonNull @Initialized String version) {
        String[] versionParts = Splitter.onPattern((String)"\\.").splitToList((CharSequence)version).toArray(new String[0]);
        if (versionParts.length < 2) {
            throw new IllegalArgumentException("Expected the version string to start with `<major>.<minor>` but received " + version);
        }
        String patchAndSuffix = versionParts.length == 2 ? "" : String.join((CharSequence)".", Arrays.copyOfRange(versionParts, 2, versionParts.length));
        StringBuilder patchVersionBuilder = new StringBuilder();
        for (int i = 0; i < patchAndSuffix.length() && Character.isDigit(patchAndSuffix.charAt(i)); ++i) {
            patchVersionBuilder.append(patchAndSuffix.charAt(i));
        }
        String patchVersion = patchVersionBuilder.toString();
        if (patchVersion.isEmpty()) {
            patchVersion = "0";
        }
        return new Version(Integer.parseInt(versionParts[0]), Integer.parseInt(versionParts[1]), Integer.parseInt(patchVersion), null, null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized int compareVersions(@UnknownKeyFor @NonNull @Initialized String firstVersion, @UnknownKeyFor @NonNull @Initialized String secondVersion) {
        if (firstVersion.equals(secondVersion)) {
            return 0;
        }
        return TransformUpgrader.getVersionFromStr(firstVersion).compareTo(TransformUpgrader.getVersionFromStr(secondVersion));
    }
}

