/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class SideInputStorage {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Key<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Value<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> materializedSideInputs = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    SideInputStorage() {
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Key<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Value<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getMaterializedSideInputs() {
        return materializedSideInputs;
    }

    public static class Value<@UnknownKeyFor T> {
        final T value;

        Value(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class Key<@UnknownKeyFor T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<T> view;
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;

        Key(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            this.view = view;
            this.window = window;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.view, key.view) && Objects.equals(this.window, key.window);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.view, this.window);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            String pName = this.view.getPCollection() != null ? this.view.getPCollection().getName() : "Unknown";
            return "Key{view=" + this.view.getTagInternal() + " of PCollection[" + pName + "], window=" + this.window + '}';
        }
    }
}

