/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.stateful.SparkGroupAlsoByWindowViaWindowSet;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.GroupCombineFunctions;
import org.apache.beam.runners.spark.translation.SingleEmitInputDStream;
import org.apache.beam.runners.spark.translation.SparkExecutableStageContextFactory;
import org.apache.beam.runners.spark.translation.SparkExecutableStageExtractionFunction;
import org.apache.beam.runners.spark.translation.SparkExecutableStageFunction;
import org.apache.beam.runners.spark.translation.SparkPortablePipelineTranslator;
import org.apache.beam.runners.spark.translation.SparkStreamingTranslationContext;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.streaming.UnboundedDataset;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.util.construction.graph.QueryablePipeline;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.reflect.ClassTag;

public class SparkStreamingPortablePipelineTranslator
implements SparkPortablePipelineTranslator<SparkStreamingTranslationContext> {
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformTranslator> urnToTransformTranslator;

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> knownUrns() {
        return this.urnToTransformTranslator.keySet();
    }

    public SparkStreamingPortablePipelineTranslator() {
        ImmutableMap.Builder translatorMap = ImmutableMap.builder();
        translatorMap.put((Object)"beam:transform:impulse:v1", SparkStreamingPortablePipelineTranslator::translateImpulse);
        translatorMap.put((Object)"beam:transform:group_by_key:v1", SparkStreamingPortablePipelineTranslator::translateGroupByKey);
        translatorMap.put((Object)"beam:runner:executable_stage:v1", SparkStreamingPortablePipelineTranslator::translateExecutableStage);
        translatorMap.put((Object)"beam:transform:flatten:v1", SparkStreamingPortablePipelineTranslator::translateFlatten);
        translatorMap.put((Object)"beam:transform:reshuffle:v1", SparkStreamingPortablePipelineTranslator::translateReshuffle);
        this.urnToTransformTranslator = translatorMap.build();
    }

    @Override
    public void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext context) {
        QueryablePipeline p = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        for (PipelineNode.PTransformNode transformNode : p.getTopologicallyOrderedTransforms()) {
            ((PTransformTranslator)this.urnToTransformTranslator.getOrDefault((Object)transformNode.getTransform().getSpec().getUrn(), SparkStreamingPortablePipelineTranslator::urnNotFound)).translate(transformNode, pipeline, context);
        }
    }

    private static void urnNotFound(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext context) {
        throw new IllegalArgumentException(String.format("Transform %s has unknown URN %s", transformNode.getId(), transformNode.getTransform().getSpec().getUrn()));
    }

    private static void translateImpulse(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext context) {
        List<WindowedValue> windowedValues = Collections.singletonList(WindowedValues.of((Object)new byte[0], (Instant)BoundedWindow.TIMESTAMP_MIN_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING));
        WindowedValues.FullWindowedValueCoder windowCoder = WindowedValues.FullWindowedValueCoder.of((Coder)ByteArrayCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE);
        JavaRDD emptyByteArrayRDD = context.getSparkContext().parallelize(CoderHelpers.toByteArrays(windowedValues, windowCoder)).map(CoderHelpers.fromByteFunction(windowCoder));
        SingleEmitInputDStream inputDStream = new SingleEmitInputDStream(context.getStreamingContext().ssc(), emptyByteArrayRDD.rdd());
        JavaDStream stream = JavaDStream.fromDStream(inputDStream, (ClassTag)JavaSparkContext$.MODULE$.fakeClassTag());
        UnboundedDataset output = new UnboundedDataset(stream, Collections.singletonList(inputDStream.id()));
        GlobalWatermarkHolder.SparkWatermarks sparkWatermark = new GlobalWatermarkHolder.SparkWatermarks(GlobalWindow.INSTANCE.maxTimestamp(), BoundedWindow.TIMESTAMP_MAX_VALUE, context.getFirstTimestamp());
        GlobalWatermarkHolder.add(output.getStreamSources().get(0), sparkWatermark);
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), output);
    }

    private static <K, V> void translateGroupByKey(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext context) {
        RunnerApi.Components components = pipeline.getComponents();
        String inputId = PipelineTranslatorUtils.getInputId((PipelineNode.PTransformNode)transformNode);
        UnboundedDataset inputDataset = (UnboundedDataset)context.popDataset(inputId);
        List<Integer> streamSources = inputDataset.getStreamSources();
        WindowedValues.WindowedValueCoder inputCoder = PipelineTranslatorUtils.getWindowedValueCoder((String)inputId, (RunnerApi.Components)components);
        KvCoder inputKvCoder = (KvCoder)inputCoder.getValueCoder();
        WindowingStrategy windowingStrategy = PipelineTranslatorUtils.getWindowingStrategy((String)inputId, (RunnerApi.Components)components);
        WindowFn windowFn = windowingStrategy.getWindowFn();
        WindowedValues.FullWindowedValueCoder wvCoder = WindowedValues.FullWindowedValueCoder.of((Coder)inputKvCoder.getValueCoder(), (Coder)windowFn.windowCoder());
        JavaDStream outStream = SparkGroupAlsoByWindowViaWindowSet.groupByKeyAndWindow(inputDataset.getDStream(), inputKvCoder.getKeyCoder(), wvCoder, windowingStrategy, context.getSerializableOptions(), streamSources, transformNode.getId());
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), new UnboundedDataset(outStream, streamSources));
    }

    private static <InputT, OutputT, SideInputT> void translateExecutableStage(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext context) {
        RunnerApi.ExecutableStagePayload stagePayload;
        try {
            stagePayload = RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transformNode.getTransform().getSpec().getPayload());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String inputPCollectionId = stagePayload.getInput();
        UnboundedDataset inputDataset = (UnboundedDataset)context.popDataset(inputPCollectionId);
        List<Integer> streamSources = inputDataset.getStreamSources();
        JavaDStream inputDStream = inputDataset.getDStream();
        Map outputs = transformNode.getTransform().getOutputsMap();
        BiMap outputMap = PipelineTranslatorUtils.createOutputMap(outputs.values());
        RunnerApi.Components components = pipeline.getComponents();
        Coder windowCoder = PipelineTranslatorUtils.getWindowingStrategy((String)inputPCollectionId, (RunnerApi.Components)components).getWindowFn().windowCoder();
        if (stagePayload.getSideInputsCount() > 0) {
            throw new UnsupportedOperationException("Side inputs to executable stage are currently unsupported.");
        }
        ImmutableMap broadcastVariables = ImmutableMap.copyOf(new HashMap());
        SparkExecutableStageFunction function = new SparkExecutableStageFunction(context.getSerializableOptions(), stagePayload, context.jobInfo, (Map<String, Integer>)outputMap, SparkExecutableStageContextFactory.getInstance(), broadcastVariables, MetricsAccumulator.getInstance(), windowCoder);
        final JavaDStream staged = inputDStream.mapPartitions(function);
        String intermediateId = PipelineTranslatorUtils.getExecutableStageIntermediateId((PipelineNode.PTransformNode)transformNode);
        context.pushDataset(intermediateId, new Dataset(){

            @Override
            public void cache(@UnknownKeyFor @NonNull @Initialized String storageLevel, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
                StorageLevel level = StorageLevel.fromString((String)storageLevel);
                staged.persist(level);
            }

            @Override
            public void action() {
                staged.foreachRDD(TranslationUtils.emptyVoidFunction());
            }

            @Override
            public void setName(@UnknownKeyFor @NonNull @Initialized String name) {
            }
        });
        context.popDataset(intermediateId);
        for (String outputId : outputs.values()) {
            JavaDStream outStream = staged.flatMap(new SparkExecutableStageExtractionFunction((Integer)outputMap.get((Object)outputId)));
            context.pushDataset(outputId, new UnboundedDataset(outStream, streamSources));
        }
        if (outputs.isEmpty()) {
            JavaDStream outStream = staged.flatMap((FlatMapFunction & Serializable)rawUnionValue -> Collections.emptyIterator());
            context.pushDataset(String.format("EmptyOutputSink_%d", context.nextSinkId()), new UnboundedDataset(outStream, streamSources));
        }
    }

    private static <T> void translateFlatten(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext context) {
        JavaDStream unifiedStreams;
        Map inputsMap = transformNode.getTransform().getInputsMap();
        ArrayList<Integer> streamSources = new ArrayList<Integer>();
        if (inputsMap.isEmpty()) {
            JavaRDD emptyRDD = context.getSparkContext().emptyRDD();
            SingleEmitInputDStream singleEmitInputDStream = new SingleEmitInputDStream(context.getStreamingContext().ssc(), emptyRDD.rdd());
            unifiedStreams = JavaDStream.fromDStream(singleEmitInputDStream, (ClassTag)JavaSparkContext$.MODULE$.fakeClassTag());
        } else {
            ArrayList<Object> dStreams = new ArrayList<Object>();
            for (String inputId : inputsMap.values()) {
                Dataset dataset = context.popDataset(inputId);
                if (dataset instanceof UnboundedDataset) {
                    UnboundedDataset unboundedDataset = (UnboundedDataset)dataset;
                    streamSources.addAll(unboundedDataset.getStreamSources());
                    dStreams.add(unboundedDataset.getDStream());
                    continue;
                }
                SingleEmitInputDStream singleEmitInputDStream = new SingleEmitInputDStream(context.getStreamingContext().ssc(), ((BoundedDataset)dataset).getRDD().rdd());
                JavaDStream dStream = JavaDStream.fromDStream(singleEmitInputDStream, (ClassTag)JavaSparkContext$.MODULE$.fakeClassTag());
                dStreams.add(dStream);
            }
            unifiedStreams = context.getStreamingContext().union((Seq)JavaConverters.asScalaBuffer(dStreams));
        }
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), new UnboundedDataset(unifiedStreams, streamSources));
    }

    private static <T> void translateReshuffle(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext context) {
        String inputId = PipelineTranslatorUtils.getInputId((PipelineNode.PTransformNode)transformNode);
        UnboundedDataset inputDataset = (UnboundedDataset)context.popDataset(inputId);
        List<Integer> streamSources = inputDataset.getStreamSources();
        JavaDStream dStream = inputDataset.getDStream();
        WindowedValues.WindowedValueCoder coder = PipelineTranslatorUtils.getWindowedValueCoder((String)inputId, (RunnerApi.Components)pipeline.getComponents());
        JavaDStream reshuffledStream = dStream.transform((Function & Serializable)rdd -> GroupCombineFunctions.reshuffle(rdd, coder));
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), new UnboundedDataset(reshuffledStream, streamSources));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext createTranslationContext(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        return new SparkStreamingTranslationContext(jsc, options, jobInfo);
    }

    static interface PTransformTranslator {
        public void translate(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline var2, @UnknownKeyFor @NonNull @Initialized SparkStreamingTranslationContext var3);
    }
}

