/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.gui;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.engines.dataflow.BeamDataFlowPipelineEngine;
import org.apache.hop.beam.pipeline.fatjar.FatJarBuilder;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.perspective.execution.ExecutionPerspective;
import org.apache.hop.ui.hopgui.perspective.execution.IExecutionViewer;
import org.apache.hop.ui.hopgui.perspective.execution.PipelineExecutionViewer;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.widgets.Shell;

@GuiPlugin
public class HopBeamGuiPlugin {
    public static final Class<?> PKG = HopBeamGuiPlugin.class;
    public static final String ID_MAIN_MENU_TOOLS_FAT_JAR = "40200-menu-tools-fat-jar";
    public static final String ID_MAIN_MENU_TOOLS_EXPORT_METADATA = "40210-menu-tools-export-metadata";
    public static final String TOOLBAR_ID_VISIT_GCP_DATAFLOW = "HopGuiPipelineGraph-ToolBar-10450-VisitGcpDataflow";
    public static final String TOOLBAR_ID_PIPELINE_EXECUTION_VIEWER_VISIT_GCP_DATAFLOW = "PipelineExecutionViewer-Toolbar-20000-VisitGcpDataflow";
    private static HopBeamGuiPlugin instance;

    public static HopBeamGuiPlugin getInstance() {
        if (instance == null) {
            instance = new HopBeamGuiPlugin();
        }
        return instance;
    }

    @GuiMenuElement(root="HopGui-Menu", id="40200-menu-tools-fat-jar", label="i18n::BeamGuiPlugin.Menu.GenerateFatJar.Text", parentId="40000-menu-tools", image="beam-logo.svg", separator=true)
    public void menuToolsFatJar() {
        HopGui hopGui = HopGui.getInstance();
        Shell shell = hopGui.getShell();
        MessageBox box = new MessageBox(shell, 290);
        box.setText(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Dialog.Message1", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Dialog.Message2", (String[])new String[0]));
        int answer = box.open();
        if ((answer & 0x100) != 0) {
            return;
        }
        String filename = BaseDialog.presentFileDialog((boolean)true, (Shell)shell, (String[])new String[]{"*.jar", "*.*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.Jars.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.All.Label", (String[])new String[0])}, (boolean)true);
        if (filename == null) {
            return;
        }
        try {
            List<String> jarFilenames = HopBeamGuiPlugin.findInstalledJarFilenames();
            IRunnableWithProgress op = monitor -> {
                try {
                    monitor.setTaskName(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Progress.Message", (String[])new String[0]));
                    FatJarBuilder fatJarBuilder = new FatJarBuilder(hopGui.getLog(), hopGui.getVariables(), filename, jarFilenames);
                    fatJarBuilder.setExtraTransformPluginClasses(null);
                    fatJarBuilder.setExtraXpPluginClasses(null);
                    fatJarBuilder.buildTargetJar();
                    monitor.done();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Error building fat jar: " + e.getMessage());
                }
            };
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            pmd.run(false, op);
            GuiResource.getInstance().toClipboard(filename);
            box = new MessageBox(shell, 66);
            box.setText(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FatJarCreated.Dialog.Header", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FatJarCreated.Dialog.Message1", (String[])new String[]{filename}) + Const.CR + BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FatJarCreated.Dialog.Message2", (String[])new String[0]));
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(shell, "Error", "Error creating fat jar", e);
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="40210-menu-tools-export-metadata", label="i18n::BeamGuiPlugin.Menu.ExportMetadata.Text", parentId="40000-menu-tools", image="beam-logo.svg", separator=true)
    public void menuToolsExportMetadata() {
        HopGui hopGui = HopGui.getInstance();
        Shell shell = hopGui.getShell();
        MessageBox box = new MessageBox(shell, 290);
        box.setText(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.ExportMetadata.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.ExportMetadata.Dialog.Message", (String[])new String[0]));
        int answer = box.open();
        if ((answer & 0x100) != 0) {
            return;
        }
        String filename = BaseDialog.presentFileDialog((boolean)true, (Shell)shell, (String[])new String[]{"*.json", "*.*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.Json.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.All.Label", (String[])new String[0])}, (boolean)true);
        if (filename == null) {
            return;
        }
        try {
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider((IHopMetadataProvider)hopGui.getMetadataProvider());
            String jsonString = metadataProvider.toJson();
            String realFilename = hopGui.getVariables().resolve(filename);
            try (OutputStream outputStream = HopVfs.getOutputStream((String)realFilename, (boolean)false);){
                outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            new ErrorDialog(shell, "Error", "Error saving metadata to JSON file : " + filename, e);
        }
    }

    public static final List<String> findInstalledJarFilenames() {
        HashSet jarFiles = new HashSet();
        jarFiles.addAll(FileUtils.listFiles((File)new File("lib"), (String[])new String[]{"jar"}, (boolean)true));
        File libSwtFiles = new File("lib/swt/linux/x86_64");
        if (libSwtFiles.exists()) {
            jarFiles.addAll(FileUtils.listFiles((File)libSwtFiles, (String[])new String[]{"jar"}, (boolean)true));
        }
        jarFiles.addAll(FileUtils.listFiles((File)new File("plugins"), (String[])new String[]{"jar"}, (boolean)true));
        File hopWebJars = new File("webapps/ROOT/WEB-INF/lib");
        if (hopWebJars.exists()) {
            jarFiles.addAll(FileUtils.listFiles((File)hopWebJars, (String[])new String[]{"jar"}, (boolean)true));
        }
        ArrayList<String> jarFilenames = new ArrayList<String>();
        jarFiles.forEach(file -> jarFilenames.add(file.toString()));
        return jarFilenames;
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10450-VisitGcpDataflow", toolTip="i18n::BeamGuiPlugin.VisitDataflow.ToolTip", image="dataflow.svg", separator=true)
    public void pipelineGraphVisitGcpDataflow() {
        DataflowPipelineJob dataflowPipelineJob = HopBeamGuiPlugin.findDataflowPipelineJob();
        if (dataflowPipelineJob == null) {
            return;
        }
        String jobId = dataflowPipelineJob.getJobId();
        String projectId = dataflowPipelineJob.getProjectId();
        String region = dataflowPipelineJob.getRegion();
        this.openDataflowJobInConsole(jobId, projectId, region);
    }

    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-Toolbar-20000-VisitGcpDataflow", toolTip="i18n::BeamGuiPlugin.VisitDataflow.ToolTip", image="dataflow.svg", separator=true)
    public void executionViewerVisitGcpDataflow() {
        ExecutionState executionState = HopBeamGuiPlugin.findExecutionState();
        if (executionState != null) {
            String jobId = (String)executionState.getDetails().get("dataflow.job.id");
            String projectId = (String)executionState.getDetails().get("dataflow.project.id");
            String region = (String)executionState.getDetails().get("dataflow.region");
            if (StringUtils.isEmpty((String)jobId) || StringUtils.isEmpty((String)projectId) || StringUtils.isEmpty((String)region)) {
                return;
            }
            this.openDataflowJobInConsole(jobId, projectId, region);
        }
    }

    public static ExecutionState findExecutionState() {
        ExecutionPerspective perspective = HopGui.getExecutionPerspective();
        if (perspective == null) {
            return null;
        }
        IExecutionViewer activeViewer = perspective.getActiveViewer();
        if (activeViewer == null) {
            return null;
        }
        if (!(activeViewer instanceof PipelineExecutionViewer)) {
            return null;
        }
        PipelineExecutionViewer viewer = (PipelineExecutionViewer)activeViewer;
        return viewer.getExecutionState();
    }

    public void openDataflowJobInConsole(String jobId, String projectId, String region) {
        String url = "https://console.cloud.google.com/dataflow/jobs/" + region + "/" + jobId + ";graphView=0?project=" + projectId;
        try {
            EnvironmentUtils.getInstance().openUrl(url);
        }
        catch (HopException e) {
            HopGui hopGui = HopGui.getInstance();
            Shell shell = hopGui.getShell();
            MessageBox box = new MessageBox(shell, 65);
            box.setText(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.OpenDataflowJob.Dialog.Header", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.OpenDataflowJob.Dialog.Message", (String[])new String[]{url, e.getMessage()}));
            box.open();
        }
    }

    public static DataflowPipelineJob findDataflowPipelineJob() {
        IHopFileTypeHandler typeHandler = HopGui.getInstance().getActiveFileTypeHandler();
        if (typeHandler == null) {
            return null;
        }
        if (!(typeHandler instanceof HopGuiPipelineGraph)) {
            return null;
        }
        HopGuiPipelineGraph graph = (HopGuiPipelineGraph)typeHandler;
        if (graph.getPipeline() == null) {
            return null;
        }
        if (!(graph.getPipeline() instanceof BeamDataFlowPipelineEngine)) {
            return null;
        }
        BeamDataFlowPipelineEngine pipeline = (BeamDataFlowPipelineEngine)graph.getPipeline();
        if (pipeline.getBeamPipelineResults() == null) {
            return null;
        }
        return (DataflowPipelineJob)pipeline.getBeamPipelineResults();
    }
}

