/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrooutput;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.avro.transforms.avrooutput.AvroOutput;
import org.apache.hop.avro.transforms.avrooutput.AvroOutputData;
import org.apache.hop.avro.transforms.avrooutput.AvroOutputField;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBinary;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="AvroOutput", name="i18n::AvroOutputDialog.DialogTitle", description="i18n::AvroOutputDialog.Description", image="avro_output.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/avro-file-output.html", keywords={"i18n::AvroFileOutputMeta.keyword"})
public class AvroOutputMeta
extends BaseTransformMeta<AvroOutput, AvroOutputData> {
    private static final Class<?> PKG = AvroOutputMeta.class;
    public static final String[] compressionTypes = new String[]{"none", "deflate", "snappy", "bzip2"};
    public static final String[] OUTPUT_TYPES = new String[]{"BinaryFile", "BinaryField", "JsonField"};
    public static final int OUTPUT_TYPE_BINARY_FILE = 0;
    public static final int OUTPUT_TYPE_FIELD = 1;
    public static final int OUTPUT_TYPE_JSON_FIELD = 2;
    @HopMetadataProperty(key="filename", injectionKeyDescription="AvroOutput.Injection.FILENAME")
    private String fileName;
    @HopMetadataProperty(key="schemafilename", injectionKeyDescription="AvroOutput.Injection.SCHEMA_FILENAME")
    private String schemaFileName;
    @HopMetadataProperty(key="create_schema_file", injectionKeyDescription="AvroOutput.Injection.AUTO_CREATE_SCHEMA")
    private boolean createSchemaFile;
    @HopMetadataProperty(key="write_schema_file", defaultBoolean=true, injectionKeyDescription="AvroOutput.Injection.WRITE_SCHEMA_TO_FILE")
    private boolean writeSchemaFile;
    @HopMetadataProperty(key="namespace", injectionKey="AVRO_NAMESPACE", injectionKeyDescription="AvroOutput.Injection.AVRO_NAMESPACE")
    private String namespace;
    @HopMetadataProperty(key="recordname", injectionKeyDescription="AvroOutput.Injection.AVRO_RECORD_NAME")
    private String recordName;
    @HopMetadataProperty(key="doc", injectionKeyDescription="AvroOutput.Injection.AVRO_DOC")
    private String doc;
    @HopMetadataProperty(key="create_parent_folder", injectionKeyDescription="AvroOutput.Injection.CREATE_PARENT_FOLDER")
    private boolean createParentFolder = true;
    @HopMetadataProperty(key="split", injectionKeyDescription="AvroOutput.Injection.INCLUDE_TRANSFORM_NR")
    private boolean transformNrInFilename;
    @HopMetadataProperty(key="haspartno", injectionKeyDescription="AvroOutput.Injection.INCLUDE_PART_NR")
    private boolean partNrInFilename;
    @HopMetadataProperty(key="add_date", injectionKeyDescription="AvroOutput.Injection.INCLUDE_DATE")
    private boolean dateInFilename;
    @HopMetadataProperty(key="add_time", injectionKeyDescription="AvroOutput.Injection.INCLUDE_TIME")
    private boolean timeInFilename;
    @HopMetadataProperty(key="compressiontype", injectionKeyDescription="AvroOutput.Injection.COMPRESSION_CODEC")
    private String compressionType;
    @HopMetadataProperty(key="field", groupKey="fields", injectionGroupDescription="AvroOutput.Injection.OUTPUT_FIELDS")
    private List<AvroOutputField> outputFields = new ArrayList<AvroOutputField>();
    @HopMetadataProperty(key="add_to_result_filenames", injectionKeyDescription="AvroOutput.Injection.ADD_TO_RESULT")
    private boolean addToResultFilenames;
    @HopMetadataProperty(key="SpecifyFormat", injectionKeyDescription="AvroOutput.Injection.SPECIFY_FORMAT")
    private boolean specifyingFormat;
    @HopMetadataProperty(key="date_time_format", injectionKeyDescription="AvroOutput.Injection.DATE_FORMAT")
    private String dateTimeFormat;
    @HopMetadataProperty(key="output_type", injectionKeyDescription="AvroOutput.Injection.OUTPUT_TYPE")
    private String outputType;
    @HopMetadataProperty(key="output_field_name", injectionKeyDescription="AvroOutput.Injection.OUTPUT_FIELD_NAME")
    private String outputFieldName;

    public void setWriteSchemaFile(boolean writeSchemaFile) {
        this.writeSchemaFile = writeSchemaFile;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSchemaFileName() {
        return this.schemaFileName;
    }

    public void setSchemaFileName(String schemaFileName) {
        this.schemaFileName = schemaFileName;
    }

    public void setTransformNrInFilename(boolean transformNrInFilename) {
        this.transformNrInFilename = transformNrInFilename;
    }

    public void setPartNrInFilename(boolean partNrInFilename) {
        this.partNrInFilename = partNrInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setSpecifyingFormat(boolean specifyingFormat) {
        this.specifyingFormat = specifyingFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public int getOutputTypeId() {
        if (this.outputType != null) {
            for (int i = 0; i < OUTPUT_TYPES.length; ++i) {
                if (!this.outputType.equals(OUTPUT_TYPES[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void setOutputTypeById(int outputTypeId) {
        this.outputType = outputTypeId >= 0 && outputTypeId < OUTPUT_TYPES.length ? OUTPUT_TYPES[outputTypeId] : null;
    }

    public String getOutputFieldName() {
        return this.outputFieldName;
    }

    public void setOutputFieldName(String outputFieldName) {
        this.outputFieldName = outputFieldName;
    }

    public List<AvroOutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<AvroOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public boolean isCreateSchemaFile() {
        return this.createSchemaFile;
    }

    public boolean isWriteSchemaFile() {
        return this.writeSchemaFile;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public boolean isTransformNrInFilename() {
        return this.transformNrInFilename;
    }

    public boolean isPartNrInFilename() {
        return this.partNrInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isAddToResultFilenames() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFilenames(boolean addToResultFilenames) {
        this.addToResultFilenames = addToResultFilenames;
    }

    public boolean isSpecifyingFormat() {
        return this.specifyingFormat;
    }

    public void setCreateSchemaFile(boolean createSchemaFile) {
        this.createSchemaFile = createSchemaFile;
    }

    public Object clone() {
        AvroOutputMeta retval = new AvroOutputMeta();
        for (AvroOutputField field : this.outputFields) {
            retval.getOutputFields().add(new AvroOutputField(field));
        }
        return retval;
    }

    public void setDefault() {
        this.createParentFolder = true;
        this.createSchemaFile = false;
        this.writeSchemaFile = true;
        this.namespace = "namespace";
        this.recordName = "recordname";
        this.specifyingFormat = false;
        this.dateTimeFormat = null;
        this.fileName = "";
        this.schemaFileName = "";
        this.transformNrInFilename = false;
        this.partNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.addToResultFilenames = true;
        this.compressionType = "none";
        this.outputType = OUTPUT_TYPES[0];
        this.outputFieldName = "avro_record";
    }

    public String buildFilename(String baseFilename, IVariables space, int transformNr, String partNr, boolean beamContext, String transformId, int bundleNr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String realBaseFileName = space.resolve(baseFilename);
        String extension = "";
        Object filename = "";
        if (realBaseFileName.contains(".")) {
            filename = realBaseFileName.substring(0, realBaseFileName.lastIndexOf("."));
            extension = realBaseFileName.substring(realBaseFileName.lastIndexOf(".") + 1);
        } else {
            filename = realBaseFileName;
        }
        Date now = new Date();
        if (this.isSpecifyingFormat() && !Utils.isEmpty((CharSequence)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            filename = (String)filename + dt;
        } else {
            if (this.isDateInFilename()) {
                daf.applyPattern("yyyMMdd");
                String d = daf.format(now);
                filename = (String)filename + "_" + d;
            }
            if (this.isTimeInFilename()) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                filename = (String)filename + "_" + t;
            }
        }
        if (this.isTransformNrInFilename()) {
            filename = (String)filename + "_" + transformNr;
        }
        if (this.isPartNrInFilename()) {
            filename = (String)filename + "_" + partNr;
        }
        if (beamContext) {
            filename = (String)filename + "_" + transformId + "_" + bundleNr;
        }
        if (!extension.isEmpty()) {
            filename = (String)filename + "." + extension;
        }
        return filename;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (AvroOutputField outputField : this.outputFields) {
                int idx = prev.indexOfValue(outputField.getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + outputField.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transforminfo);
        remarks.add((ICheckResult)cr);
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.outputType.equalsIgnoreCase(OUTPUT_TYPES[1])) {
            ValueMetaBinary v = new ValueMetaBinary(variables.resolve(this.outputFieldName));
            v.setOrigin(origin);
            row.addValueMeta((IValueMeta)v);
        } else if (this.outputType.equalsIgnoreCase(OUTPUT_TYPES[2])) {
            ValueMetaString valueMetaInterface = new ValueMetaString(variables.resolve(this.outputFieldName));
            valueMetaInterface.setOrigin(origin);
            row.addValueMeta((IValueMeta)valueMetaInterface);
        }
    }
}

