/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.delegates;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;

public class HopGuiFileRefreshDelegate {
    private final HopGui hopGui;
    private DefaultFileMonitor fileMonitor;
    private Map<String, IHopFileTypeHandler> fileHandlerMap;
    private static final long DELAY = 1000L;

    public HopGuiFileRefreshDelegate(final HopGui hopGui) {
        this.hopGui = hopGui;
        this.fileHandlerMap = new HashMap<String, IHopFileTypeHandler>();
        this.fileMonitor = new DefaultFileMonitor(new FileListener(){

            public void fileChanged(FileChangeEvent arg0) throws Exception {
                IHopFileTypeHandler fileHandler;
                String fileName = arg0.getFileObject().getName().getURI();
                if (fileName != null && (fileHandler = HopGuiFileRefreshDelegate.this.fileHandlerMap.get(fileName)) != null && !hopGui.getDisplay().isDisposed()) {
                    hopGui.getDisplay().asyncExec(fileHandler::reload);
                }
            }

            public void fileCreated(FileChangeEvent arg0) throws Exception {
            }

            public void fileDeleted(FileChangeEvent arg0) throws Exception {
            }
        });
        this.fileMonitor.setDelay(1000L);
        this.fileMonitor.start();
    }

    public void register(String fileName, IHopFileTypeHandler fileTypeHandler) {
        if (!this.hopGui.getProps().isReloadingFilesOnChange()) {
            return;
        }
        try {
            FileObject file = HopVfs.getFileObject((String)fileName);
            this.fileMonitor.addFile(file);
            this.fileHandlerMap.put(file.getPublicURIString(), fileTypeHandler);
        }
        catch (HopFileException e) {
            this.hopGui.getLog().logError("Error registering new FileObject", (Throwable)e);
        }
        this.fileHandlerMap.put(fileName, fileTypeHandler);
    }

    public void remove(String fileName) {
        if (!this.hopGui.getProps().isReloadingFilesOnChange()) {
            return;
        }
        try {
            FileObject file = HopVfs.getFileObject((String)fileName);
            fileName = file.getPublicURIString();
            this.fileMonitor.removeFile(file);
        }
        catch (HopFileException e) {
            this.hopGui.getLog().logError("Error removing FileObject from fileListener", (Throwable)e);
        }
        finally {
            this.fileHandlerMap.remove(fileName);
        }
    }
}

