/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.Threads;

public enum DiskSpaceMonitor implements Runnable,
Closeable
{
    INSTANCE;

    public static final String DISK_SPACE_CHECKER_NAME = "disk~space~checker";
    static final boolean WARN_DELETED;
    private static final boolean DISABLED;
    final Map<String, FileStore> fileStoreCacheMap = new ConcurrentHashMap<String, FileStore>();
    final Map<FileStore, DiskAttributes> diskAttributesMap = new ConcurrentHashMap<FileStore, DiskAttributes>();
    final ScheduledExecutorService executor;
    private int thresholdPercentage;

    private DiskSpaceMonitor() {
        if (!Jvm.getBoolean((String)"chronicle.disk.monitor.disable")) {
            this.executor = Threads.acquireScheduledExecutorService(DISK_SPACE_CHECKER_NAME, true);
            this.executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
        } else {
            this.executor = null;
        }
    }

    public void clear() {
        this.fileStoreCacheMap.clear();
        this.diskAttributesMap.clear();
    }

    public void pollDiskSpace(File file) {
        if (DISABLED) {
            return;
        }
        long start = System.nanoTime();
        String absolutePath = file.getAbsolutePath();
        FileStore fs = this.fileStoreCacheMap.get(absolutePath);
        if (fs == null) {
            if (file.exists()) {
                Path path = Paths.get(absolutePath, new String[0]);
                try {
                    fs = Files.getFileStore(path);
                    this.fileStoreCacheMap.put(absolutePath, fs);
                }
                catch (IOException e) {
                    Jvm.warn().on(this.getClass(), "Error trying to obtain the FileStore for " + path, (Throwable)e);
                    return;
                }
            } else {
                return;
            }
        }
        DiskAttributes da = this.diskAttributesMap.computeIfAbsent(fs, DiskAttributes::new);
        da.polled = true;
        long tookUs = (System.nanoTime() - start) / 1000L;
        if (tookUs > 250L) {
            Jvm.perf().on(this.getClass(), "Took " + (double)tookUs / 1000.0 + " ms to pollDiskSpace for " + file.getPath());
        }
    }

    @Override
    public void run() {
        Iterator<DiskAttributes> iterator = this.diskAttributesMap.values().iterator();
        while (iterator.hasNext()) {
            DiskAttributes da = iterator.next();
            try {
                da.run();
            }
            catch (IOException e) {
                if (WARN_DELETED) {
                    Jvm.warn().on(this.getClass(), "Unable to get disk space for " + da.fileStore, (Throwable)e);
                }
                iterator.remove();
            }
        }
    }

    public int getThresholdPercentage() {
        return this.thresholdPercentage;
    }

    public void setThresholdPercentage(int thresholdPercentage) {
        this.thresholdPercentage = thresholdPercentage;
    }

    @Override
    public void close() {
        if (this.executor != null) {
            Threads.shutdown(this.executor);
        }
    }

    static {
        WARN_DELETED = Jvm.getBoolean((String)"disk.monitor.deleted.warning");
        DISABLED = Jvm.getBoolean((String)"chronicle.disk.monitor.disable");
    }

    static class DiskAttributes {
        volatile boolean polled;
        long timeNextCheckedMS;
        long totalSpace;
        private FileStore fileStore;

        DiskAttributes(FileStore fileStore) {
            this.fileStore = fileStore;
        }

        void run() throws IOException {
            long unallocatedBytes;
            long now = System.currentTimeMillis();
            if (this.timeNextCheckedMS > now || !this.polled) {
                return;
            }
            this.polled = false;
            long start = System.nanoTime();
            if (this.totalSpace <= 0L) {
                this.totalSpace = this.fileStore.getTotalSpace();
            }
            if ((unallocatedBytes = this.fileStore.getUnallocatedSpace()) < 0xC800000L) {
                Jvm.warn().on(this.getClass(), "your disk " + this.fileStore + " is almost full, warning: chronicle-queue may crash if it runs out of space.");
            } else if (unallocatedBytes < this.totalSpace * (long)INSTANCE.thresholdPercentage / 100L) {
                double diskSpaceFull = (double)((long)((double)(1000L * (this.totalSpace - unallocatedBytes) / this.totalSpace) + 0.999)) / 10.0;
                Jvm.warn().on(this.getClass(), "your disk " + this.fileStore + " is " + diskSpaceFull + "% full, warning: chronicle-queue may crash if it runs out of space.");
            } else {
                this.timeNextCheckedMS = now + (unallocatedBytes >> 20);
            }
            long time = System.nanoTime() - start;
            if (time > 1000000L) {
                Jvm.perf().on(this.getClass(), "Took " + (double)(time / 10000L) / 100.0 + " ms to check the disk space of " + this.fileStore);
            }
        }
    }
}

