/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.io.aws2.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.BucketingFunction;
import org.apache.beam.sdk.util.MovingFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Streams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Initialization is safe.")
class SqsUnboundedReader
extends UnboundedSource.UnboundedReader<SqsMessage> {
    private static final @UnknownKeyFor @NonNull @Initialized String RECEIPT_HANDLE_IS_INVALID = "ReceiptHandleIsInvalid";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SqsUnboundedReader.class);
    public static final @UnknownKeyFor @NonNull @Initialized int MAX_NUMBER_OF_MESSAGES = 10;
    private static final @UnknownKeyFor @NonNull @Initialized int BATCH_OPERATION_MAX_RETIRES = 5;
    private static final @UnknownKeyFor @NonNull @Initialized Duration PROCESSING_TIMEOUT = Duration.standardMinutes((long)2L);
    private static final @UnknownKeyFor @NonNull @Initialized int VISIBILITY_EXTENSION_PCT = 50;
    private static final @UnknownKeyFor @NonNull @Initialized int VISIBILITY_SAFETY_PCT = 20;
    private static final @UnknownKeyFor @NonNull @Initialized Duration VISIBILITY_TOO_LATE = Duration.standardSeconds((long)2L);
    private static final @UnknownKeyFor @NonNull @Initialized int DELETE_BATCH_SIZE = 10;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_IN_FLIGHT = 20000;
    private static final @UnknownKeyFor @NonNull @Initialized Duration SAMPLE_PERIOD = Duration.standardMinutes((long)1L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration SAMPLE_UPDATE = Duration.standardSeconds((long)5L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration LOG_PERIOD = Duration.standardSeconds((long)30L);
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_WATERMARK_MESSAGES = 10;
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_WATERMARK_SPREAD = 2;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn MIN = Min.ofLongs();
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn MAX = Max.ofLongs();
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn SUM = Sum.ofLongs();
    private final @UnknownKeyFor @NonNull @Initialized SqsUnboundedSource source;
    private final @UnknownKeyFor @NonNull @Initialized Clock clock;
    private final @UnknownKeyFor @NonNull @Initialized AwsOptions awsOptions;
    private @UnknownKeyFor @NonNull @Initialized AtomicBoolean active = new AtomicBoolean(true);
    private @UnknownKeyFor @NonNull @Initialized SqsClient sqsClient = null;
    private @UnknownKeyFor @NonNull @Initialized SqsMessage current;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized SqsMessage> messagesNotYetRead;
    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> safeToDeleteIds;
    private @UnknownKeyFor @NonNull @Initialized long visibilityTimeoutMs;
    private @UnknownKeyFor @NonNull @Initialized long notYetReadBytes;
    private @UnknownKeyFor @NonNull @Initialized BucketingFunction minUnreadTimestampMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction minReadTimestampMsSinceEpoch;
    private final @UnknownKeyFor @NonNull @Initialized LinkedHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized InFlightState> inFlight;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> deletedIds;
    private @UnknownKeyFor @NonNull @Initialized long lastReceivedMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized long lastWatermarkMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized long lastLogTimestampMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized long numReceived;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numReceivedRecently;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numExtendedDeadlines;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numLateDeadlines;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numDeleted;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numExpired;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numReleased;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numReadBytes;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction minReceivedTimestampMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction maxReceivedTimestampMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction minWatermarkMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction maxWatermarkMsSinceEpoch;
    private @UnknownKeyFor @NonNull @Initialized MovingFunction numLateMessages;
    @UnknownKeyFor @NonNull @Initialized AtomicInteger numInFlightCheckpoints;
    private @UnknownKeyFor @NonNull @Initialized int maxInFlightCheckpoints;

    private static @UnknownKeyFor @NonNull @Initialized MovingFunction newFun(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn function) {
        return new MovingFunction(SAMPLE_PERIOD.getMillis(), SAMPLE_UPDATE.getMillis(), 2, 10, function);
    }

    public SqsUnboundedReader(@UnknownKeyFor @NonNull @Initialized SqsUnboundedSource source, @UnknownKeyFor @NonNull @Initialized SqsCheckpointMark sqsCheckpointMark, @UnknownKeyFor @NonNull @Initialized AwsOptions awsOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(source, sqsCheckpointMark, awsOptions, Clock.systemUTC());
    }

    @VisibleForTesting
    SqsUnboundedReader(@UnknownKeyFor @NonNull @Initialized SqsUnboundedSource source, @UnknownKeyFor @NonNull @Initialized SqsCheckpointMark sqsCheckpointMark, @UnknownKeyFor @NonNull @Initialized AwsOptions awsOptions, @UnknownKeyFor @NonNull @Initialized Clock clock) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.source = source;
        this.clock = clock;
        this.awsOptions = awsOptions;
        this.messagesNotYetRead = new ArrayDeque<SqsMessage>(10);
        this.safeToDeleteIds = new HashSet<String>();
        this.inFlight = new LinkedHashMap();
        this.deletedIds = new ConcurrentLinkedQueue<List<String>>();
        this.visibilityTimeoutMs = -1L;
        this.notYetReadBytes = 0L;
        this.minUnreadTimestampMsSinceEpoch = new BucketingFunction(SAMPLE_UPDATE.getMillis(), 2, 10, MIN);
        this.minReadTimestampMsSinceEpoch = SqsUnboundedReader.newFun(MIN);
        this.lastReceivedMsSinceEpoch = -1L;
        this.lastWatermarkMsSinceEpoch = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.current = null;
        this.lastLogTimestampMsSinceEpoch = -1L;
        this.numReceived = 0L;
        this.numReceivedRecently = SqsUnboundedReader.newFun(SUM);
        this.numExtendedDeadlines = SqsUnboundedReader.newFun(SUM);
        this.numLateDeadlines = SqsUnboundedReader.newFun(SUM);
        this.numDeleted = SqsUnboundedReader.newFun(SUM);
        this.numExpired = SqsUnboundedReader.newFun(SUM);
        this.numReleased = SqsUnboundedReader.newFun(SUM);
        this.numReadBytes = SqsUnboundedReader.newFun(SUM);
        this.minReceivedTimestampMsSinceEpoch = SqsUnboundedReader.newFun(MIN);
        this.maxReceivedTimestampMsSinceEpoch = SqsUnboundedReader.newFun(MAX);
        this.minWatermarkMsSinceEpoch = SqsUnboundedReader.newFun(MIN);
        this.maxWatermarkMsSinceEpoch = SqsUnboundedReader.newFun(MAX);
        this.numLateMessages = SqsUnboundedReader.newFun(SUM);
        this.numInFlightCheckpoints = new AtomicInteger();
        this.maxInFlightCheckpoints = 0;
        if (sqsCheckpointMark != null) {
            this.initClient();
            this.expireBatchForRedelivery(sqsCheckpointMark.notYetReadReceipts);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        long nowMsSinceEpoch = this.now();
        long readMin = this.minReadTimestampMsSinceEpoch.get(nowMsSinceEpoch);
        long unreadMin = this.minUnreadTimestampMsSinceEpoch.get();
        if (readMin == Long.MAX_VALUE && unreadMin == Long.MAX_VALUE && this.lastReceivedMsSinceEpoch >= 0L && nowMsSinceEpoch > this.lastReceivedMsSinceEpoch + SAMPLE_PERIOD.getMillis()) {
            this.lastWatermarkMsSinceEpoch = nowMsSinceEpoch;
        } else if (this.minReadTimestampMsSinceEpoch.isSignificant() || this.minUnreadTimestampMsSinceEpoch.isSignificant()) {
            this.lastWatermarkMsSinceEpoch = Math.min(readMin, unreadMin);
        }
        this.minWatermarkMsSinceEpoch.add(nowMsSinceEpoch, this.lastWatermarkMsSinceEpoch);
        this.maxWatermarkMsSinceEpoch.add(nowMsSinceEpoch, this.lastWatermarkMsSinceEpoch);
        return new Instant(this.lastWatermarkMsSinceEpoch);
    }

    public @UnknownKeyFor @NonNull @Initialized SqsMessage getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return new Instant(this.current.getTimeStamp());
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrentRecordId() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current.getMessageId().getBytes(StandardCharsets.UTF_8);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
        int cur = this.numInFlightCheckpoints.incrementAndGet();
        this.maxInFlightCheckpoints = Math.max(this.maxInFlightCheckpoints, cur);
        return new SqsCheckpointMark(this, this.safeToDeleteIds, Collections2.transform(this.messagesNotYetRead, SqsMessage::getReceiptHandle));
    }

    public @UnknownKeyFor @NonNull @Initialized SqsUnboundedSource getCurrentSource() {
        return this.source;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.initClient();
        String timeout = (String)this.sqsClient.getQueueAttributes(b -> b.queueUrl(this.queueUrl()).attributeNames(new QueueAttributeName[]{QueueAttributeName.VISIBILITY_TIMEOUT})).attributes().get(QueueAttributeName.VISIBILITY_TIMEOUT);
        this.visibilityTimeoutMs = (long)Integer.parseInt(timeout) * 1000L;
        return this.advance();
    }

    private @UnknownKeyFor @NonNull @Initialized String queueUrl() {
        return this.source.getRead().queueUrl();
    }

    private void initClient() {
        if (this.sqsClient == null) {
            ClientConfiguration config = this.source.getRead().clientConfiguration();
            this.sqsClient = (SqsClient)ClientBuilderFactory.buildClient(this.awsOptions, SqsClient.builder(), config);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.stats();
        if (this.current != null) {
            this.minUnreadTimestampMsSinceEpoch.remove(this.current.getRequestTimeStamp());
            this.current = null;
        }
        this.retire();
        this.extend();
        if (this.messagesNotYetRead.isEmpty()) {
            this.pull();
        }
        this.current = this.messagesNotYetRead.poll();
        if (this.current == null) {
            return false;
        }
        int currentBytes = this.current.getBody().getBytes(StandardCharsets.UTF_8).length;
        this.notYetReadBytes -= (long)currentBytes;
        Preconditions.checkState((this.notYetReadBytes >= 0L ? 1 : 0) != 0);
        long nowMsSinceEpoch = this.now();
        this.numReadBytes.add(nowMsSinceEpoch, (long)currentBytes);
        this.minReadTimestampMsSinceEpoch.add(nowMsSinceEpoch, this.getCurrentTimestamp().getMillis());
        if (this.getCurrentTimestamp().getMillis() < this.lastWatermarkMsSinceEpoch) {
            this.numLateMessages.add(nowMsSinceEpoch, 1L);
        }
        this.safeToDeleteIds.add(this.current.getMessageId());
        return true;
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.active.set(false);
        this.maybeCloseClient();
    }

    void maybeCloseClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.active.get() && this.numInFlightCheckpoints.get() == 0 && this.sqsClient != null) {
            this.sqsClient.close();
        }
    }

    void delete(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> messageIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<String> receiptHandles = new ArrayList<String>(10);
        for (String msgId : messageIds) {
            InFlightState state = this.inFlight.get(msgId);
            if (state == null) continue;
            receiptHandles.add(state.receiptHandle);
            if (receiptHandles.size() != 10) continue;
            this.deleteBatch(receiptHandles);
            receiptHandles.clear();
        }
        if (!receiptHandles.isEmpty()) {
            this.deleteBatch(receiptHandles);
        }
        this.deletedIds.add(messageIds);
    }

    private void deleteBatch(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> receiptHandles) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int retries = 0;
        Streams.FunctionWithIndex buildEntry = (handle, id) -> (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(Long.toString(id)).receiptHandle(handle).build();
        Map pendingDeletes = Streams.mapWithIndex(receiptHandles.stream(), (Streams.FunctionWithIndex)buildEntry).collect(Collectors.toMap(e -> e.id(), Function.identity()));
        while (!pendingDeletes.isEmpty()) {
            if (retries >= 5) {
                throw new IOException("Failed to delete " + pendingDeletes.size() + " messages after " + retries + " retries");
            }
            DeleteMessageBatchResponse result = this.sqsClient.deleteMessageBatch((DeleteMessageBatchRequest)DeleteMessageBatchRequest.builder().queueUrl(this.queueUrl()).entries(pendingDeletes.values()).build());
            Map failures = result.failed().stream().collect(Collectors.partitioningBy(this::isHandleInvalid, Collectors.mapping(e -> e.id(), Collectors.toSet())));
            pendingDeletes.keySet().retainAll((Collection)failures.getOrDefault(Boolean.FALSE, ImmutableSet.of()));
            int invalidHandles = ((Set)failures.getOrDefault(Boolean.TRUE, ImmutableSet.of())).size();
            if (invalidHandles > 0) {
                LOG.warn("Failed to delete {} messages due to expired receipt handles.", (Object)invalidHandles);
            }
            ++retries;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isHandleInvalid(@UnknownKeyFor @NonNull @Initialized BatchResultErrorEntry error) {
        return RECEIPT_HANDLE_IS_INVALID.equals(error.code());
    }

    private void retire() {
        long nowMsSinceEpoch = this.now();
        List<String> ackIds;
        block0: while ((ackIds = this.deletedIds.poll()) != null) {
            this.numDeleted.add(nowMsSinceEpoch, (long)ackIds.size());
            Iterator<String> iterator = ackIds.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String ackId = iterator.next();
                this.inFlight.remove(ackId);
                this.safeToDeleteIds.remove(ackId);
            }
            break;
        }
        return;
    }

    private void pull() {
        if (this.inFlight.size() >= 20000) {
            return;
        }
        long requestTimeMsSinceEpoch = this.now();
        long deadlineMsSinceEpoch = requestTimeMsSinceEpoch + this.visibilityTimeoutMs;
        ReceiveMessageRequest receiveMessageRequest = (ReceiveMessageRequest)ReceiveMessageRequest.builder().maxNumberOfMessages(Integer.valueOf(10)).attributeNamesWithStrings(new String[]{MessageSystemAttributeName.SENT_TIMESTAMP.toString()}).queueUrl(this.queueUrl()).build();
        ReceiveMessageResponse receiveMessageResponse = this.sqsClient.receiveMessage(receiveMessageRequest);
        List messages = receiveMessageResponse.messages();
        if (messages == null || messages.isEmpty()) {
            return;
        }
        this.lastReceivedMsSinceEpoch = requestTimeMsSinceEpoch;
        for (Message orgMsg : messages) {
            long msgTimeStamp = Long.parseLong((String)orgMsg.attributes().get(MessageSystemAttributeName.SENT_TIMESTAMP));
            SqsMessage message = SqsMessage.create(orgMsg.body(), orgMsg.messageId(), orgMsg.receiptHandle(), msgTimeStamp, requestTimeMsSinceEpoch);
            this.messagesNotYetRead.add(message);
            this.notYetReadBytes += (long)message.getBody().getBytes(StandardCharsets.UTF_8).length;
            this.inFlight.put(message.getMessageId(), new InFlightState(message.getReceiptHandle(), requestTimeMsSinceEpoch, deadlineMsSinceEpoch));
            ++this.numReceived;
            this.numReceivedRecently.add(requestTimeMsSinceEpoch, 1L);
            this.minReceivedTimestampMsSinceEpoch.add(requestTimeMsSinceEpoch, msgTimeStamp);
            this.maxReceivedTimestampMsSinceEpoch.add(requestTimeMsSinceEpoch, msgTimeStamp);
            this.minUnreadTimestampMsSinceEpoch.add(requestTimeMsSinceEpoch, msgTimeStamp);
        }
    }

    @UnknownKeyFor @NonNull @Initialized long now() {
        return this.clock.millis();
    }

    private void extend() throws @UnknownKeyFor @NonNull @Initialized IOException {
        while (true) {
            long nowMsSinceEpoch = this.now();
            ArrayList<String> assumeExpired = new ArrayList<String>();
            ArrayList<String> toBeExtended = new ArrayList<String>();
            ArrayList<String> toBeExpired = new ArrayList<String>();
            for (Map.Entry<String, InFlightState> entry : this.inFlight.entrySet()) {
                if (entry.getValue().visibilityDeadlineMsSinceEpoch - this.visibilityTimeoutMs * 20L / 100L > nowMsSinceEpoch) break;
                if (entry.getValue().visibilityDeadlineMsSinceEpoch - VISIBILITY_TOO_LATE.getMillis() < nowMsSinceEpoch) {
                    assumeExpired.add(entry.getKey());
                    continue;
                }
                if (entry.getValue().requestTimeMsSinceEpoch + PROCESSING_TIMEOUT.getMillis() < nowMsSinceEpoch) {
                    toBeExpired.add(entry.getKey());
                    continue;
                }
                toBeExtended.add(entry.getKey());
                if (toBeExtended.size() < 10) continue;
                break;
            }
            if (assumeExpired.isEmpty() && toBeExtended.isEmpty() && toBeExpired.isEmpty()) {
                return;
            }
            if (!assumeExpired.isEmpty()) {
                this.numLateDeadlines.add(nowMsSinceEpoch, (long)assumeExpired.size());
                for (String messageId : assumeExpired) {
                    this.inFlight.remove(messageId);
                }
            }
            if (!toBeExpired.isEmpty()) {
                this.numExpired.add(nowMsSinceEpoch, (long)toBeExpired.size());
                for (String messageId : toBeExpired) {
                    this.inFlight.remove(messageId);
                }
            }
            if (toBeExtended.isEmpty()) continue;
            long extensionMs = (int)(this.visibilityTimeoutMs * 50L / 100L);
            long newDeadlineMsSinceEpoch = nowMsSinceEpoch + extensionMs;
            ArrayList<KV<String, String>> messages = new ArrayList<KV<String, String>>(toBeExtended.size());
            for (String messageId : toBeExtended) {
                InFlightState state = (InFlightState)this.inFlight.remove(messageId);
                state.visibilityDeadlineMsSinceEpoch = newDeadlineMsSinceEpoch;
                this.inFlight.put(messageId, state);
                messages.add((KV<String, String>)KV.of((Object)messageId, (Object)state.receiptHandle));
            }
            this.extendBatch(nowMsSinceEpoch, messages, (int)(extensionMs / 1000L));
        }
    }

    void expireBatchForRedelivery(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> receiptHandles) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<KV<String, String>> messages = Streams.mapWithIndex(receiptHandles.stream(), (handle, idx) -> KV.of((Object)Long.toString(idx), (Object)handle)).collect(Collectors.toList());
        long nowMsSinceEpoch = this.now();
        this.extendBatch(nowMsSinceEpoch, messages, 0);
        this.numReleased.add(nowMsSinceEpoch, (long)receiptHandles.size());
    }

    void extendBatch(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> messages, @UnknownKeyFor @NonNull @Initialized int extensionSec) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int retries = 0;
        Function<KV, ChangeMessageVisibilityBatchRequestEntry> buildEntry = kv -> (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().visibilityTimeout(Integer.valueOf(extensionSec)).id((String)kv.getKey()).receiptHandle((String)kv.getValue()).build();
        Map<String, ChangeMessageVisibilityBatchRequestEntry> pendingExtends = messages.stream().collect(Collectors.toMap(KV::getKey, buildEntry));
        while (!pendingExtends.isEmpty()) {
            if (retries >= 5) {
                throw new IOException("Failed to extend visibility timeout for " + messages.size() + " messages after " + retries + " retries");
            }
            ChangeMessageVisibilityBatchResponse response = this.sqsClient.changeMessageVisibilityBatch((ChangeMessageVisibilityBatchRequest)ChangeMessageVisibilityBatchRequest.builder().queueUrl(this.queueUrl()).entries(pendingExtends.values()).build());
            Map failures = response.failed().stream().collect(Collectors.partitioningBy(this::isHandleInvalid, Collectors.mapping(e -> e.id(), Collectors.toSet())));
            pendingExtends.keySet().retainAll((Collection)failures.getOrDefault(Boolean.FALSE, ImmutableSet.of()));
            if (extensionSec > 0) {
                this.numExtendedDeadlines.add(nowMsSinceEpoch, (long)response.successful().size());
                Set invalidMsgIds = (Set)failures.getOrDefault(Boolean.TRUE, ImmutableSet.of());
                if (invalidMsgIds.size() > 0) {
                    this.numLateDeadlines.add(nowMsSinceEpoch, (long)invalidMsgIds.size());
                    for (String msgId : invalidMsgIds) {
                        this.inFlight.remove(msgId);
                    }
                    LOG.warn("Failed to extend visibility timeout for {} messages with expired receipt handles.", (Object)invalidMsgIds.size());
                }
            }
            ++retries;
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized long getVisibilityTimeoutMs() {
        return this.visibilityTimeoutMs;
    }

    private void stats() {
        long nowMsSinceEpoch = this.now();
        if (this.lastLogTimestampMsSinceEpoch < 0L) {
            this.lastLogTimestampMsSinceEpoch = nowMsSinceEpoch;
            return;
        }
        long deltaMs = nowMsSinceEpoch - this.lastLogTimestampMsSinceEpoch;
        if (deltaMs < LOG_PERIOD.getMillis()) {
            return;
        }
        String messageSkew = "unknown";
        long minTimestamp = this.minReceivedTimestampMsSinceEpoch.get(nowMsSinceEpoch);
        long maxTimestamp = this.maxReceivedTimestampMsSinceEpoch.get(nowMsSinceEpoch);
        if (minTimestamp < Long.MAX_VALUE && maxTimestamp > Long.MIN_VALUE) {
            messageSkew = maxTimestamp - minTimestamp + "ms";
        }
        String watermarkSkew = "unknown";
        long minWatermark = this.minWatermarkMsSinceEpoch.get(nowMsSinceEpoch);
        long maxWatermark = this.maxWatermarkMsSinceEpoch.get(nowMsSinceEpoch);
        if (minWatermark < Long.MAX_VALUE && maxWatermark > Long.MIN_VALUE) {
            watermarkSkew = maxWatermark - minWatermark + "ms";
        }
        String oldestInFlight = "no";
        String oldestAckId = (String)Iterables.getFirst(this.inFlight.keySet(), null);
        if (oldestAckId != null) {
            oldestInFlight = nowMsSinceEpoch - this.inFlight.get((Object)oldestAckId).requestTimeMsSinceEpoch + "ms";
        }
        LOG.info("SQS {} has {} received messages, {} current unread messages, {} current unread bytes, {} current in-flight msgs, {} oldest in-flight, {} current in-flight checkpoints, {} max in-flight checkpoints, {}B/s recent read, {} recent received, {} recent extended, {} recent late extended, {} recent deleted, {} recent released, {} recent expired, {} recent message timestamp skew, {} recent watermark skew, {} recent late messages, {} last reported watermark, {} min recent read timestamp (significance = {}), {} min recent unread timestamp (significance = {}), {} last receive timestamp", new Object[]{this.queueUrl(), this.numReceived, this.messagesNotYetRead.size(), this.notYetReadBytes, this.inFlight.size(), oldestInFlight, this.numInFlightCheckpoints.get(), this.maxInFlightCheckpoints, this.numReadBytes.get(nowMsSinceEpoch) / (SAMPLE_PERIOD.getMillis() / 1000L), this.numReceivedRecently.get(nowMsSinceEpoch), this.numExtendedDeadlines.get(nowMsSinceEpoch), this.numLateDeadlines.get(nowMsSinceEpoch), this.numDeleted.get(nowMsSinceEpoch), this.numReleased.get(nowMsSinceEpoch), this.numExpired.get(nowMsSinceEpoch), messageSkew, watermarkSkew, this.numLateMessages.get(nowMsSinceEpoch), new Instant(this.lastWatermarkMsSinceEpoch), new Instant(this.minReadTimestampMsSinceEpoch.get(nowMsSinceEpoch)), this.minReadTimestampMsSinceEpoch.isSignificant(), new Instant(this.minUnreadTimestampMsSinceEpoch.get()), this.minUnreadTimestampMsSinceEpoch.isSignificant(), new Instant(this.lastReceivedMsSinceEpoch)});
        this.lastLogTimestampMsSinceEpoch = nowMsSinceEpoch;
    }

    private static class InFlightState {
        @UnknownKeyFor @NonNull @Initialized String receiptHandle;
        @UnknownKeyFor @NonNull @Initialized long requestTimeMsSinceEpoch;
        @UnknownKeyFor @NonNull @Initialized long visibilityDeadlineMsSinceEpoch;

        public InFlightState(@UnknownKeyFor @NonNull @Initialized String receiptHandle, @UnknownKeyFor @NonNull @Initialized long requestTimeMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized long visibilityDeadlineMsSinceEpoch) {
            this.receiptHandle = receiptHandle;
            this.requestTimeMsSinceEpoch = requestTimeMsSinceEpoch;
            this.visibilityDeadlineMsSinceEpoch = visibilityDeadlineMsSinceEpoch;
        }
    }
}

