/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamschemamerge;

import java.util.ArrayList;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.streamschemamerge.SchemaMapper;
import org.apache.hop.pipeline.transforms.streamschemamerge.StreamSchemaData;
import org.apache.hop.pipeline.transforms.streamschemamerge.StreamSchemaMeta;

public class StreamSchema
extends BaseTransform<StreamSchemaMeta, StreamSchemaData> {
    public StreamSchema(TransformMeta transformMeta, StreamSchemaMeta meta, StreamSchemaData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
        pipeline.setSafeModeEnabled(false);
    }

    public boolean init() {
        return super.init();
    }

    public boolean processRow() throws HopException {
        Object[] incomingRow;
        if (this.first) {
            this.first = false;
            ArrayList<String> tNames = new ArrayList<String>();
            ArrayList<IStream> streams = new ArrayList<IStream>();
            ArrayList<IRowMeta> rowMetas = new ArrayList<IRowMeta>();
            ((StreamSchemaData)this.data).rowSets = new ArrayList<IRowSet>();
            int inputStreamsNum = ((StreamSchemaMeta)this.meta).getTransformIOMeta().getInfoStreams().size();
            for (int i = 0; i < inputStreamsNum; ++i) {
                IStream s = (IStream)((StreamSchemaMeta)this.meta).getTransformIOMeta().getInfoStreams().get(i);
                IRowSet r = this.findInputRowSet(s.getTransformName());
                streams.add(s);
                tNames.add(r.getName());
                ((StreamSchemaData)this.data).rowSets.add(r);
                rowMetas.add(this.getPipelineMeta().getTransformFields((IVariables)this, s.getTransformName()));
            }
            ((StreamSchemaData)this.data).infoStreams = streams;
            ((StreamSchemaData)this.data).numTransforms = inputStreamsNum;
            ((StreamSchemaData)this.data).transformNames = tNames.toArray(new String[0]);
            ((StreamSchemaData)this.data).rowMetas = rowMetas.toArray(new IRowMeta[0]);
            ((StreamSchemaData)this.data).schemaMapping = new SchemaMapper(((StreamSchemaData)this.data).rowMetas);
            ((StreamSchemaData)this.data).mapping = ((StreamSchemaData)this.data).schemaMapping.getMapping();
            ((StreamSchemaData)this.data).outputRowMeta = ((StreamSchemaData)this.data).schemaMapping.getRowMeta();
            this.setInputRowSets(((StreamSchemaData)this.data).rowSets);
            if (this.isDetailed()) {
                this.logDetailed("Finished generating mapping");
            }
        }
        if ((incomingRow = this.getRow()) == null) {
            this.setOutputDone();
            return false;
        }
        ((StreamSchemaData)this.data).currentName = ((IRowSet)this.getInputRowSets().get(this.getCurrentInputRowSetNr())).getName();
        for (int i = 0; i < ((StreamSchemaData)this.data).transformNames.length; ++i) {
            if (!((StreamSchemaData)this.data).transformNames[i].equals(((StreamSchemaData)this.data).currentName)) continue;
            ((StreamSchemaData)this.data).streamNum = i;
            break;
        }
        if (this.isRowLevel()) {
            this.logRowlevel(String.format("Current row from %s. This maps to stream number %d", ((StreamSchemaData)this.data).currentName, ((StreamSchemaData)this.data).streamNum));
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)((StreamSchemaData)this.data).outputRowMeta.size());
        ((StreamSchemaData)this.data).rowMapping = ((StreamSchemaData)this.data).mapping[((StreamSchemaData)this.data).streamNum];
        ((StreamSchemaData)this.data).inRowMeta = ((StreamSchemaData)this.data).rowMetas[((StreamSchemaData)this.data).streamNum];
        for (int j = 0; j < ((StreamSchemaData)this.data).inRowMeta.size(); ++j) {
            int newPos = ((StreamSchemaData)this.data).rowMapping[j];
            outputRow[newPos] = incomingRow[j];
        }
        this.putRow(((StreamSchemaData)this.data).outputRowMeta, outputRow);
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    public void dispose() {
        ((StreamSchemaData)this.data).outputRowMeta = null;
        ((StreamSchemaData)this.data).inRowMeta = null;
        ((StreamSchemaData)this.data).schemaMapping = null;
        ((StreamSchemaData)this.data).infoStreams = null;
        ((StreamSchemaData)this.data).rowSets = null;
        ((StreamSchemaData)this.data).rowMetas = null;
        ((StreamSchemaData)this.data).mapping = null;
        ((StreamSchemaData)this.data).currentName = null;
        ((StreamSchemaData)this.data).rowMapping = null;
        ((StreamSchemaData)this.data).transformNames = null;
        super.dispose();
    }
}

