/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.HMSCatalogAdapter;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSCatalogServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HMSCatalogServlet.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private final HMSCatalogAdapter restCatalogAdapter;
    private final Map<String, String> responseHeaders = ImmutableMap.of((Object)"Content-Type", (Object)"application/json");

    public HMSCatalogServlet(HMSCatalogAdapter restCatalogAdapter) {
        this.restCatalogAdapter = restCatalogAdapter;
    }

    public String getServletName() {
        return "Iceberg REST Catalog";
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        try {
            ServletRequestContext context = ServletRequestContext.from(request);
            response.setStatus(200);
            this.responseHeaders.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            Optional<ErrorResponse> error = context.error();
            if (error.isPresent()) {
                response.setStatus(400);
                RESTObjectMapper.mapper().writeValue((Writer)response.getWriter(), (Object)error.get());
                return;
            }
            Object responseBody = this.restCatalogAdapter.execute(context.method(), context.path(), context.queryParams(), context.body(), this.handle(response));
            if (responseBody != null) {
                RESTObjectMapper.mapper().writeValue((Writer)response.getWriter(), responseBody);
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error processing REST request", (Throwable)e);
            response.setStatus(500);
        }
    }

    private Consumer<ErrorResponse> handle(HttpServletResponse response) {
        return errorResponse -> {
            response.setStatus(errorResponse.code().intValue());
            try {
                RESTObjectMapper.mapper().writeValue((Writer)response.getWriter(), errorResponse);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static class ServletRequestContext {
        private HTTPRequest.HTTPMethod method;
        private String path;
        private Map<String, String> queryParams;
        private Object body;
        private ErrorResponse errorResponse;

        private ServletRequestContext(ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
        }

        private ServletRequestContext(HTTPRequest.HTTPMethod method, String path, Map<String, String> queryParams, Object body) {
            this.method = method;
            this.path = path;
            this.queryParams = queryParams;
            this.body = body;
        }

        static ServletRequestContext from(HttpServletRequest request) throws IOException {
            Pair<HMSCatalogAdapter.Route, Map<String, String>> routeContext;
            HTTPRequest.HTTPMethod method = HTTPRequest.HTTPMethod.valueOf((String)request.getMethod());
            String path = request.getPathInfo();
            if (path == null) {
                path = request.getRequestURI().substring(request.getContextPath().length() + request.getServletPath().length());
            }
            if ((routeContext = HMSCatalogAdapter.Route.from(method, path = path.substring(1))) == null) {
                return new ServletRequestContext(ErrorResponse.builder().responseCode(Integer.valueOf(400)).withType("BadRequestException").withMessage(String.format("No route for request: %s %s", method, path)).build());
            }
            HMSCatalogAdapter.Route route = (HMSCatalogAdapter.Route)((Object)routeContext.first());
            Object requestBody = null;
            if (route.requestClass() != null) {
                requestBody = RESTObjectMapper.mapper().readValue((Reader)request.getReader(), route.requestClass());
            }
            Map<String, String> queryParams = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String[])e.getValue())[0]));
            return new ServletRequestContext(method, path, queryParams, requestBody);
        }

        HTTPRequest.HTTPMethod method() {
            return this.method;
        }

        public String path() {
            return this.path;
        }

        public Map<String, String> queryParams() {
            return this.queryParams;
        }

        public Object body() {
            return this.body;
        }

        public Optional<ErrorResponse> error() {
            return Optional.ofNullable(this.errorResponse);
        }
    }
}

