/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorDirectNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class GetIteratorDirectNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getNextMethodNode;
    @Node.Child
    private IsCallableNode isCallableNode = IsCallableNode.create();

    public GetIteratorDirectNode(JSContext context) {
        this.getNextMethodNode = PropertyGetNode.create(Strings.NEXT, context);
    }

    public abstract IteratorRecord execute(Object var1);

    @Specialization
    protected IteratorRecord get(JSObject obj, @Cached InlinedBranchProfile errorBranch) {
        Object nextMethod = this.getNextMethodNode.getValue((Object)obj);
        if (!this.isCallableNode.executeBoolean(nextMethod)) {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorCallableExpected();
        }
        return IteratorRecord.create(obj, nextMethod, false);
    }

    @Specialization(guards={"!isJSObject(obj)"})
    public IteratorRecord unsupported(Object obj) {
        throw Errors.createTypeErrorNotAnObject(obj, this);
    }

    public static GetIteratorDirectNode create(JSContext context) {
        return GetIteratorDirectNodeGen.create(context);
    }
}

