/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcFileKeyWrapper;
import org.apache.hadoop.hive.ql.io.orc.OrcFileValueWrapper;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;

public class OrcFileStripeMergeRecordReader
implements RecordReader<OrcFileKeyWrapper, OrcFileValueWrapper> {
    private final Reader reader;
    private final Path path;
    protected Iterator<StripeInformation> iter;
    protected List<OrcProto.StripeStatistics> stripeStatistics;
    private int stripeIdx;
    private boolean skipFile;

    public OrcFileStripeMergeRecordReader(Configuration conf, FileSplit split) throws IOException {
        this.path = split.getPath();
        long start = split.getStart();
        boolean bl = this.skipFile = start > 0L;
        if (!this.skipFile) {
            FileSystem fs = this.path.getFileSystem(conf);
            this.reader = OrcFile.createReader(this.path, OrcFile.readerOptions(conf).filesystem(fs));
            this.iter = this.reader.getStripes().iterator();
            this.stripeIdx = 0;
            this.stripeStatistics = ((ReaderImpl)this.reader).getOrcProtoStripeStatistics();
        } else {
            this.reader = null;
        }
    }

    public Class<?> getKeyClass() {
        return OrcFileKeyWrapper.class;
    }

    public Class<?> getValueClass() {
        return OrcFileValueWrapper.class;
    }

    public OrcFileKeyWrapper createKey() {
        return new OrcFileKeyWrapper();
    }

    public OrcFileValueWrapper createValue() {
        return new OrcFileValueWrapper();
    }

    public boolean next(OrcFileKeyWrapper key, OrcFileValueWrapper value) throws IOException {
        if (this.skipFile) {
            return false;
        }
        return this.nextStripe(key, value);
    }

    protected boolean nextStripe(OrcFileKeyWrapper keyWrapper, OrcFileValueWrapper valueWrapper) throws IOException {
        if ((this.stripeStatistics == null || this.stripeStatistics.isEmpty()) && this.reader.getNumberOfRows() > 0L) {
            keyWrapper.setInputPath(this.path);
            keyWrapper.setIsIncompatFile(true);
            this.skipFile = true;
            return true;
        }
        if (this.iter.hasNext()) {
            StripeInformation si = this.iter.next();
            valueWrapper.setStripeStatistics(this.stripeStatistics.get(this.stripeIdx));
            valueWrapper.setStripeInformation(si);
            if (!this.iter.hasNext()) {
                valueWrapper.setLastStripeInFile(true);
                HashMap<String, ByteBuffer> userMeta = new HashMap<String, ByteBuffer>();
                for (String key : this.reader.getMetadataKeys()) {
                    userMeta.put(key, this.reader.getMetadataValue(key));
                }
                valueWrapper.setUserMetadata(userMeta);
            }
            keyWrapper.setInputPath(this.path);
            keyWrapper.setCompression(this.reader.getCompressionKind());
            keyWrapper.setCompressBufferSize(this.reader.getCompressionSize());
            keyWrapper.setFileVersion(this.reader.getFileVersion());
            keyWrapper.setWriterVersion(this.reader.getWriterVersion());
            keyWrapper.setRowIndexStride(this.reader.getRowIndexStride());
            keyWrapper.setFileSchema(this.reader.getSchema());
            ++this.stripeIdx;
            return true;
        }
        return false;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public long getPos() throws IOException {
        return 0L;
    }

    protected void seek(long pos) throws IOException {
    }

    public long getStart() {
        return 0L;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

