/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.tools.StoragePolicyAdmin;
import org.apache.hadoop.util.Tool;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestStoragePolicyCommands {
    private static final short REPL = 1;
    private static final int SIZE = 128;
    protected static Configuration conf;
    protected static MiniDFSCluster cluster;
    protected static FileSystem fs;

    @Before
    public void clusterSetUp() throws IOException, URISyntaxException {
        conf = new HdfsConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.DISK}};
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).storageTypes(newtypes).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    @After
    public void clusterShutdown() throws IOException {
        if (fs != null) {
            fs.close();
            fs = null;
        }
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testSetAndUnsetStoragePolicy() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path wow = new Path(bar, "wow");
        DFSTestUtil.createFile(fs, wow, 128L, (short)1, 0L);
        StoragePolicyAdmin admin = new StoragePolicyAdmin(conf);
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path " + fs.getUri() + "/foo -policy WARM", 0, "Set storage policy WARM on " + fs.getUri() + "/foo");
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /foo/bar -policy COLD", 0, "Set storage policy COLD on " + bar.toString());
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /foo/bar/wow -policy HOT", 0, "Set storage policy HOT on " + wow.toString());
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /fooz -policy WARM", 2, "File/Directory does not exist: /fooz");
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        BlockStoragePolicy cold = suite.getPolicy("COLD");
        BlockStoragePolicy hot = suite.getPolicy("HOT");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path " + fs.getUri() + "/foo", 0, "The storage policy of " + fs.getUri() + "/foo:\n" + warm);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo/bar", 0, "The storage policy of " + bar.toString() + ":\n" + cold);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo/bar/wow", 0, "The storage policy of " + wow.toString() + ":\n" + hot);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /fooz", 2, "File/Directory does not exist: /fooz");
        DFSTestUtil.toolRun((Tool)admin, "-unsetStoragePolicy -path " + fs.getUri() + "/foo", 0, "Unset storage policy from " + fs.getUri() + "/foo");
        DFSTestUtil.toolRun((Tool)admin, "-unsetStoragePolicy -path /foo/bar", 0, "Unset storage policy from " + bar.toString());
        DFSTestUtil.toolRun((Tool)admin, "-unsetStoragePolicy -path /foo/bar/wow", 0, "Unset storage policy from " + wow.toString());
        DFSTestUtil.toolRun((Tool)admin, "-unsetStoragePolicy -path /fooz", 2, "File/Directory does not exist: /fooz");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo", 0, "The storage policy of " + foo.toString() + " is unspecified");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo/bar", 0, "The storage policy of " + bar.toString() + " is unspecified");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo/bar/wow", 0, "The storage policy of " + wow.toString() + " is unspecified");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /fooz", 2, "File/Directory does not exist: /fooz");
    }

    @Test
    public void testSetAndGetStoragePolicy() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile(fs, bar, 128L, (short)1, 0L);
        StoragePolicyAdmin admin = new StoragePolicyAdmin(conf);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo", 0, "The storage policy of " + foo.toString() + " is unspecified");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo/bar", 0, "The storage policy of " + bar.toString() + " is unspecified");
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /foo -policy WARM", 0, "Set storage policy WARM on " + foo.toString());
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /foo/bar -policy COLD", 0, "Set storage policy COLD on " + bar.toString());
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /fooz -policy WARM", 2, "File/Directory does not exist: /fooz");
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        BlockStoragePolicy cold = suite.getPolicy("COLD");
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo", 0, "The storage policy of " + foo.toString() + ":\n" + warm);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /foo/bar", 0, "The storage policy of " + bar.toString() + ":\n" + cold);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /fooz", 2, "File/Directory does not exist: /fooz");
    }
}

