/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.sls.AMDefinition;

public class JobDefinition {
    private AMDefinition amDefinition;
    private ReservationId reservationId;
    private long deadline;
    private Map<String, String> params;

    public AMDefinition getAmDefinition() {
        return this.amDefinition;
    }

    public ReservationId getReservationId() {
        return this.reservationId;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public static final class Builder {
        private AMDefinition amDefinition;
        private ReservationId reservationId;
        private long deadline;
        private Map<String, String> params;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withAmDefinition(AMDefinition amDefinition) {
            this.amDefinition = amDefinition;
            return this;
        }

        public Builder withReservationId(ReservationId reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public Builder withDeadline(long deadline) {
            this.deadline = deadline;
            return this;
        }

        public Builder withParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public JobDefinition build() {
            JobDefinition jobDef = new JobDefinition();
            jobDef.params = this.params;
            jobDef.amDefinition = this.amDefinition;
            jobDef.reservationId = this.reservationId;
            jobDef.deadline = this.deadline;
            return jobDef;
        }
    }
}

