/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationRegistryClient {
    private static final Logger LOG = LoggerFactory.getLogger(FederationRegistryClient.class);
    private RegistryOperations registry;
    private UserGroupInformation user;
    private Map<ApplicationId, Map<String, Token<AMRMTokenIdentifier>>> appSubClusterTokenMap;
    private String registryBaseDir;

    public FederationRegistryClient(Configuration conf, RegistryOperations registry, UserGroupInformation user) {
        this.registry = registry;
        this.user = user;
        this.appSubClusterTokenMap = new ConcurrentHashMap<ApplicationId, Map<String, Token<AMRMTokenIdentifier>>>();
        this.registryBaseDir = conf.get("yarn.federation.registry.base-dir", "yarnfederation/");
        LOG.info("Using registry {} with base directory: {}", (Object)this.registry.getClass().getName(), (Object)this.registryBaseDir);
    }

    public synchronized List<String> getAllApplications() {
        List<String> applications = null;
        try {
            applications = this.listDirRegistry(this.registry, this.user, this.getRegistryKey(null, null), false);
        }
        catch (YarnException e) {
            LOG.warn("Unexpected exception from listDirRegistry", (Throwable)e);
        }
        if (applications == null) {
            return new ArrayList<String>();
        }
        return applications;
    }

    @VisibleForTesting
    public synchronized void cleanAllApplications() {
        try {
            this.removeKeyRegistry(this.registry, this.user, this.getRegistryKey(null, null), true, false);
        }
        catch (YarnException e) {
            LOG.warn("Unexpected exception from removeKeyRegistry", (Throwable)e);
        }
    }

    public synchronized boolean writeAMRMTokenForUAM(ApplicationId appId, String subClusterId, Token<AMRMTokenIdentifier> token) {
        boolean update;
        Map<String, Token<AMRMTokenIdentifier>> subClusterTokenMap = this.appSubClusterTokenMap.get(appId);
        if (subClusterTokenMap == null) {
            subClusterTokenMap = new ConcurrentHashMap<String, Token<AMRMTokenIdentifier>>();
            this.appSubClusterTokenMap.put(appId, subClusterTokenMap);
        }
        boolean bl = update = !token.equals(subClusterTokenMap.get(subClusterId));
        if (!update) {
            LOG.debug("Same amrmToken received from {}, skip writing registry for {}", (Object)subClusterId, (Object)appId);
            return update;
        }
        LOG.info("Writing/Updating amrmToken for {} to registry for {}", (Object)subClusterId, (Object)appId);
        try {
            this.writeRegistry(this.registry, this.user, this.getRegistryKey(appId, subClusterId), token.encodeToUrlString(), true);
            subClusterTokenMap.put(subClusterId, token);
        }
        catch (IOException | YarnException e) {
            LOG.error("Failed writing AMRMToken to registry for subcluster {}.", (Object)subClusterId, (Object)e);
        }
        return update;
    }

    public synchronized Map<String, Token<AMRMTokenIdentifier>> loadStateFromRegistry(ApplicationId appId) {
        HashMap<String, Token<AMRMTokenIdentifier>> retMap = new HashMap<String, Token<AMRMTokenIdentifier>>();
        List<String> subclusters = null;
        try {
            subclusters = this.listDirRegistry(this.registry, this.user, this.getRegistryKey(appId, null), false);
        }
        catch (YarnException e) {
            LOG.warn("Unexpected exception from listDirRegistry", (Throwable)e);
        }
        if (subclusters == null) {
            LOG.info("Application {} does not exist in registry", (Object)appId);
            return retMap;
        }
        for (String scId : subclusters) {
            LOG.info("Reading amrmToken for subcluster {} for {}", (Object)scId, (Object)appId);
            String key = this.getRegistryKey(appId, scId);
            try {
                String tokenString = this.readRegistry(this.registry, this.user, key, true);
                if (tokenString == null) {
                    throw new YarnException("Null string from readRegistry key " + key);
                }
                Token amrmToken = new Token();
                amrmToken.decodeFromUrlString(tokenString);
                amrmToken.setService(new Text());
                retMap.put(scId, (Token<AMRMTokenIdentifier>)amrmToken);
            }
            catch (Exception e) {
                LOG.error("Failed reading registry key {}, skipping subcluster {}.", new Object[]{key, scId, e});
            }
        }
        this.appSubClusterTokenMap.put(appId, new ConcurrentHashMap<String, Token<AMRMTokenIdentifier>>(retMap));
        return retMap;
    }

    public synchronized void removeAppFromRegistry(ApplicationId appId) {
        this.removeAppFromRegistry(appId, false);
    }

    public synchronized void removeAppFromRegistry(ApplicationId appId, boolean ignoreMemoryState) {
        Map<String, Token<AMRMTokenIdentifier>> subClusterTokenMap = this.appSubClusterTokenMap.get(appId);
        if (!ignoreMemoryState && MapUtils.isEmpty(subClusterTokenMap)) {
            return;
        }
        LOG.info("Removing all registry entries for {}.", (Object)appId);
        String key = this.getRegistryKey(appId, null);
        try {
            this.removeKeyRegistry(this.registry, this.user, key, true, true);
            if (subClusterTokenMap != null) {
                subClusterTokenMap.clear();
            }
        }
        catch (YarnException e) {
            LOG.error("Failed removing registry directory key {}.", (Object)key, (Object)e);
        }
    }

    private String getRegistryKey(ApplicationId appId, String fileName) {
        if (appId == null) {
            return this.registryBaseDir;
        }
        if (fileName == null) {
            return this.registryBaseDir + appId.toString();
        }
        return this.registryBaseDir + appId.toString() + "/" + fileName;
    }

    private String readRegistry(final RegistryOperations registryImpl, UserGroupInformation ugi, final String key, final boolean throwIfFails) throws YarnException {
        String result = (String)ugi.doAs((PrivilegedAction)new PrivilegedAction<String>(){

            @Override
            public String run() {
                block3: {
                    try {
                        ServiceRecord value = registryImpl.resolve(key);
                        if (value != null) {
                            return value.description;
                        }
                    }
                    catch (Throwable e) {
                        if (!throwIfFails) break block3;
                        LOG.error("Registry resolve key {} failed.", (Object)key, (Object)e);
                    }
                }
                return null;
            }
        });
        if (result == null && throwIfFails) {
            throw new YarnException("Registry resolve key " + key + " failed");
        }
        return result;
    }

    private void removeKeyRegistry(final RegistryOperations registryImpl, UserGroupInformation ugi, final String key, final boolean recursive, final boolean throwIfFails) throws YarnException {
        boolean success = (Boolean)ugi.doAs((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    registryImpl.delete(key, recursive);
                    return true;
                }
                catch (Throwable e) {
                    if (throwIfFails) {
                        LOG.error("Registry remove key {} failed.", (Object)key, (Object)e);
                    }
                    return false;
                }
            }
        });
        if (!success && throwIfFails) {
            throw new YarnException("Registry remove key " + key + " failed");
        }
    }

    private void writeRegistry(final RegistryOperations registryImpl, UserGroupInformation ugi, final String key, String value, final boolean throwIfFails) throws YarnException {
        final ServiceRecord recordValue = new ServiceRecord();
        recordValue.description = value;
        boolean success = (Boolean)ugi.doAs((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    registryImpl.bind(key, recordValue, 1);
                    return true;
                }
                catch (Throwable e) {
                    if (throwIfFails) {
                        LOG.error("Registry write key {} failed.", (Object)key, (Object)e);
                    }
                    return false;
                }
            }
        });
        if (!success && throwIfFails) {
            throw new YarnException("Registry write key " + key + " failed");
        }
    }

    private List<String> listDirRegistry(RegistryOperations registryImpl, UserGroupInformation ugi, String key, boolean throwIfFails) throws YarnException {
        List result = (List)ugi.doAs(() -> {
            try {
                return registryImpl.list(key);
            }
            catch (Throwable e) {
                if (throwIfFails) {
                    LOG.error("Registry list key {} failed.", (Object)key, (Object)e);
                }
                return null;
            }
        });
        if (result == null && throwIfFails) {
            throw new YarnException("Registry list key " + key + " failed");
        }
        return result;
    }
}

