/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMethod {
    private static final Logger LOG = LoggerFactory.getLogger(ClientMethod.class);
    private final Object[] params;
    private final Class<?>[] types;
    private final String methodName;

    public ClientMethod(String method, Class<?>[] pTypes, Object ... pParams) throws IOException {
        if (pParams.length != pTypes.length) {
            throw new IOException("Invalid parameters for method " + method);
        }
        this.params = pParams;
        this.types = Arrays.copyOf(pTypes, pTypes.length);
        this.methodName = method;
    }

    public Object[] getParams() {
        return Arrays.copyOf(this.params, this.params.length);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getTypes() {
        return Arrays.copyOf(this.types, this.types.length);
    }
}

