/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.translator.api.LogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogParserUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogParserUtil.class);
    private LogParser logParser;
    private DateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public void setLogParser(LogParser logParser) {
        this.logParser = logParser;
    }

    public void setDateFormat(String datePattern) {
        this.format = new SimpleDateFormat(datePattern);
    }

    public long stringToUnixTimestamp(String date) throws ParseException {
        return this.format.parse(date).getTime();
    }

    public final void parseLog(String logFile) throws SkylineStoreException, IOException, ResourceEstimatorException {
        if (this.logParser == null) {
            throw new ResourceEstimatorException("The log parser is not initialized, please try again after initializing.");
        }
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(logFile);
            this.logParser.parseStream(inputStream);
        }
    }
}

