/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.VerificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertedConfigValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertedConfigValidator.class);

    public void validateConvertedConfig(String outputDir) throws Exception {
        QueueMetrics.clearQueueMetrics();
        Path configPath = new Path(outputDir, "capacity-scheduler.xml");
        CapacitySchedulerConfiguration csConfig = new CapacitySchedulerConfiguration(new Configuration(false), false);
        csConfig.addResource(configPath);
        Path convertedSiteConfigPath = new Path(outputDir, "yarn-site.xml");
        YarnConfiguration siteConf = new YarnConfiguration(new Configuration(false));
        siteConf.addResource(convertedSiteConfigPath);
        RMContextImpl rmContext = new RMContextImpl();
        siteConf.set("yarn.resourcemanager.configuration.file-system-based-store", outputDir);
        FileSystemBasedConfigurationProvider provider = new FileSystemBasedConfigurationProvider();
        provider.init((Configuration)siteConf);
        rmContext.setConfigurationProvider((ConfigurationProvider)provider);
        RMNodeLabelsManager mgr = new RMNodeLabelsManager();
        mgr.init((Configuration)siteConf);
        rmContext.setNodeLabelManager(mgr);
        try (CapacityScheduler cs = new CapacityScheduler();){
            cs.setConf((Configuration)siteConf);
            cs.setRMContext(rmContext);
            cs.serviceInit(csConfig);
            cs.serviceStart();
            LOG.info("Capacity scheduler was successfully started");
            cs.serviceStop();
        }
        catch (Exception e) {
            LOG.error("Could not start Capacity Scheduler", (Throwable)e);
            throw new VerificationException("Verification of converted configuration failed", e);
        }
    }
}

