/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.Rule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSConfigToCSConfigRuleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FSConfigToCSConfigRuleHandler.class);
    private ConversionOptions conversionOptions;
    public static final String MAX_CHILD_QUEUE_LIMIT = "maxChildQueue.limit";
    public static final String MAX_CAPACITY_PERCENTAGE = "maxCapacityPercentage.action";
    public static final String MAX_CHILD_CAPACITY = "maxChildCapacity.action";
    public static final String MAX_RESOURCES = "maxResources.action";
    public static final String MIN_RESOURCES = "minResources.action";
    public static final String DYNAMIC_MAX_ASSIGN = "dynamicMaxAssign.action";
    public static final String RESERVATION_SYSTEM = "reservationSystem.action";
    public static final String QUEUE_AUTO_CREATE = "queueAutoCreate.action";
    public static final String FAIR_AS_DRF = "fairAsDrf.action";
    public static final String QUEUE_DYNAMIC_CREATE = "queueDynamicCreate.action";
    public static final String PARENT_DYNAMIC_CREATE = "parentDynamicCreate.action";
    public static final String CHILD_STATIC_DYNAMIC_CONFLICT = "childStaticDynamicConflict.action";
    public static final String PARENT_CHILD_CREATE_DIFFERS = "parentChildCreateDiff.action";
    private Map<String, RuleAction> actions;
    private Properties properties;

    void loadRulesFromFile(String ruleFile) throws IOException {
        if (ruleFile == null) {
            throw new IllegalArgumentException("Rule file cannot be null!");
        }
        this.properties = new Properties();
        try (FileInputStream is = new FileInputStream(new File(ruleFile));){
            this.properties.load(is);
        }
        this.actions = new HashMap<String, RuleAction>();
    }

    public FSConfigToCSConfigRuleHandler(ConversionOptions conversionOptions) {
        this.properties = new Properties();
        this.actions = new HashMap<String, RuleAction>();
        this.conversionOptions = conversionOptions;
    }

    @VisibleForTesting
    FSConfigToCSConfigRuleHandler(Properties props, ConversionOptions conversionOptions) {
        this.properties = props;
        this.actions = new HashMap<String, RuleAction>();
        this.conversionOptions = conversionOptions;
        this.initPropertyActions();
    }

    public void initPropertyActions() {
        this.setActionForProperty(MAX_CAPACITY_PERCENTAGE);
        this.setActionForProperty(MAX_CHILD_CAPACITY);
        this.setActionForProperty(MAX_RESOURCES);
        this.setActionForProperty(MIN_RESOURCES);
        this.setActionForProperty(DYNAMIC_MAX_ASSIGN);
        this.setActionForProperty(RESERVATION_SYSTEM);
        this.setActionForProperty(QUEUE_AUTO_CREATE);
        this.setActionForProperty(FAIR_AS_DRF);
        this.setActionForProperty(QUEUE_DYNAMIC_CREATE);
        this.setActionForProperty(PARENT_DYNAMIC_CREATE);
        this.setActionForProperty(CHILD_STATIC_DYNAMIC_CONFLICT);
        this.setActionForProperty(PARENT_CHILD_CREATE_DIFFERS);
    }

    public void handleMaxCapacityPercentage(String queueName) {
        this.handle(MAX_CAPACITY_PERCENTAGE, null, String.format("<maxResources> defined in percentages for queue %s", queueName));
    }

    public void handleMaxChildCapacity() {
        this.handle(MAX_CHILD_CAPACITY, "<maxChildResources>", null);
    }

    public void handleMaxResources() {
        this.handle(MAX_RESOURCES, "<maxResources>", null);
    }

    public void handleMinResources() {
        this.handle(MIN_RESOURCES, "<minResources>", null);
    }

    public void handleChildQueueCount(String queue, int count) {
        String value = this.properties.getProperty(MAX_CHILD_QUEUE_LIMIT);
        if (value != null) {
            if (StringUtils.isNumeric((CharSequence)value)) {
                int maxChildQueue = Integer.parseInt(value);
                if (count > maxChildQueue) {
                    throw new ConversionException(String.format("Queue %s has too many children: %d", queue, count));
                }
            } else {
                throw new ConversionException("Rule setting: maxChildQueue.limit is not an integer");
            }
        }
    }

    public void handleDynamicMaxAssign() {
        this.handle(DYNAMIC_MAX_ASSIGN, "yarn.scheduler.fair.dynamic.max.assign", null);
    }

    public void handleReservationSystem() {
        this.handle(RESERVATION_SYSTEM, null, "Conversion of reservation system is not supported");
    }

    public void handleFairAsDrf(String queueName) {
        this.handle(FAIR_AS_DRF, null, String.format("Queue %s will use DRF policy instead of Fair", queueName));
    }

    public void handleRuleAutoCreateFlag(String queue) {
        String msg = String.format("Placement rules: create=true is enabled for path %s - you have to make sure that these queues are managed queues and set auto-create-child-queues=true. Other queues cannot statically exist under this path!", queue);
        this.handle(QUEUE_DYNAMIC_CREATE, null, msg);
    }

    public void handleFSParentCreateFlag(String parentPath) {
        String msg = String.format("Placement rules: create=true is enabled for parent path %s - this is not supported in Capacity Scheduler. The parent must exist as a static queue and cannot be created automatically", parentPath);
        this.handle(PARENT_DYNAMIC_CREATE, null, msg);
    }

    public void handleChildStaticDynamicConflict(String parentPath) {
        String msg = String.format("Placement rules: rule maps to path %s, but this queue already contains static queue definitions! This configuration is invalid and *must* be corrected", parentPath);
        this.handle(CHILD_STATIC_DYNAMIC_CONFLICT, null, msg);
    }

    public void handleFSParentAndChildCreateFlagDiff(Rule.Policy policy) {
        String msg = String.format("Placement rules: the policy %s originally uses true/false or false/true \"create\" settings on the Fair Scheduler side. This is not supported and create flag will be set to *true* in the generated JSON rule chain", policy.name());
        this.handle(PARENT_CHILD_CREATE_DIFFERS, null, msg);
    }

    private void handle(String actionName, String fsSetting, String message) {
        RuleAction action = this.actions.get(actionName);
        if (action != null) {
            switch (action) {
                case ABORT: {
                    String exceptionMessage = message != null ? message : String.format("Setting %s is not supported", fsSetting);
                    this.conversionOptions.handleError(exceptionMessage);
                    break;
                }
                case WARNING: {
                    String loggedMsg = message != null ? message : String.format("Setting %s is not supported, ignoring conversion", fsSetting);
                    this.conversionOptions.handleWarning(loggedMsg, LOG);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown action " + (Object)((Object)action));
                }
            }
        }
    }

    private void setActionForProperty(String property) {
        String action = this.properties.getProperty(property);
        if (action == null) {
            LOG.info("No rule set for {}, defaulting to WARNING", (Object)property);
            this.actions.put(property, RuleAction.WARNING);
        } else if (action.equalsIgnoreCase("warning")) {
            this.actions.put(property, RuleAction.WARNING);
        } else if (action.equalsIgnoreCase("abort")) {
            this.actions.put(property, RuleAction.ABORT);
        } else {
            LOG.warn("Unknown action {} set for rule {}, defaulting to WARNING", (Object)action, (Object)property);
            this.actions.put(property, RuleAction.WARNING);
        }
    }

    @VisibleForTesting
    public Map<String, RuleAction> getActions() {
        return this.actions;
    }

    @VisibleForTesting
    static enum RuleAction {
        WARNING,
        ABORT;

    }
}

