/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential.config;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.connector.PropertyEntry;

public class CredentialConfig
extends Config {
    private static final long DEFAULT_CREDENTIAL_CACHE_MAX_SIZE = 10000L;
    private static final double DEFAULT_CREDENTIAL_CACHE_EXPIRE_RATIO = 0.15;
    public static final Map<String, PropertyEntry<?>> CREDENTIAL_PROPERTY_ENTRIES = new ImmutableMap.Builder().put((Object)"credential-providers", PropertyEntry.stringPropertyEntry("credential-providers", "Credential providers for the Gravitino catalog, schema, fileset, table, etc.", false, false, null, false, false)).put((Object)"credential-cache-expire-ratio", PropertyEntry.doublePropertyEntry("credential-cache-expire-ratio", "Ratio of the credential's expiration time when Gravitino remove credential from the cache.", false, false, 0.15, false, false)).put((Object)"credential-cache-max-size", PropertyEntry.longPropertyEntry("credential-cache-max-size", "Max size for the credential cache.", false, false, 10000L, false, false)).build();
    public static final ConfigEntry<List<String>> CREDENTIAL_PROVIDERS = new ConfigBuilder("credential-providers").doc("Credential providers, separated by comma.").version("0.8.0").stringConf().toSequence().createWithDefault(Collections.emptyList());
    public static final ConfigEntry<Double> CREDENTIAL_CACHE_EXPIRE_RATIO = new ConfigBuilder("credential-cache-expire-ratio").doc("Ratio of the credential's expiration time when Gravitino remove credential from the cache.").version("0.8.0").doubleConf().checkValue(ratio -> ratio >= 0.0 && ratio < 1.0, "Ratio of the credential's expiration time should greater than or equal to 0 and less than 1.").createWithDefault((Object)0.15);
    public static final ConfigEntry<Long> CREDENTIAL_CACHE_MAX_SIZE = new ConfigBuilder("credential-cache-max-size").doc("Max cache size for the credential.").version("0.8.0").longConf().createWithDefault((Object)10000L);

    public CredentialConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }
}

