/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import flash.swf.Action;
import flash.swf.ActionHandler;
import java.util.Arrays;

public class ActionList
extends ActionHandler {
    public static final int sactionLabel = 256;
    public static final int sactionLineRecord = 257;
    public static final int sactionRegisterRecord = 258;
    private int[] offsets;
    private Action[] actions;
    private int size;

    public ActionList() {
        this(false);
    }

    public ActionList(int n) {
        this(false, n);
    }

    public ActionList(boolean bl) {
        this(bl, 10);
    }

    public ActionList(boolean bl, int n) {
        if (bl) {
            this.offsets = new int[n];
        }
        this.actions = new Action[n];
        this.size = 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ActionList) {
            ActionList actionList = (ActionList)object;
            if (Arrays.equals(actionList.actions, this.actions)) {
                bl = true;
            }
        }
        return bl;
    }

    public void visitAll(ActionHandler actionHandler) {
        this.visit(actionHandler, 0, this.size - 1);
    }

    public void visit(ActionHandler actionHandler, int n, int n2) {
        n2 = n2 < 0 ? this.size - 1 : n2;
        for (int i = n; i <= n2; ++i) {
            Action action = this.actions[i];
            if (action.code != 256 && action.code != 257) {
                if (this.offsets != null) {
                    actionHandler.setActionOffset(this.offsets[i], action);
                } else {
                    actionHandler.setActionOffset(i, action);
                }
            }
            action.visit(actionHandler);
        }
    }

    @Override
    public void setActionOffset(int n, Action action) {
        this.insert(n, action);
    }

    public void grow(int n) {
        Object[] objectArray;
        if (this.offsets != null) {
            objectArray = new int[n];
            System.arraycopy(this.offsets, 0, objectArray, 0, this.size);
            this.offsets = objectArray;
        }
        objectArray = new Action[n];
        System.arraycopy(this.actions, 0, objectArray, 0, this.size);
        this.actions = (Action[])objectArray;
    }

    public int size() {
        return this.size;
    }

    public Action getAction(int n) {
        return this.actions[n];
    }

    public int getOffset(int n) {
        return this.offsets[n];
    }

    public void remove(int n) {
        if (this.offsets != null) {
            System.arraycopy(this.offsets, n + 1, this.offsets, n, this.size - n - 1);
        }
        System.arraycopy(this.actions, n + 1, this.actions, n, this.size - n - 1);
        --this.size;
    }

    private int find(int n) {
        if (this.offsets != null) {
            int n2 = 0;
            int n3 = this.size - 1;
            while (n2 <= n3) {
                int n4 = (n2 + n3) / 2;
                int n5 = this.offsets[n4];
                if (n > n5) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n < n5) {
                    n3 = n4 - 1;
                    continue;
                }
                return n4;
            }
            return -(n2 + 1);
        }
        return n;
    }

    public void insert(int n, Action action) {
        int n2;
        if (this.size == this.actions.length) {
            this.grow(this.size * 2);
        }
        if (this.size == 0 || this.offsets == null && n == this.size || this.offsets != null && n > this.offsets[this.size - 1]) {
            n2 = this.size;
        } else {
            n2 = this.find(n);
            if (n2 < 0) {
                n2 = -n2 - 1;
            } else if (action.code < 256) {
                while (n2 < this.size && this.offsets[n2] == n) {
                    ++n2;
                }
            }
            if (this.offsets != null) {
                System.arraycopy(this.offsets, n2, this.offsets, n2 + 1, this.size - n2);
            }
            System.arraycopy(this.actions, n2, this.actions, n2 + 1, this.size - n2);
        }
        if (this.offsets != null) {
            this.offsets[n2] = n;
        }
        this.actions[n2] = action;
        ++this.size;
    }

    public void append(Action action) {
        int n = this.size;
        if (n == this.actions.length) {
            this.grow(this.size * 2);
        }
        this.actions[n] = action;
        this.size = n + 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ActionList: count = " + this.actions.length);
        stringBuilder.append(", actions = ");
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.actions[i]);
        }
        return stringBuilder.toString();
    }

    public int indexOf(int n, int n2) {
        int n3 = -1;
        for (int i = n2; n3 < 0 && i < this.actions.length; ++i) {
            Action action = this.getAction(i);
            if (action == null || action.code != n) continue;
            n3 = i;
        }
        return n3;
    }

    public int lastIndexOf(int n, int n2) {
        int n3 = -1;
        for (int i = n2; n3 < 0 && i >= 0; --i) {
            Action action = this.getAction(i);
            if (action == null || action.code != n) continue;
            n3 = i;
        }
        return n3;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.actions.length - 1);
    }

    public void setAction(int n, Action action) {
        this.actions[n] = action;
    }
}

