/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.utils;

import com.google.javascript.jscomp.CommandLineRunner;
import java.security.Permission;

public class JSClosureCompilerUtil {
    public static void run(String[] options) {
        JSClosureCompilerUtil.forbidSystemExitCall();
        try {
            JSClosureCommandLineRunner.main(options);
        }
        catch (ExitTrappedException exitTrappedException) {
        }
        finally {
            JSClosureCompilerUtil.enableSystemExitCall();
        }
    }

    private static void forbidSystemExitCall() {
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
            }

            @Override
            public void checkExit(int status) {
                throw new ExitTrappedException();
            }
        };
        System.setSecurityManager(securityManager);
    }

    private static void enableSystemExitCall() {
        System.setSecurityManager(null);
    }

    private static class ExitTrappedException
    extends SecurityException {
        private static final long serialVersionUID = 666L;

        private ExitTrappedException() {
        }
    }

    private static class JSClosureCommandLineRunner
    extends CommandLineRunner {
        JSClosureCommandLineRunner(String[] args) {
            super(args);
        }

        public static void main(String[] args) {
            JSClosureCommandLineRunner runner = new JSClosureCommandLineRunner(args);
            if (runner.shouldRunCompiler()) {
                runner.run();
            } else {
                System.exit(-1);
            }
        }
    }
}

