/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.tools;

import flash.swf.Action;
import flash.swf.ActionHandler;
import flash.swf.actions.Branch;
import flash.swf.actions.ConstantPool;
import flash.swf.actions.DefineFunction;
import flash.swf.actions.GetURL;
import flash.swf.actions.GetURL2;
import flash.swf.actions.GotoFrame;
import flash.swf.actions.GotoFrame2;
import flash.swf.actions.GotoLabel;
import flash.swf.actions.Label;
import flash.swf.actions.Push;
import flash.swf.actions.SetTarget;
import flash.swf.actions.StoreRegister;
import flash.swf.actions.StrictMode;
import flash.swf.actions.Try;
import flash.swf.actions.Unknown;
import flash.swf.actions.WaitForFrame;
import flash.swf.actions.With;
import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.ActionList;
import flash.util.FieldFormat;
import java.io.PrintWriter;
import java.util.HashMap;

public class Disassembler
extends ActionHandler {
    protected ConstantPool cpool;
    protected int start;
    protected int offset;
    protected final PrintWriter out;
    private boolean showOffset = false;
    private boolean showDebugSource = false;
    private boolean showLineRecord = true;
    private RegisterRecord registerRecord = null;
    private int indent;
    private int initialIndent;
    private String comment;
    private String format;
    private LabelMap labels = new LabelMap();
    int labelCount = 0;
    public static final String[] actionNames = new String[]{"0x00", "0x01", "0x02", "0x03", "next", "prev", "play", "stop", "toggle", "stopsound", "add", "sub", "mul", "div", "eq", "lt", "and", "or", "not", "seq", "slen", "substr", "0x16", "pop", "toint", "0x19", "0x1A", "0x1B", "get", "set", "0x1E", "0x1F", "settarget2", "sadd", "getprop", "setprop", "csprite", "rsprite", "trace", "sdrag", "edrag", "slt", "0x2A", "0x2B", "0x2C", "0x2D", "0x2E", "0x2F", "rand", "wslen", "c2a", "a2c", "time", "wsubstr", "wc2a", "wa2c", "0x38", "0x39", "del", "del2", "var", "callfun", "return", "mod", "newobj", "var2", "initarr", "initobj", "typeof", "target", "enum", "add2", "lt2", "eq2", "tonum", "tostr", "dup", "swap", "getmem", "setmem", "inc", "dec", "callmethod", "newmethod", "instanceof", "enum2", "0x56", "0x57", "0x58", "0x59", "0x5A", "0x5B", "0x5C", "0x5D", "0x5E", "halt", "band", "bor", "bxor", "bls", "brs", "burs", "eqs", "gt", "sgt", "extends", "0x6A", "0x6B", "0x6C", "0x6D", "0x6E", "0x6F", "0x70", "0x71", "0x72", "0x73", "0x74", "0x75", "0x76", "nop", "0x78", "0x79", "0x7A", "0x7B", "0x7C", "0x7D", "0x7E", "0x7F", "0x80", "gotoframe", "0x82", "geturl", "0x84", "0x85", "0x86", "store", "cpool", "strict", "wait", "settarget", "gotolabel", "wait2", "function2", "try", "0x90", "0x91", "0x92", "0x93", "with", "0x95", "push", "0x97", "0x98", "jump", "geturl2", "function", "0x9C", "if", "call", "gotof2", "0xA0", "0xA1", "0xA2", "0xA3", "0xA4", "0xA5", "0xA6", "0xA7", "0xA8", "0xA9", "quicktime", "0xAB", "0xAC", "0xAD", "0xAE", "0xAF", "0xB0", "0xB1", "0xB2", "0xB3", "0xB4", "0xB5", "0xB6", "0xB7", "0xB8", "0xB9", "0xBA", "0xBB", "0xBC", "0xBD", "0xBE", "0xBF", "0xC0", "0xC1", "0xC2", "0xC3", "0xC4", "0xC5", "0xC6", "0xC7", "0xC8", "0xC9", "0xCA", "0xCB", "0xCC", "0xCD", "0xCE", "0xCF", "0xD0", "0xD1", "0xD2", "0xD3", "0xD4", "0xD5", "0xD6", "0xD7", "0xD8", "0xD9", "0xDA", "0xDB", "0xDC", "0xDD", "0xDE", "0xDF", "0xE0", "0xE1", "0xE2", "0xE3", "0xE4", "0xE5", "0xE6", "0xE7", "0xE8", "0xE9", "0xEA", "0xEB", "0xEC", "0xED", "0xEE", "0xEF", "0xF0", "0xF1", "0xF2", "0xF3", "0xF4", "0xF5", "0xF6", "0xF7", "0xF8", "0xF9", "0xFA", "0xFB", "0xFC", "0xFD", "0xFE", "0xFF", "label", "line"};

    public Disassembler(PrintWriter printWriter, ConstantPool constantPool, String string) {
        this(printWriter, false, 0);
        this.cpool = constantPool;
        this.comment = string;
    }

    public Disassembler(PrintWriter printWriter, boolean bl, int n) {
        this.out = printWriter;
        this.showOffset = bl;
        this.indent = n;
        this.initialIndent = n;
        this.comment = "";
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setShowDebugSource(boolean bl) {
        this.showDebugSource = bl;
    }

    public void setShowLineRecord(boolean bl) {
        this.showLineRecord = bl;
    }

    public static void disassemble(ActionList actionList, ConstantPool constantPool, int n, int n2, PrintWriter printWriter) {
        Disassembler disassembler = new Disassembler(printWriter, constantPool, "    ");
        disassembler.setFormat("    0x%08O  %a");
        disassembler.setShowLineRecord(false);
        int n3 = actionList.lastIndexOf(258, n);
        if (n3 > -1) {
            disassembler.registerRecord = (RegisterRecord)actionList.getAction(n3);
        }
        actionList.visit(disassembler, n, n2);
        printWriter.flush();
    }

    protected void print(Action action) {
        this.start(action);
        this.out.println();
    }

    @Override
    public void setActionOffset(int n, Action action) {
        if (this.offset == 0) {
            this.start = n;
        }
        this.offset = n;
    }

    protected void indent() {
        int n;
        for (n = 0; n < this.initialIndent; ++n) {
            this.out.print("  ");
        }
        this.out.print(this.comment);
        for (n = this.initialIndent; n < this.indent; ++n) {
            this.out.print("  ");
        }
    }

    @Override
    public void registerRecord(RegisterRecord registerRecord) {
        this.registerRecord = registerRecord;
    }

    protected String variableNameForRegister(int n) {
        int n2;
        int n3 = n2 = this.registerRecord == null ? -1 : this.registerRecord.indexOf(n);
        if (n2 > -1) {
            return this.registerRecord.variableNames[n2];
        }
        return null;
    }

    @Override
    public void lineRecord(LineRecord lineRecord) {
        if (this.showLineRecord) {
            if (this.showDebugSource) {
                this.printLines(lineRecord, this.out);
            } else {
                this.start(lineRecord);
                this.out.println(" " + lineRecord.module.name + ":" + lineRecord.lineno);
            }
        }
    }

    public void printLines(LineRecord lineRecord, PrintWriter printWriter) {
        int n;
        DebugModule debugModule = lineRecord.module;
        if (debugModule != null && (n = lineRecord.lineno) > 0) {
            while (n - 1 > 0 && debugModule.offsets[n - 1] == 0) {
                --n;
            }
            if (n == 1) {
                this.indent();
                printWriter.println(debugModule.name);
            }
            int n2 = debugModule.index[n - 1];
            int n3 = debugModule.index[lineRecord.lineno] - n2;
            printWriter.write(debugModule.text, n2, n3);
        }
    }

    protected void start(Action action) {
        String string = action.code < 0 || action.code > actionNames.length ? "Unknown" : actionNames[action.code];
        if (this.showOffset) {
            this.indent();
            this.out.print("absolute=" + this.offset + ",relative=" + (this.offset - this.start) + ",code=" + action.code + "\t" + string);
        } else if (this.format == null) {
            this.indent();
            this.out.print(string);
        } else {
            this.startFormatted(string);
        }
    }

    protected void startFormatted(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < this.format.length(); ++i) {
            char c = this.format.charAt(i);
            if (c == '%') {
                if (Character.isDigit(c = this.format.charAt(++i))) {
                    if (c == '0') {
                        bl = true;
                        c = this.format.charAt(++i);
                    }
                    StringBuilder stringBuilder2 = new StringBuilder();
                    while (Character.isDigit(c)) {
                        stringBuilder2.append(c);
                        c = this.format.charAt(++i);
                    }
                    try {
                        n = Integer.parseInt(stringBuilder2.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = -1;
                    }
                }
                if (c == 'O') {
                    FieldFormat.formatLongToHex(stringBuilder, this.offset, n, bl);
                    continue;
                }
                if (c == 'o') {
                    FieldFormat.formatLong(stringBuilder, this.offset, n, bl);
                    continue;
                }
                if (c != 'a') continue;
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(c);
        }
        this.out.print(stringBuilder.toString());
    }

    @Override
    public void nextFrame(Action action) {
        this.print(action);
    }

    @Override
    public void prevFrame(Action action) {
        this.print(action);
    }

    @Override
    public void play(Action action) {
        this.print(action);
    }

    @Override
    public void stop(Action action) {
        this.print(action);
    }

    @Override
    public void toggleQuality(Action action) {
        this.print(action);
    }

    @Override
    public void stopSounds(Action action) {
        this.print(action);
    }

    @Override
    public void add(Action action) {
        this.print(action);
    }

    @Override
    public void subtract(Action action) {
        this.print(action);
    }

    @Override
    public void multiply(Action action) {
        this.print(action);
    }

    @Override
    public void divide(Action action) {
        this.print(action);
    }

    @Override
    public void equals(Action action) {
        this.print(action);
    }

    @Override
    public void less(Action action) {
        this.print(action);
    }

    @Override
    public void and(Action action) {
        this.print(action);
    }

    @Override
    public void or(Action action) {
        this.print(action);
    }

    @Override
    public void not(Action action) {
        this.print(action);
    }

    @Override
    public void stringEquals(Action action) {
        this.print(action);
    }

    @Override
    public void stringLength(Action action) {
        this.print(action);
    }

    @Override
    public void stringExtract(Action action) {
        this.print(action);
    }

    @Override
    public void pop(Action action) {
        this.print(action);
    }

    @Override
    public void toInteger(Action action) {
        this.print(action);
    }

    @Override
    public void getVariable(Action action) {
        this.print(action);
    }

    @Override
    public void setVariable(Action action) {
        this.print(action);
    }

    @Override
    public void setTarget2(Action action) {
        this.print(action);
    }

    @Override
    public void stringAdd(Action action) {
        this.print(action);
    }

    @Override
    public void getProperty(Action action) {
        this.print(action);
    }

    @Override
    public void setProperty(Action action) {
        this.print(action);
    }

    @Override
    public void cloneSprite(Action action) {
        this.print(action);
    }

    @Override
    public void removeSprite(Action action) {
        this.print(action);
    }

    @Override
    public void trace(Action action) {
        this.print(action);
    }

    @Override
    public void startDrag(Action action) {
        this.print(action);
    }

    @Override
    public void endDrag(Action action) {
        this.print(action);
    }

    @Override
    public void stringLess(Action action) {
        this.print(action);
    }

    @Override
    public void randomNumber(Action action) {
        this.print(action);
    }

    @Override
    public void mbStringLength(Action action) {
        this.print(action);
    }

    @Override
    public void charToASCII(Action action) {
        this.print(action);
    }

    @Override
    public void asciiToChar(Action action) {
        this.print(action);
    }

    @Override
    public void getTime(Action action) {
        this.print(action);
    }

    @Override
    public void mbStringExtract(Action action) {
        this.print(action);
    }

    @Override
    public void mbCharToASCII(Action action) {
        this.print(action);
    }

    @Override
    public void mbASCIIToChar(Action action) {
        this.print(action);
    }

    @Override
    public void delete(Action action) {
        this.print(action);
    }

    @Override
    public void delete2(Action action) {
        this.print(action);
    }

    @Override
    public void defineLocal(Action action) {
        this.print(action);
    }

    @Override
    public void callFunction(Action action) {
        this.print(action);
    }

    @Override
    public void returnAction(Action action) {
        this.print(action);
    }

    @Override
    public void modulo(Action action) {
        this.print(action);
    }

    @Override
    public void newObject(Action action) {
        this.print(action);
    }

    @Override
    public void defineLocal2(Action action) {
        this.print(action);
    }

    @Override
    public void initArray(Action action) {
        this.print(action);
    }

    @Override
    public void initObject(Action action) {
        this.print(action);
    }

    @Override
    public void typeOf(Action action) {
        this.print(action);
    }

    @Override
    public void targetPath(Action action) {
        this.print(action);
    }

    @Override
    public void enumerate(Action action) {
        this.print(action);
    }

    @Override
    public void add2(Action action) {
        this.print(action);
    }

    @Override
    public void less2(Action action) {
        this.print(action);
    }

    @Override
    public void equals2(Action action) {
        this.print(action);
    }

    @Override
    public void toNumber(Action action) {
        this.print(action);
    }

    @Override
    public void toString(Action action) {
        this.print(action);
    }

    @Override
    public void pushDuplicate(Action action) {
        this.print(action);
    }

    @Override
    public void stackSwap(Action action) {
        this.print(action);
    }

    @Override
    public void getMember(Action action) {
        this.print(action);
    }

    @Override
    public void setMember(Action action) {
        this.print(action);
    }

    @Override
    public void increment(Action action) {
        this.print(action);
    }

    @Override
    public void decrement(Action action) {
        this.print(action);
    }

    @Override
    public void callMethod(Action action) {
        this.print(action);
    }

    @Override
    public void newMethod(Action action) {
        this.print(action);
    }

    @Override
    public void instanceOf(Action action) {
        this.print(action);
    }

    @Override
    public void enumerate2(Action action) {
        this.print(action);
    }

    @Override
    public void bitAnd(Action action) {
        this.print(action);
    }

    @Override
    public void bitOr(Action action) {
        this.print(action);
    }

    @Override
    public void bitXor(Action action) {
        this.print(action);
    }

    @Override
    public void bitLShift(Action action) {
        this.print(action);
    }

    @Override
    public void bitRShift(Action action) {
        this.print(action);
    }

    @Override
    public void bitURShift(Action action) {
        this.print(action);
    }

    @Override
    public void strictEquals(Action action) {
        this.print(action);
    }

    @Override
    public void greater(Action action) {
        this.print(action);
    }

    @Override
    public void stringGreater(Action action) {
        this.print(action);
    }

    @Override
    public void gotoFrame(GotoFrame gotoFrame) {
        this.start(gotoFrame);
        this.out.println(" " + gotoFrame.frame);
    }

    @Override
    public void getURL(GetURL getURL) {
        this.start(getURL);
        this.out.println(" " + getURL.url + " " + getURL.target);
    }

    @Override
    public void storeRegister(StoreRegister storeRegister) {
        this.start(storeRegister);
        String string = this.variableNameForRegister(storeRegister.register);
        this.out.println(" $" + storeRegister.register + (string == null ? "" : "   \t\t; " + string));
    }

    @Override
    public void constantPool(ConstantPool constantPool) {
        this.cpool = constantPool;
        this.start(constantPool);
        this.out.println(" [" + constantPool.pool.length + "]");
    }

    @Override
    public void strictMode(StrictMode strictMode) {
        this.print(strictMode);
    }

    @Override
    public void waitForFrame(WaitForFrame waitForFrame) {
        this.start(waitForFrame);
        this.out.println(" " + waitForFrame.frame + " {");
        ++this.indent;
        this.labels.getLabelEntry((Label)waitForFrame.skipTarget).source = waitForFrame;
    }

    @Override
    public void setTarget(SetTarget setTarget) {
        this.start(setTarget);
        this.out.println(" " + setTarget.targetName);
    }

    @Override
    public void gotoLabel(GotoLabel gotoLabel) {
        this.start(gotoLabel);
        this.out.println(" " + gotoLabel.label);
    }

    @Override
    public void waitForFrame2(WaitForFrame waitForFrame) {
        this.start(waitForFrame);
        this.out.println(" {");
        ++this.indent;
        this.labels.getLabelEntry((Label)waitForFrame.skipTarget).source = waitForFrame;
    }

    @Override
    public void with(With with) {
        this.start(with);
        this.out.println(" {");
        ++this.indent;
        this.labels.getLabelEntry((Label)with.endWith).source = with;
    }

    @Override
    public void tryAction(Try try_) {
        this.start(try_);
        this.out.println(" {");
        ++this.indent;
        this.labels.getLabelEntry((Label)try_.endTry).source = try_;
        if (try_.hasCatch()) {
            this.labels.getLabelEntry((Label)try_.endCatch).source = try_;
        }
        if (try_.hasFinally()) {
            this.labels.getLabelEntry((Label)try_.endFinally).source = try_;
        }
    }

    @Override
    public void throwAction(Action action) {
        this.print(action);
    }

    @Override
    public void castOp(Action action) {
        this.print(action);
    }

    @Override
    public void implementsOp(Action action) {
        this.print(action);
    }

    @Override
    public void extendsOp(Action action) {
        this.print(action);
    }

    @Override
    public void nop(Action action) {
        this.print(action);
    }

    @Override
    public void halt(Action action) {
        this.print(action);
    }

    @Override
    public void push(Push push) {
        this.start(push);
        this.out.print(" ");
        Object object = push.value;
        int n = Push.getTypeCode(object);
        switch (n) {
            case 0: {
                this.out.print(Disassembler.quoteString(object.toString(), '\"'));
                break;
            }
            case 2: {
                this.out.print("null");
                break;
            }
            case 3: {
                this.out.print("undefined");
                break;
            }
            case 4: {
                String string = this.variableNameForRegister(((Byte)object).intValue() & 0xFF);
                this.out.print("$" + (((Byte)object).intValue() & 0xFF) + (string == null ? "" : "   \t\t; " + string));
                break;
            }
            case 8: 
            case 9: {
                int n2 = ((Number)object).intValue() & 0xFFFF;
                this.out.print(this.cpool == null ? Integer.toString(n2) : Disassembler.quoteString(this.cpool.pool[n2], '\''));
                break;
            }
            case 1: {
                this.out.print(object + "F");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.out.print(object);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.out.println();
    }

    @Override
    public void getURL2(GetURL2 getURL2) {
        this.start(getURL2);
        this.out.println(" " + getURL2.method);
    }

    @Override
    public void defineFunction(DefineFunction defineFunction) {
        this.start(defineFunction);
        this.out.print(" " + defineFunction.name + "(");
        for (int i = 0; i < defineFunction.params.length; ++i) {
            this.out.print(defineFunction.params[i]);
            if (i + 1 >= defineFunction.params.length) continue;
            this.out.print(", ");
        }
        this.out.println(") {");
        ++this.indent;
        defineFunction.actionList.visitAll(this);
        --this.indent;
        this.indent();
        this.out.println("} " + defineFunction.name);
    }

    @Override
    public void defineFunction2(DefineFunction defineFunction) {
        int n;
        this.start(defineFunction);
        this.out.print(" " + defineFunction.name + "(");
        for (n = 0; n < defineFunction.params.length; ++n) {
            this.out.print("$" + defineFunction.paramReg[n] + "=" + defineFunction.params[n]);
            if (n + 1 >= defineFunction.params.length) continue;
            this.out.print(", ");
        }
        this.out.print(")");
        n = 1;
        if ((defineFunction.flags & 1) != 0) {
            this.out.print(" $" + n++ + "=this");
        }
        if ((defineFunction.flags & 4) != 0) {
            this.out.print(" $" + n++ + "=arguments");
        }
        if ((defineFunction.flags & 0x10) != 0) {
            this.out.print(" $" + n++ + "=super");
        }
        if ((defineFunction.flags & 0x40) != 0) {
            this.out.print(" $" + n++ + "=_root");
        }
        if ((defineFunction.flags & 0x80) != 0) {
            this.out.print(" $" + n++ + "=_parent");
        }
        if ((defineFunction.flags & 0x100) != 0) {
            this.out.print(" $" + n + "=_global");
        }
        this.out.println(" {");
        ++this.indent;
        defineFunction.actionList.visitAll(this);
        --this.indent;
        this.indent();
        this.out.println("} " + defineFunction.name);
    }

    @Override
    public void ifAction(Branch branch) {
        this.printBranch(branch);
    }

    @Override
    public void jump(Branch branch) {
        this.printBranch(branch);
    }

    protected void printBranch(Branch branch) {
        this.start(branch);
        LabelEntry labelEntry = this.labels.getLabelEntry(branch.target);
        if (labelEntry.name == null) {
            labelEntry.name = "L" + String.valueOf(this.labelCount++);
        }
        labelEntry.source = branch;
        this.out.println(" " + labelEntry.name);
    }

    @Override
    public void label(Label label) {
        LabelEntry labelEntry = this.labels.getLabelEntry(label);
        if (labelEntry.source == null) {
            labelEntry.name = "L" + String.valueOf(this.labelCount++);
            this.indent();
            this.out.println(labelEntry.name + ":");
        } else {
            switch (labelEntry.source.code) {
                case 143: {
                    Try try_ = (Try)labelEntry.source;
                    --this.indent;
                    this.indent();
                    this.out.println("}");
                    this.indent();
                    if (label == try_.endTry && try_.hasCatch()) {
                        this.out.println("catch(" + (try_.hasRegister() ? "$" + try_.catchReg : try_.catchName) + ") {");
                        ++this.indent;
                        break;
                    }
                    if (label != try_.endTry && label != try_.endCatch || !try_.hasFinally()) break;
                    this.out.println("finally {");
                    ++this.indent;
                    break;
                }
                case 138: 
                case 141: 
                case 148: {
                    --this.indent;
                    this.indent();
                    this.out.println("}");
                    break;
                }
                case 153: 
                case 157: {
                    this.indent();
                    this.out.println(labelEntry.name + ":");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    @Override
    public void call(Action action) {
        this.print(action);
    }

    @Override
    public void gotoFrame2(GotoFrame2 gotoFrame2) {
        this.start(gotoFrame2);
        this.out.println(" " + gotoFrame2.playFlag);
    }

    @Override
    public void quickTime(Action action) {
        this.print(action);
    }

    @Override
    public void unknown(Unknown unknown) {
        this.print(unknown);
    }

    public static String quoteString(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append(c);
        block9: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '\b': {
                    stringBuilder.append("\\v");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    private static class LabelMap
    extends HashMap<Label, LabelEntry> {
        private static final long serialVersionUID = -7907644739362458461L;

        private LabelMap() {
        }

        LabelEntry getLabelEntry(Label label) {
            LabelEntry labelEntry = (LabelEntry)this.get(label);
            if (labelEntry == null) {
                labelEntry = new LabelEntry(null, null);
                this.put(label, labelEntry);
            }
            return labelEntry;
        }
    }

    private static class LabelEntry {
        String name;
        Action source;

        public LabelEntry(String string, Action action) {
            this.name = string;
            this.source = action;
        }
    }
}

