/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.problems;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.flex.compiler.Messages;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.problems.CompilerProblem;

public final class EmbedSourceAttributeDoesNotExistProblem
extends CompilerProblem {
    public static final String DESCRIPTION = "Could not find Embed source '${embedSource}'. Searched ${locations}";
    public static final int errorCode = 1353;
    public final String embedSource;
    public final String locations;

    public EmbedSourceAttributeDoesNotExistProblem(ISourceLocation site, String embedSource, Map<String, String> searchedLocations) {
        super(site);
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = searchedLocations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String path = entry.getKey();
            String format = entry.getValue();
            String message = Messages.getString(format, Collections.singletonMap("path", path));
            sb.append(message);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        this.embedSource = embedSource;
        this.locations = sb.toString();
    }
}

