/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions.references;

import org.apache.flex.abc.semantics.Name;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.definitions.AppliedVectorDefinitionFactory;
import org.apache.flex.compiler.definitions.IAppliedVectorDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.projects.ICompilerProject;

public class ParameterizedReference
implements IReference {
    private final IReference name;
    private final IReference param;

    public ParameterizedReference(IReference name, IReference param) {
        this.name = name;
        this.param = param;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ASScope scope, DependencyType dependencyType, boolean canEscapeWith) {
        ITypeDefinition vectorType;
        ITypeDefinition baseType;
        IDefinition base = this.name.resolve(project, scope, dependencyType, canEscapeWith);
        IDefinition typeParam = this.param.resolve(project, scope, dependencyType, canEscapeWith);
        IAppliedVectorDefinition resolvedType = null;
        if (base instanceof ITypeDefinition && typeParam instanceof ITypeDefinition && (baseType = (ITypeDefinition)base) == (vectorType = project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR))) {
            resolvedType = AppliedVectorDefinitionFactory.newVector(project, (ITypeDefinition)typeParam);
        }
        return resolvedType;
    }

    @Override
    public String getDisplayString() {
        return this.name.getDisplayString() + ".<" + (this.param == null ? "" : this.param.getDisplayString()) + ">";
    }

    @Override
    public Name getMName(ICompilerProject project, ASScope scope) {
        Name baseName = this.name.getMName(project, scope);
        Name paramName = this.param.getMName(project, scope);
        return new Name(baseName, paramName);
    }
}

