/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.as.codegen;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flex.abc.semantics.Label;
import org.apache.flex.compiler.internal.as.codegen.ControlFlowContext;
import org.apache.flex.compiler.internal.tree.as.BlockNode;
import org.apache.flex.compiler.internal.tree.as.ConditionalNode;
import org.apache.flex.compiler.internal.tree.as.IfNode;
import org.apache.flex.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.flex.compiler.internal.tree.as.SwitchNode;
import org.apache.flex.compiler.internal.tree.as.TerminalNode;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;

class LabelScopeControlFlowContext
extends ControlFlowContext {
    private Multimap<String, LabeledStatementNode> labelNameToLabeledStatments;
    private final Map<String, Label> aetLabelMap = new HashMap<String, Label>();

    public LabelScopeControlFlowContext(IASNode controlFlowTreeNode) {
        super(controlFlowTreeNode);
    }

    private Multimap<String, LabeledStatementNode> getLabelMap() {
        if (this.labelNameToLabeledStatments != null) {
            return this.labelNameToLabeledStatments;
        }
        this.labelNameToLabeledStatments = LinkedListMultimap.create();
        LabelScopeControlFlowContext.populateLabelMap(this.labelNameToLabeledStatments, this.controlFlowTreeNode);
        return this.labelNameToLabeledStatments;
    }

    private static void populateLabelMap(Multimap<String, LabeledStatementNode> labelMap, IASNode node) {
        ASTNodeID nodeID = node.getNodeID();
        switch (nodeID) {
            case IfStatementID: {
                IfNode ifNode = (IfNode)node;
                int nIfNodeChildren = ifNode.getChildCount();
                for (int i = 0; i < nIfNodeChildren; ++i) {
                    IASNode ifNodeChild = ifNode.getChild(i);
                    if (ifNodeChild instanceof ConditionalNode) {
                        ConditionalNode conditionalNode = (ConditionalNode)ifNodeChild;
                        BlockNode conditionalBlockNode = conditionalNode.getContentsNode();
                        assert (conditionalBlockNode != null);
                        LabelScopeControlFlowContext.populateLabelMap(labelMap, conditionalBlockNode);
                        continue;
                    }
                    if (!(ifNodeChild instanceof TerminalNode)) continue;
                    TerminalNode terminalNode = (TerminalNode)ifNodeChild;
                    BlockNode terminalBlockNode = terminalNode.getContentsNode();
                    assert (terminalBlockNode != null);
                    LabelScopeControlFlowContext.populateLabelMap(labelMap, terminalBlockNode);
                }
                break;
            }
            case LabledStatementID: {
                LabeledStatementNode labelNode = (LabeledStatementNode)node;
                String labelName = labelNode.getLabel();
                if (labelName != null) {
                    labelMap.put((Object)labelName, (Object)labelNode);
                }
                LabelScopeControlFlowContext.populateLabelMap(labelMap, labelNode.getLabeledStatement());
                break;
            }
            case FileID: 
            case BlockID: 
            case MXMLEventSpecifierID: {
                int childCount = node.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    IASNode child = node.getChild(i);
                    assert (child != null);
                    LabelScopeControlFlowContext.populateLabelMap(labelMap, child);
                }
                break;
            }
            case SwitchID: {
                SwitchNode switchNode = (SwitchNode)node;
                LabelScopeControlFlowContext.populateLabelMap(labelMap, switchNode.getStatementContentsNode());
                break;
            }
            case ConditionalID: {
                ConditionalNode conditionalNode = (ConditionalNode)node;
                LabelScopeControlFlowContext.populateLabelMap(labelMap, conditionalNode.getStatementContentsNode());
            }
        }
    }

    Collection<LabeledStatementNode> getLabelNodes(String label) {
        Multimap<String, LabeledStatementNode> labelMap = this.getLabelMap();
        return labelMap.get((Object)label);
    }

    @Override
    Label getGotoLabel(String label) {
        assert (!this.getLabelNodes(label).isEmpty()) : "Don't try to get AET labels for labels not in this context!";
        Label result = this.aetLabelMap.get(label);
        if (result != null) {
            return result;
        }
        result = new Label(label);
        this.aetLabelMap.put(label, result);
        return result;
    }

    @Override
    boolean hasGotoLabel(String label, boolean allowDuplicates) {
        Multimap<String, LabeledStatementNode> labelMap = this.getLabelMap();
        if (allowDuplicates) {
            return labelMap.containsKey((Object)label);
        }
        return labelMap.get((Object)label).size() == 1;
    }
}

