/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.util;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public abstract class ServiceUtils {
    public static <T> T safeGetService(BundleContext ctx, ServiceReference<T> ref) {
        try {
            return (T)ctx.getService(ref);
        }
        catch (IllegalArgumentException | IllegalStateException | ServiceException throwable) {
            return null;
        }
    }

    public static <T> void safeUngetService(BundleContext ctx, ServiceReference<T> ref) {
        try {
            ctx.ungetService(ref);
        }
        catch (IllegalArgumentException | IllegalStateException | ServiceException throwable) {
            // empty catch block
        }
    }

    public static <T> T safeGetServiceObjects(BundleContext ctx, ServiceReference<T> ref) {
        if (ctx != null) {
            try {
                ServiceObjects so = ctx.getServiceObjects(ref);
                return (T)(so == null ? null : so.getService());
            }
            catch (IllegalArgumentException | IllegalStateException | ServiceException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> void safeUngetServiceObjects(BundleContext ctx, ServiceReference<T> ref, T service) {
        if (ctx != null && service != null) {
            try {
                ServiceObjects so = ctx.getServiceObjects(ref);
                if (so != null) {
                    so.ungetService(service);
                }
            }
            catch (IllegalArgumentException | IllegalStateException | ServiceException throwable) {
                // empty catch block
            }
        }
    }
}

