/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.TlsVersion;

class OkHttpClientBuilderImpl
extends StandardHttpClientBuilder<OkHttpClientImpl, OkHttpClientFactory, OkHttpClientBuilderImpl> {
    private final OkHttpClient.Builder builder;

    public OkHttpClientBuilderImpl(OkHttpClientFactory clientFactory, OkHttpClient.Builder builder) {
        super((HttpClient.Factory)clientFactory);
        this.builder = builder;
    }

    OkHttpClient.Builder getBuilder() {
        return this.builder;
    }

    public OkHttpClientImpl build() {
        if (this.client != null) {
            return this.completeBuild(((OkHttpClientImpl)this.client).getOkHttpClient().newBuilder(), true);
        }
        return this.initialBuild(this.builder);
    }

    public OkHttpClientImpl initialBuild(OkHttpClient.Builder builder) {
        if (this.connectTimeout != null) {
            builder.connectTimeout(this.connectTimeout);
        }
        if (this.sslContext != null) {
            X509TrustManager trustManager = null;
            if (this.trustManagers != null && this.trustManagers.length == 1) {
                trustManager = (X509TrustManager)this.trustManagers[0];
            }
            builder.sslSocketFactory(this.sslContext.getSocketFactory(), trustManager);
        }
        if (this.followRedirects) {
            builder.followRedirects(true).followSslRedirects(true);
        }
        if (this.proxyType == HttpClient.ProxyType.DIRECT) {
            builder.proxy(Proxy.NO_PROXY);
        } else if (this.proxyAddress != null) {
            builder.proxy(new Proxy(this.convertProxyType(), this.proxyAddress));
            if (this.proxyAuthorization != null) {
                builder.proxyAuthenticator((route, response) -> response.request().newBuilder().header("Proxy-Authorization", this.proxyAuthorization).build());
            }
        }
        if (this.tlsVersions != null) {
            ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions((TlsVersion[])Arrays.stream(this.tlsVersions).map(tls -> TlsVersion.valueOf((String)tls.name())).toArray(TlsVersion[]::new)).build();
            builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        }
        if (this.preferHttp11) {
            builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        }
        return this.completeBuild(builder, false);
    }

    private Proxy.Type convertProxyType() {
        switch (this.proxyType) {
            case DIRECT: {
                return Proxy.Type.DIRECT;
            }
            case HTTP: {
                return Proxy.Type.HTTP;
            }
            case SOCKS4: 
            case SOCKS5: {
                return Proxy.Type.SOCKS;
            }
        }
        throw new KubernetesClientException("Unsupported proxy type");
    }

    private OkHttpClientImpl completeBuild(OkHttpClient.Builder builder, boolean derived) {
        if (this.authenticatorNone) {
            builder.authenticator(Authenticator.NONE);
        }
        if (!derived) {
            ((OkHttpClientFactory)this.clientFactory).additionalConfig(builder);
        }
        OkHttpClient client = builder.build();
        return new OkHttpClientImpl(client, this, new AtomicBoolean());
    }

    protected OkHttpClientBuilderImpl newInstance(OkHttpClientFactory clientFactory) {
        return new OkHttpClientBuilderImpl(clientFactory, this.builder);
    }
}

