/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.util.Date;
import org.apache.torque.templates.platform.PlatformDefaultImpl;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformOracleImpl
extends PlatformDefaultImpl {
    private static final String DATE_FORMAT = "'to_date('''yyyy-MM-dd''',''yyyy-mm-dd'')'";
    private static final String TIME_FORMAT = "'to_date('''1970-01-01 HH:mm:ss''',''yyyy-mm-dd hh24:mi:ss'')'";
    private static final String TIMESTAMP_FORMAT = "'to_timestamp('''yyyy-MM-dd HH:mm:ss''',''yyyy-mm-dd hh24:mi:ss'')'";

    public PlatformOracleImpl() {
        this.initialize();
    }

    private void initialize() {
        this.setSchemaTypeToSqlTypeMapping(SchemaType.TINYINT, new SqlType("NUMBER", "3", "0"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.SMALLINT, new SqlType("NUMBER", "5", "0"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.INTEGER, new SqlType("NUMBER", "10", "0"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANINT, new SqlType("NUMBER", "1", "0"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BIGINT, new SqlType("NUMBER", "20", "0"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.REAL, new SqlType("NUMBER"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.DOUBLE, new SqlType("NUMBER"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.DECIMAL, new SqlType("NUMBER"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.NUMERIC, new SqlType("NUMBER"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.VARCHAR, new SqlType("VARCHAR2"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARCHAR, new SqlType("VARCHAR2", "2000"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.TIME, new SqlType("DATE"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BINARY, new SqlType("BLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.VARBINARY, new SqlType("BLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARBINARY, new SqlType("BLOB"));
    }

    @Override
    public String getAutoIncrement() {
        return "";
    }

    @Override
    protected boolean escapeBackslashes() {
        return true;
    }

    @Override
    public String getSizeSuffix(String sqlType) {
        if ("VARCHAR2".equals(sqlType)) {
            return " CHAR";
        }
        return "";
    }

    @Override
    public String getDateString(Date date) {
        return this.formatDateTimeString(date, DATE_FORMAT);
    }

    @Override
    public String getTimeString(Date date) {
        return this.formatDateTimeString(date, TIME_FORMAT);
    }

    @Override
    public String getTimestampString(Date date) {
        return this.formatDateTimeString(date, TIMESTAMP_FORMAT);
    }

    @Override
    public boolean hasSize(String sqlType) {
        return !"BLOB".equals(sqlType) && !"CLOB".equals(sqlType);
    }

    @Override
    public boolean hasScale(String sqlType) {
        return "TIMESTAMP".equals(sqlType) || "NUMBER".equals(sqlType);
    }
}

