/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.corruptio;

import java.io.File;
import java.io.IOException;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derbyTesting.functionTests.util.corruptio.CorruptibleIo;

public class CorruptRandomAccessFile
implements StorageRandomAccessFile {
    private StorageRandomAccessFile realRaf;
    private CorruptibleIo cbio;
    private File realFile;

    CorruptRandomAccessFile(StorageRandomAccessFile storageRandomAccessFile, File file) {
        this.realRaf = storageRandomAccessFile;
        this.cbio = CorruptibleIo.getInstance();
        this.realFile = file;
    }

    public CorruptRandomAccessFile clone() {
        return new CorruptRandomAccessFile(this.realRaf.clone(), this.realFile);
    }

    public void close() throws IOException {
        this.realRaf.close();
    }

    public long getFilePointer() throws IOException {
        return this.realRaf.getFilePointer();
    }

    public long length() throws IOException {
        return this.realRaf.length();
    }

    public void seek(long l) throws IOException {
        this.realRaf.seek(l);
    }

    public void setLength(long l) throws IOException {
        this.realRaf.setLength(l);
    }

    public void sync() throws IOException {
        this.realRaf.sync();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.realRaf.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.realRaf.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.realRaf.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.realRaf.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.realRaf.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.realRaf.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.realRaf.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.realRaf.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.realRaf.readChar();
    }

    public int readInt() throws IOException {
        return this.realRaf.readInt();
    }

    public long readLong() throws IOException {
        return this.realRaf.readLong();
    }

    public float readFloat() throws IOException {
        return this.realRaf.readFloat();
    }

    public double readDouble() throws IOException {
        return this.realRaf.readDouble();
    }

    public String readLine() throws IOException {
        return this.realRaf.readLine();
    }

    public String readUTF() throws IOException {
        return this.realRaf.readUTF();
    }

    public void write(int n) throws IOException {
        this.realRaf.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.realRaf.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.cbio.isCorruptibleFile(this.realFile)) {
            this.cbio.corrupt(byArray, n, n2);
        }
        this.realRaf.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.realRaf.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.realRaf.writeByte(n);
    }

    public void writeShort(int n) throws IOException {
        this.realRaf.writeShort(n);
    }

    public void writeChar(int n) throws IOException {
        this.realRaf.writeChar(n);
    }

    public void writeInt(int n) throws IOException {
        this.realRaf.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.realRaf.writeLong(l);
    }

    public void writeFloat(float f) throws IOException {
        this.realRaf.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        this.realRaf.writeDouble(d);
    }

    public void writeBytes(String string) throws IOException {
        this.realRaf.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.realRaf.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        this.realRaf.writeUTF(string);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.realRaf.read(byArray, n, n2);
    }
}

