/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5158Test
extends BaseJDBCTestCase {
    public Derby5158Test(String string) {
        super(string);
    }

    protected static Test makeSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        Test test = TestConfiguration.defaultSuite(Derby5158Test.class);
        baseTestSuite.addTest(test);
        return baseTestSuite;
    }

    public static Test suite() {
        String string = "Derby5158Repro";
        return Derby5158Test.makeSuite(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setAutoCommit(false);
    }

    public void testCommitRollbackAfterShutdown() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select 1 from sys.systables");
        resultSet.close();
        statement.close();
        TestConfiguration.getCurrent().shutdownDatabase();
        try {
            this.commit();
        }
        catch (SQLException sQLException) {
            if (Derby5158Test.usingEmbedded()) {
                Derby5158Test.assertSQLState("08003", sQLException);
            }
            Derby5158Test.assertSQLState("08006", sQLException);
        }
        statement = this.createStatement();
        resultSet = statement.executeQuery("select 1 from sys.systables");
        resultSet.close();
        statement.close();
        TestConfiguration.getCurrent().shutdownDatabase();
        try {
            this.rollback();
        }
        catch (SQLException sQLException) {
            if (Derby5158Test.usingEmbedded()) {
                Derby5158Test.assertSQLState("08003", sQLException);
            }
            Derby5158Test.assertSQLState("08006", sQLException);
        }
    }
}

